/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod.tx.table.functions;

import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Set;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.functional.EntryView;
import org.infinispan.functional.MetaParam;
import org.infinispan.server.hotrod.tx.table.CacheXid;
import org.infinispan.server.hotrod.tx.table.Status;
import org.infinispan.server.hotrod.tx.table.TxState;
import org.infinispan.server.hotrod.tx.table.functions.TxFunction;

public class SetPreparedFunction
extends TxFunction {
    public static final AdvancedExternalizer<SetPreparedFunction> EXTERNALIZER = new Externalizer();

    @Override
    public Byte apply(EntryView.ReadWriteEntryView<CacheXid, TxState> view) {
        if (view.find().isPresent()) {
            TxState state = (TxState)view.get();
            if (state.getStatus() != Status.PREPARING) {
                return state.getStatus().value;
            }
            view.set((Object)state.setStatus(Status.PREPARED, false, this.timeService), new MetaParam.Writable[0]);
            return Status.OK.value;
        }
        return Status.NO_TRANSACTION.value;
    }

    private static class Externalizer
    implements AdvancedExternalizer<SetPreparedFunction> {
        private Externalizer() {
        }

        public Set<Class<? extends SetPreparedFunction>> getTypeClasses() {
            return Collections.singleton(SetPreparedFunction.class);
        }

        public Integer getId() {
            return null;
        }

        public void writeObject(ObjectOutput output, SetPreparedFunction object) {
        }

        public SetPreparedFunction readObject(ObjectInput input) {
            return new SetPreparedFunction();
        }
    }
}

