/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.spring.provider;

import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.spring.AbstractEmbeddedCacheManagerFactory;
import org.infinispan.spring.provider.SpringEmbeddedCacheManager;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;

public class SpringEmbeddedCacheManagerFactoryBean
extends AbstractEmbeddedCacheManagerFactory
implements FactoryBean<SpringEmbeddedCacheManager>,
InitializingBean,
DisposableBean {
    private SpringEmbeddedCacheManager cacheManager;

    public void afterPropertiesSet() throws Exception {
        this.logger.info((Object)"Initializing SpringEmbeddedCacheManager instance ...");
        EmbeddedCacheManager nativeEmbeddedCacheManager = this.createBackingEmbeddedCacheManager();
        this.cacheManager = new SpringEmbeddedCacheManager(nativeEmbeddedCacheManager);
        this.logger.info((Object)("Successfully initialized SpringEmbeddedCacheManager instance [" + this.cacheManager + "]"));
    }

    public SpringEmbeddedCacheManager getObject() throws Exception {
        return this.cacheManager;
    }

    public Class<? extends SpringEmbeddedCacheManager> getObjectType() {
        return this.cacheManager != null ? this.cacheManager.getClass() : SpringEmbeddedCacheManager.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void destroy() throws Exception {
        if (this.cacheManager != null) {
            this.cacheManager.stop();
        }
    }
}

