/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.spring.session;

import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.infinispan.spring.provider.SpringCache;
import org.infinispan.spring.session.AbstractInfinispanSessionRepository;
import org.infinispan.spring.session.EmbeddedApplicationPublishedBridge;
import org.infinispan.spring.session.PrincipalNameResolver;
import org.springframework.session.FindByIndexNameSessionRepository;
import org.springframework.session.MapSession;
import org.springframework.session.Session;

public class InfinispanEmbeddedSessionRepository
extends AbstractInfinispanSessionRepository
implements FindByIndexNameSessionRepository<MapSession> {
    protected final PrincipalNameResolver principalNameResolver = new PrincipalNameResolver();

    public InfinispanEmbeddedSessionRepository(SpringCache cache) {
        super(cache, new EmbeddedApplicationPublishedBridge(cache));
    }

    public Map<String, MapSession> findByIndexNameAndIndexValue(String indexName, String indexValue) {
        if (!PRINCIPAL_NAME_INDEX_NAME.equals(indexName)) {
            return Collections.emptyMap();
        }
        return this.cache.getNativeCache().values().stream().map(cacheValue -> (MapSession)cacheValue).filter(session -> indexValue.equals(this.principalNameResolver.resolvePrincipal((Session)session))).collect(Collectors.toMap(MapSession::getId, Function.identity()));
    }
}

