/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.spring.session.configuration;

import java.util.Map;
import java.util.Objects;
import org.infinispan.spring.provider.SpringCache;
import org.infinispan.spring.provider.SpringRemoteCacheManager;
import org.infinispan.spring.session.InfinispanRemoteSessionRepository;
import org.infinispan.spring.session.configuration.EnableInfinispanRemoteHttpSession;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportAware;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.session.MapSession;
import org.springframework.session.config.annotation.web.http.SpringHttpSessionConfiguration;

@Configuration
public class InfinispanRemoteHttpSessionConfiguration
extends SpringHttpSessionConfiguration
implements ImportAware {
    private String cacheName;
    private int maxInactiveIntervalInSeconds;

    @Bean
    public InfinispanRemoteSessionRepository sessionRepository(SpringRemoteCacheManager cacheManager, ApplicationEventPublisher eventPublisher) {
        Objects.requireNonNull(this.cacheName, "Cache name can not be null");
        Objects.requireNonNull(cacheManager, "Cache Manager can not be null");
        Objects.requireNonNull(eventPublisher, "Event Publisher can not be null");
        SpringCache cacheForSessions = cacheManager.getCache(this.cacheName);
        InfinispanRemoteSessionRepository sessionRepository = new InfinispanRemoteSessionRepository(cacheForSessions){

            @Override
            public MapSession createSession() {
                MapSession session = super.createSession();
                session.setMaxInactiveIntervalInSeconds(InfinispanRemoteHttpSessionConfiguration.this.maxInactiveIntervalInSeconds);
                return session;
            }
        };
        sessionRepository.setApplicationEventPublisher(eventPublisher);
        return sessionRepository;
    }

    public void setImportMetadata(AnnotationMetadata importMetadata) {
        Map enableAttrMap = importMetadata.getAnnotationAttributes(EnableInfinispanRemoteHttpSession.class.getName());
        AnnotationAttributes annotationAttributes = AnnotationAttributes.fromMap((Map)enableAttrMap);
        this.cacheName = annotationAttributes.getString("cacheName");
        this.maxInactiveIntervalInSeconds = annotationAttributes.getNumber("maxInactiveIntervalInSeconds").intValue();
    }
}

