/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tasks.impl;

import java.lang.invoke.MethodHandles;
import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentMap;
import javax.security.auth.Subject;
import org.infinispan.commons.util.CollectionFactory;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.security.Security;
import org.infinispan.tasks.TaskContext;
import org.infinispan.tasks.TaskExecution;
import org.infinispan.tasks.TaskManager;
import org.infinispan.tasks.impl.TaskExecutionImpl;
import org.infinispan.tasks.logging.Log;
import org.infinispan.tasks.spi.TaskEngine;
import org.infinispan.util.TimeService;
import org.infinispan.util.logging.LogFactory;

@Scope(value=Scopes.GLOBAL)
public class TaskManagerImpl
implements TaskManager {
    private static final Log log = (Log)LogFactory.getLog(MethodHandles.lookup().lookupClass(), Log.class);
    private EmbeddedCacheManager cacheManager;
    private Set<TaskEngine> engines = new HashSet<TaskEngine>();
    private ConcurrentMap<UUID, TaskExecution> runningTasks = CollectionFactory.makeConcurrentMap();
    private TimeService timeService;
    private boolean useSecurity;

    @Inject
    public void initialize(EmbeddedCacheManager cacheManager, TimeService timeService) {
        this.cacheManager = cacheManager;
        this.timeService = timeService;
        this.useSecurity = cacheManager.getCacheManagerConfiguration().security().authorization().enabled();
    }

    public synchronized void registerTaskEngine(TaskEngine engine) {
        if (this.engines.contains(engine)) {
            throw log.duplicateTaskEngineRegistration(engine.getName());
        }
        this.engines.add(engine);
    }

    @Override
    public <T> CompletableFuture<T> runTask(String name, TaskContext context) {
        for (TaskEngine engine : this.engines) {
            Optional<String> who;
            if (!engine.handles(name)) continue;
            Address address = this.cacheManager.getAddress();
            if (this.useSecurity) {
                Subject subject = Security.getSubject();
                Principal userPrincipal = Security.getSubjectUserPrincipal((Subject)subject);
                who = Optional.of(userPrincipal.getName());
            } else {
                who = Optional.empty();
            }
            TaskExecutionImpl exec = new TaskExecutionImpl(name, address == null ? "local" : address.toString(), who, context);
            exec.setStart(this.timeService.instant());
            this.runningTasks.put(exec.getUUID(), exec);
            CompletableFuture task = engine.runTask(name, context);
            return task.whenComplete((r, e) -> {
                if (e != null) {
                    e.printStackTrace();
                }
                this.runningTasks.remove(exec.getUUID());
            });
        }
        throw log.unknownTask(name);
    }

    @Override
    public Collection<TaskExecution> getCurrentTasks() {
        return this.runningTasks.values();
    }

    @Override
    public Collection<TaskEngine> getEngines() {
        return Collections.unmodifiableCollection(this.engines);
    }
}

