/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.util;

import java.util.ArrayList;
import java.util.List;
import org.instancio.internal.util.IgnoreJRERequirement;
import org.instancio.internal.util.ReflectionUtils;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@IgnoreJRERequirement
public final class SealedClassUtils {
    public static List<Class<?>> getSealedClassImplementations(Class<?> sealedClass) {
        ArrayList results = new ArrayList();
        for (Class<?> subclass : sealedClass.getPermittedSubclasses()) {
            if (subclass.isSealed()) {
                results.addAll(SealedClassUtils.getSealedClassImplementations(subclass));
                continue;
            }
            results.add(subclass);
        }
        return results;
    }

    public static boolean isSealedAbstractType(Class<?> klass) {
        return klass.isSealed() && ReflectionUtils.isInterfaceOrAbstract(klass);
    }

    private SealedClassUtils() {
    }
}

