/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal;

import java.util.Collection;
import org.instancio.InstancioGenApi;
import org.instancio.Random;
import org.instancio.generator.GeneratorContext;
import org.instancio.generator.specs.BooleanSpec;
import org.instancio.generator.specs.ByteSpec;
import org.instancio.generator.specs.CharacterSpec;
import org.instancio.generator.specs.DoubleSpec;
import org.instancio.generator.specs.EnumSpec;
import org.instancio.generator.specs.FloatSpec;
import org.instancio.generator.specs.HashSpec;
import org.instancio.generator.specs.IntegerSpec;
import org.instancio.generator.specs.IntervalSpec;
import org.instancio.generator.specs.LongSpec;
import org.instancio.generator.specs.NumericSequenceSpec;
import org.instancio.generator.specs.OneOfArraySpec;
import org.instancio.generator.specs.OneOfCollectionSpec;
import org.instancio.generator.specs.ShortSpec;
import org.instancio.generator.specs.ShuffleSpec;
import org.instancio.generator.specs.StringSpec;
import org.instancio.generator.specs.UUIDSpec;
import org.instancio.generators.ChecksumSpecs;
import org.instancio.generators.FinanceSpecs;
import org.instancio.generators.IdSpecs;
import org.instancio.generators.IoSpecs;
import org.instancio.generators.MathSpecs;
import org.instancio.generators.NetSpecs;
import org.instancio.generators.NioSpecs;
import org.instancio.generators.SpatialSpecs;
import org.instancio.generators.TemporalSpecs;
import org.instancio.generators.TextSpecs;
import org.instancio.internal.ApiValidator;
import org.instancio.internal.RandomHelper;
import org.instancio.internal.generators.BuiltInGenerators;
import org.instancio.settings.Keys;
import org.instancio.settings.SettingKey;
import org.instancio.settings.Settings;
import org.instancio.support.Global;
import org.instancio.support.ThreadLocalSettings;

public final class GenApiImpl
implements InstancioGenApi {
    private Settings settings = Global.getPropertiesFileSettings().merge(ThreadLocalSettings.getInstance().get());

    @Override
    public InstancioGenApi withSettings(Settings settings) {
        ApiValidator.notNull(settings, "'settings' must not be null");
        this.settings = this.settings.merge(settings);
        return this;
    }

    @Override
    public <V> InstancioGenApi withSetting(SettingKey<V> key, V value) {
        this.settings.set(key, value);
        return this;
    }

    private BuiltInGenerators generators() {
        Random random = RandomHelper.resolveRandom(this.settings.get(Keys.SEED), null);
        return new BuiltInGenerators(new GeneratorContext(this.settings, random));
    }

    @Override
    public BooleanSpec booleans() {
        return this.generators().booleans();
    }

    @Override
    public CharacterSpec chars() {
        return this.generators().chars();
    }

    @Override
    public StringSpec string() {
        return this.generators().string();
    }

    @Override
    public ByteSpec bytes() {
        return this.generators().bytes();
    }

    @Override
    public ShortSpec shorts() {
        return this.generators().shorts();
    }

    @Override
    public IntegerSpec ints() {
        return this.generators().ints();
    }

    @Override
    public NumericSequenceSpec<Integer> intSeq() {
        return this.generators().intSeq();
    }

    @Override
    public LongSpec longs() {
        return this.generators().longs();
    }

    @Override
    public NumericSequenceSpec<Long> longSeq() {
        return this.generators().longSeq();
    }

    @Override
    public FloatSpec floats() {
        return this.generators().floats();
    }

    @Override
    public DoubleSpec doubles() {
        return this.generators().doubles();
    }

    @Override
    public <E extends Enum<E>> EnumSpec<E> enumOf(Class<E> enumClass) {
        return this.generators().enumOf((Class)enumClass);
    }

    @Override
    @SafeVarargs
    public final <T> OneOfArraySpec<T> oneOf(T ... choices) {
        return this.generators().oneOf((Object[])choices);
    }

    @Override
    public <T> OneOfCollectionSpec<T> oneOf(Collection<T> choices) {
        return this.generators().oneOf((Collection)choices);
    }

    @Override
    public <T> IntervalSpec<T> intervalStarting(T startingValue) {
        return this.generators().intervalStarting(startingValue);
    }

    @Override
    public <T> ShuffleSpec<T> shuffle(T ... array) {
        return this.generators().shuffle(array);
    }

    @Override
    public <T> ShuffleSpec<T> shuffle(Collection<T> collection) {
        return this.generators().shuffle(collection);
    }

    @Override
    public IoSpecs io() {
        return this.generators().io();
    }

    @Override
    public MathSpecs math() {
        return this.generators().math();
    }

    @Override
    public NetSpecs net() {
        return this.generators().net();
    }

    @Override
    public NioSpecs nio() {
        return this.generators().nio();
    }

    @Override
    public TemporalSpecs temporal() {
        return this.generators().temporal();
    }

    @Override
    public TextSpecs text() {
        return this.generators().text();
    }

    @Override
    public UUIDSpec uuid() {
        return this.generators().uuid();
    }

    @Override
    public ChecksumSpecs checksum() {
        return this.generators().checksum();
    }

    @Override
    public IdSpecs id() {
        return this.generators().id();
    }

    @Override
    public HashSpec hash() {
        return this.generators().hash();
    }

    @Override
    public FinanceSpecs finance() {
        return this.generators().finance();
    }

    @Override
    public SpatialSpecs spatial() {
        return this.generators().spatial();
    }
}

