/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.annotation;

import java.lang.annotation.Annotation;
import org.instancio.generator.GeneratorSpec;
import org.instancio.generator.specs.StringGeneratorSpec;
import org.instancio.internal.annotation.AnnotationHandlerMap;
import org.instancio.internal.annotation.AnnotationUtils;
import org.instancio.internal.annotation.FieldAnnotationHandler;
import org.instancio.internal.generator.specs.InternalFractionalNumberGeneratorSpec;
import org.instancio.internal.util.Range;
import org.instancio.settings.Keys;

class CommonPersistenceAnnotationHandlerMap
extends AnnotationHandlerMap {
    CommonPersistenceAnnotationHandlerMap() {
    }

    static abstract class AbstractColumnHandler
    implements FieldAnnotationHandler {
        AbstractColumnHandler() {
        }

        abstract int getLength(Annotation var1);

        abstract int getPrecision(Annotation var1);

        abstract int getScale(Annotation var1);

        @Override
        public final void process(Annotation annotation, GeneratorSpec<?> spec, Class<?> targetClass) {
            if (spec instanceof StringGeneratorSpec) {
                int maxLength = this.getLength(annotation);
                int minLength = Math.min(maxLength, Keys.STRING_MIN_LENGTH.defaultValue());
                Range<Integer> range = AnnotationUtils.calculateRange(minLength, maxLength, Keys.STRING_MAX_LENGTH.defaultValue());
                StringGeneratorSpec stringSpec = (StringGeneratorSpec)spec;
                stringSpec.length(range.min(), range.max());
            } else if (spec instanceof InternalFractionalNumberGeneratorSpec) {
                int precision = this.getPrecision(annotation);
                int scale = this.getScale(annotation);
                InternalFractionalNumberGeneratorSpec fractionalSpec = (InternalFractionalNumberGeneratorSpec)spec;
                if (precision > 0) {
                    fractionalSpec.precision(precision).scale(scale);
                } else if (scale != 0) {
                    fractionalSpec.scale(scale);
                }
            }
        }
    }
}

