/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.generator.domain.id.bra;

import org.instancio.Random;
import org.instancio.generator.GeneratorContext;
import org.instancio.generator.specs.bra.TituloEleitoralSpec;
import org.instancio.internal.generator.AbstractGenerator;

public class TituloEleitoralGenerator
extends AbstractGenerator<String>
implements TituloEleitoralSpec {
    private static final int TITULO_LENGTH = 8;

    public TituloEleitoralGenerator(GeneratorContext context) {
        super(context);
    }

    @Override
    public String apiMethod() {
        return "tituloEleitoral()";
    }

    @Override
    public TituloEleitoralGenerator nullable() {
        super.nullable();
        return this;
    }

    @Override
    protected String tryGenerateNonNull(Random random) {
        String baseTitulo = random.digits(8);
        int firstDigitVerifier = this.generateFirstDigit(baseTitulo);
        int stateCode = random.intRange(1, 28);
        int secondDigitVerifier = this.generateSecondDigit(firstDigitVerifier, stateCode);
        return baseTitulo + (stateCode < 10 ? "0" + stateCode : Integer.valueOf(stateCode)) + firstDigitVerifier + secondDigitVerifier;
    }

    private int generateFirstDigit(String baseTitulo) {
        return this.generateDigit(baseTitulo, 2);
    }

    private int generateSecondDigit(int firstDigit, int stateCode) {
        if (stateCode < 10) {
            return this.generateDigit(String.format("0%d%d", stateCode, firstDigit), 7);
        }
        return this.generateDigit(String.format("%d%d", stateCode, firstDigit), 7);
    }

    private int generateDigit(String baseNumber, int initialWeight) {
        int weight = initialWeight;
        int sum = 0;
        for (char digit : baseNumber.toCharArray()) {
            sum += Character.getNumericValue(digit) * weight;
            ++weight;
        }
        if (sum % 11 == 10) {
            return 0;
        }
        return sum % 11;
    }
}

