/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.generator.domain.id.rus;

import org.instancio.Random;
import org.instancio.generator.GeneratorContext;
import org.instancio.generator.specs.rus.InnSpec;
import org.instancio.internal.generator.AbstractGenerator;

public class InnGenerator
extends AbstractGenerator<String>
implements InnSpec {
    private static final int[] INDIVIDUAL_WEIGHTS_11 = new int[]{7, 2, 4, 10, 3, 5, 9, 4, 6, 8};
    private static final int[] INDIVIDUAL_WEIGHTS_12 = new int[]{3, 7, 2, 4, 10, 3, 5, 9, 4, 6, 8};
    private static final int[] JURIDICAL_WEIGHTS = new int[]{2, 4, 10, 3, 5, 9, 4, 6, 8};
    private Type type;

    public InnGenerator(GeneratorContext context) {
        super(context);
    }

    @Override
    public InnGenerator individual() {
        this.type = Type.INDIVIDUAL;
        return this;
    }

    @Override
    public InnGenerator juridical() {
        this.type = Type.JURIDICAL;
        return this;
    }

    @Override
    public String apiMethod() {
        return "inn()";
    }

    @Override
    public InnGenerator nullable() {
        super.nullable();
        return this;
    }

    @Override
    protected String tryGenerateNonNull(Random random) {
        if (this.type == Type.INDIVIDUAL) {
            return this.generateIndividualInn(random);
        }
        if (this.type == Type.JURIDICAL) {
            return this.generateJuridicalInn(random);
        }
        return random.trueOrFalse() ? this.generateIndividualInn(random) : this.generateJuridicalInn(random);
    }

    private String generateIndividualInn(Random random) {
        String baseInn = random.digits(10);
        int firstCheck = this.getCheckSum(baseInn, INDIVIDUAL_WEIGHTS_11);
        int secondCheck = this.getCheckSum(baseInn + firstCheck, INDIVIDUAL_WEIGHTS_12);
        return baseInn + firstCheck + secondCheck;
    }

    private String generateJuridicalInn(Random random) {
        String baseInn = random.digits(9);
        int firstCheck = this.getCheckSum(baseInn, JURIDICAL_WEIGHTS);
        return baseInn + firstCheck;
    }

    private int getCheckSum(String digits, int ... weights) {
        int sum = 0;
        for (int i = 0; i < weights.length; ++i) {
            int digit = Character.getNumericValue(digits.charAt(i));
            sum += digit * weights[i];
        }
        return sum % 11 % 10;
    }

    private static enum Type {
        INDIVIDUAL,
        JURIDICAL;

    }
}

