/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.generator.sequence;

import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.instancio.Random;
import org.instancio.generator.GeneratorContext;
import org.instancio.generator.specs.NumericSequenceSpec;
import org.instancio.internal.ApiValidator;
import org.instancio.internal.generator.AbstractGenerator;

public abstract class AbstractNumericSequenceGenerator<T extends Number>
extends AbstractGenerator<T>
implements NumericSequenceSpec<T> {
    private T seq;
    private Function<T, T> next;

    AbstractNumericSequenceGenerator(GeneratorContext context) {
        super(context);
    }

    @Override
    public AbstractNumericSequenceGenerator<T> start(T start) {
        this.seq = (Number)ApiValidator.notNull(start, "sequence 'start' value must not be null");
        return this;
    }

    @Override
    public AbstractNumericSequenceGenerator<T> next(UnaryOperator<T> next) {
        this.next = ApiValidator.notNull(next, "sequence 'next' function must not be null");
        return this;
    }

    @Override
    public AbstractNumericSequenceGenerator<T> nullable() {
        super.nullable();
        return this;
    }

    @Override
    protected T tryGenerateNonNull(Random random) {
        T curr = this.seq;
        this.seq = (Number)this.next.apply(this.seq);
        return curr;
    }
}

