/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.instantiation;

import java.lang.reflect.Field;
import org.instancio.internal.util.ExceptionUtils;
import org.instancio.internal.util.ReflectionUtils;
import sun.misc.Unsafe;

final class UnsafeHelper {
    private final Unsafe unsafe = this.getUnsafe();

    private UnsafeHelper() {
    }

    static UnsafeHelper getInstance() {
        return Holder.INSTANCE;
    }

    <T> T allocateInstance(Class<T> klass) {
        if (this.unsafe == null) {
            return null;
        }
        try {
            return (T)this.unsafe.allocateInstance(klass);
        }
        catch (Exception ex) {
            ExceptionUtils.logException("Error instantiating {} using Unsafe", ex, klass);
            return null;
        }
    }

    private Unsafe getUnsafe() {
        try {
            Field[] fields;
            for (Field field : fields = Unsafe.class.getDeclaredFields()) {
                ReflectionUtils.setAccessible(field);
                Object obj = field.get(null);
                if (!(obj instanceof Unsafe)) continue;
                return (Unsafe)obj;
            }
        }
        catch (Throwable t) {
            ExceptionUtils.logException("Error getting Unsafe", t, new Object[0]);
        }
        return null;
    }

    private static final class Holder {
        private static final UnsafeHelper INSTANCE = new UnsafeHelper();

        private Holder() {
        }
    }
}

