/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.util;

import java.util.Objects;

public final class Range<T> {
    private final T min;
    private final T max;

    private Range(T min, T max) {
        this.min = min;
        this.max = max;
    }

    public static <T> Range<T> of(T min, T max) {
        return new Range<T>(min, max);
    }

    public T min() {
        return this.min;
    }

    public T max() {
        return this.max;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Range)) {
            return false;
        }
        Range range = (Range)o;
        return Objects.equals(this.min, range.min) && Objects.equals(this.max, range.max);
    }

    public int hashCode() {
        return Objects.hash(this.min, this.max);
    }

    public String toString() {
        return String.format("Range[%s, %s]", this.min, this.max);
    }
}

