/*
 * Decompiled with CFR 0.152.
 */
package org.iternine.jeppetto.testsupport;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.iternine.jeppetto.testsupport.DatabaseProvider;
import org.iternine.jeppetto.testsupport.JdbcDatabaseProvider;
import org.iternine.jeppetto.testsupport.db.Database;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.xml.XmlBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public class TestContext {
    private GenericApplicationContext applicationContext;
    private List<Database> databases;

    public TestContext(String configurationFilename, String propertiesFilename) {
        this(configurationFilename, propertiesFilename, (String)null);
    }

    public TestContext(String configurationFilename, String propertiesFilename, String driverClassNameProperty) {
        DatabaseProvider[] databaseProviderArray;
        if (driverClassNameProperty == null) {
            databaseProviderArray = null;
        } else {
            DatabaseProvider[] databaseProviderArray2 = new DatabaseProvider[1];
            databaseProviderArray = databaseProviderArray2;
            databaseProviderArray2[0] = new JdbcDatabaseProvider(driverClassNameProperty);
        }
        this(configurationFilename, propertiesFilename, databaseProviderArray);
    }

    public TestContext(String configurationFilename, String propertiesFilename, DatabaseProvider ... databaseProviders) {
        this.databases = new ArrayList<Database>();
        XmlBeanFactory xmlBeanFactory = new XmlBeanFactory((Resource)new ClassPathResource(configurationFilename));
        xmlBeanFactory.setBeanClassLoader(this.getClass().getClassLoader());
        Properties properties = new Properties();
        try {
            properties.load(new ClassPathResource(propertiesFilename).getInputStream());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (databaseProviders != null) {
            for (DatabaseProvider databaseProvider : databaseProviders) {
                properties = databaseProvider.modifyProperties(properties);
            }
        }
        PropertyPlaceholderConfigurer configurer = new PropertyPlaceholderConfigurer();
        configurer.setProperties(properties);
        configurer.postProcessBeanFactory((ConfigurableListableBeanFactory)xmlBeanFactory);
        try {
            this.applicationContext = new GenericApplicationContext((DefaultListableBeanFactory)xmlBeanFactory);
            this.applicationContext.refresh();
            if (databaseProviders != null) {
                for (DatabaseProvider databaseProvider : databaseProviders) {
                    this.databases.add(databaseProvider.getDatabase(properties, (ApplicationContext)this.applicationContext));
                }
            }
        }
        catch (RuntimeException e) {
            if (databaseProviders != null) {
                for (DatabaseProvider databaseProvider : databaseProviders) {
                    if (!(databaseProvider instanceof Closeable)) continue;
                    try {
                        ((Closeable)((Object)databaseProvider)).close();
                    }
                    catch (IOException e1) {
                        // empty catch block
                    }
                }
            }
            throw e;
        }
    }

    public void close() {
        for (Database database : this.databases) {
            if (database == null) continue;
            database.close();
        }
        this.applicationContext.close();
    }

    public Object getBean(String beanName) {
        return this.applicationContext.getBean(beanName);
    }

    public Database getDatabase() {
        return this.databases.get(0);
    }
}

