/*
 * Decompiled with CFR 0.152.
 */
package org.iternine.jeppetto.testsupport.db;

import org.iternine.jeppetto.testsupport.db.ConnectionSource;
import org.iternine.jeppetto.testsupport.db.Database;
import org.iternine.jeppetto.testsupport.db.HsqlDatabase;
import org.iternine.jeppetto.testsupport.db.MySQLDatabase;

public class DatabaseFactory {
    private DatabaseFactory() {
    }

    public static Database getDatabase(ConnectionSource connectionSource) {
        String driverClassName = connectionSource.getDriverClassName();
        if (driverClassName.contains("hsql")) {
            return new HsqlDatabase(connectionSource);
        }
        if (driverClassName.contains("mysql")) {
            return new MySQLDatabase(connectionSource);
        }
        throw new RuntimeException("Don't know what Database type to create for driver: " + driverClassName);
    }
}

