/*
 * Decompiled with CFR 0.152.
 */
package org.iternine.jeppetto.testsupport.db;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import org.dbunit.DatabaseUnitException;
import org.dbunit.database.DatabaseConfig;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.FilteredDataSet;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.datatype.DataType;
import org.dbunit.dataset.datatype.DataTypeException;
import org.dbunit.dataset.datatype.DefaultDataTypeFactory;
import org.dbunit.dataset.datatype.IDataTypeFactory;
import org.dbunit.dataset.xml.XmlDataSet;
import org.dbunit.operation.DatabaseOperation;
import org.iternine.jeppetto.testsupport.db.ConnectionSource;
import org.iternine.jeppetto.testsupport.db.Database;

public class HsqlDatabase
extends Database {
    private static IDataTypeFactory hsqlDataTypeFactory = new DefaultDataTypeFactory(){

        public DataType createDataType(int sqlType, String sqlTypeName) throws DataTypeException {
            if (sqlType == 16) {
                return DataType.BOOLEAN;
            }
            return super.createDataType(sqlType, sqlTypeName);
        }
    };

    public HsqlDatabase(ConnectionSource connectionSource) {
        super(connectionSource);
    }

    @Override
    public void close() {
        this.executeArbitrarySql("SHUTDOWN");
    }

    @Override
    protected void onNewIDatabaseConnection(IDatabaseConnection connection) {
        DatabaseConfig config = connection.getConfig();
        config.setProperty("http://www.dbunit.org/properties/datatypeFactory", (Object)hsqlDataTypeFactory);
    }

    @Override
    public void loadXmlDataSet(InputStream inputStream) {
        try {
            XmlDataSet dataSet = new XmlDataSet(inputStream);
            this.executeArbitrarySql("SET REFERENTIAL_INTEGRITY FALSE");
            DatabaseOperation.REFRESH.execute(this.getIDatabaseConnection(), (IDataSet)dataSet);
            this.executeArbitrarySql("SET REFERENTIAL_INTEGRITY TRUE");
        }
        catch (DatabaseUnitException e) {
            throw new RuntimeException(e);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void writeXmlDataSet(OutputStream outputStream, String[] tables) {
        try {
            IDataSet dataSet = this.getIDatabaseConnection().createDataSet();
            if (tables != null) {
                dataSet = new FilteredDataSet(tables, dataSet);
            }
            XmlDataSet.write((IDataSet)dataSet, (OutputStream)outputStream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (DataSetException e) {
            throw new RuntimeException(e);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void clearDatabase() {
        try {
            this.executeArbitrarySql("SET REFERENTIAL_INTEGRITY FALSE");
            IDatabaseConnection connection = this.getIDatabaseConnection();
            DatabaseOperation.DELETE_ALL.execute(connection, connection.createDataSet());
            this.executeArbitrarySql("SET REFERENTIAL_INTEGRITY TRUE");
        }
        catch (DatabaseUnitException e) {
            throw new RuntimeException(e);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }
}

