/*
 * Decompiled with CFR 0.152.
 */
package org.itest.json.simple.impl;

import java.util.HashMap;
import org.itest.json.simple.impl.SimpleJsonState;
import org.itest.json.simple.impl.SimpleJsonTokenizer;

public class SimpleJsonParser {
    public static SimpleJsonState readFrom(String in) {
        SimpleJsonTokenizer x = new SimpleJsonTokenizer(in);
        SimpleJsonState res = new SimpleJsonParser().read(x);
        return res;
    }

    private SimpleJsonState read(SimpleJsonTokenizer x) {
        SimpleJsonState res;
        char c = x.nextClean();
        x.back();
        switch (c) {
            case '{': {
                res = this.readJsonObject(x);
                break;
            }
            case '[': {
                res = this.readJsonArray(x);
                break;
            }
            default: {
                res = SimpleJsonParser.readJsonValue(x);
            }
        }
        return res;
    }

    private static SimpleJsonState readJsonValue(SimpleJsonTokenizer x) {
        String value = x.nextValue();
        return new SimpleJsonState(value);
    }

    private SimpleJsonState readJsonArray(SimpleJsonTokenizer x) {
        HashMap<String, SimpleJsonState> elements = new HashMap<String, SimpleJsonState>();
        SimpleJsonState res = new SimpleJsonState(elements);
        if (x.nextClean() != '[') {
            throw x.syntaxError("A JSONArray text must start with '['");
        }
        int i = 0;
        block4: while (true) {
            char c = x.nextClean();
            switch (c) {
                case ',': {
                    elements.put(String.valueOf(i), null);
                    break;
                }
                case ']': {
                    break block4;
                }
                default: {
                    x.back();
                    elements.put(String.valueOf(i), this.read(x));
                    c = x.nextClean();
                    if (']' == c) break block4;
                    if (',' == c) break;
                    throw x.syntaxError("Expected a ',' or ']'");
                }
            }
            ++i;
        }
        return res;
    }

    private SimpleJsonState readJsonObject(SimpleJsonTokenizer x) {
        HashMap<String, SimpleJsonState> elements = new HashMap<String, SimpleJsonState>();
        SimpleJsonState res = new SimpleJsonState(elements);
        if (x.nextClean() != '{') {
            throw x.syntaxError("A JSONObject text must begin with '{'");
        }
        block8: while (true) {
            char c = x.nextClean();
            switch (c) {
                case '\u0000': {
                    throw x.syntaxError("A JSONObject text must end with '}'");
                }
                case '}': {
                    break block8;
                }
                default: {
                    x.back();
                    String key = x.nextValue();
                    c = x.nextClean();
                    if (c != ':') {
                        throw x.syntaxError("Expected a ':' after a key");
                    }
                    elements.put(key, this.read(x));
                    switch (x.nextClean()) {
                        case ',': 
                        case ';': {
                            if (x.nextClean() == '}') break block8;
                            x.back();
                            continue block8;
                        }
                        case '}': {
                            break block8;
                        }
                        default: {
                            throw x.syntaxError("Expected a ',' or '}'");
                        }
                    }
                }
            }
            break;
        }
        return res;
    }
}

