/*
 * Decompiled with CFR 0.152.
 */
package org.itest.json.simple.impl;

import org.itest.json.simple.impl.SimpleJsonException;

public class SimpleJsonTokenizer {
    private int index = 0;
    private final String source;

    public SimpleJsonTokenizer(String s) {
        this.source = s;
    }

    public void back() {
        if (this.index > 0) {
            --this.index;
        }
    }

    public boolean more() {
        return this.index < this.source.length();
    }

    public char next() {
        if (this.more()) {
            char c = this.source.charAt(this.index);
            ++this.index;
            return c;
        }
        return '\u0000';
    }

    public char nextClean() throws SimpleJsonException {
        char c;
        block4: while (true) {
            if ((c = this.next()) == '/') {
                switch (this.next()) {
                    case '/': {
                        while ((c = this.next()) != '\n' && c != '\r' && c != '\u0000') {
                        }
                        continue block4;
                    }
                    case '*': {
                        while (true) {
                            if ((c = this.next()) == '\u0000') {
                                throw this.syntaxError("Unclosed comment.");
                            }
                            if (c != '*') continue;
                            if (this.next() == '/') continue block4;
                            this.back();
                        }
                    }
                    default: {
                        this.back();
                        return '/';
                    }
                }
            }
            if (c == '#') {
                while ((c = this.next()) != '\n' && c != '\r' && c != '\u0000') {
                }
                continue;
            }
            if (c == '\u0000' || c > ' ') break;
        }
        return c;
    }

    public String stringTill(char quote) throws SimpleJsonException {
        StringBuilder sb = new StringBuilder();
        while (true) {
            char c;
            if ('\u0000' == (c = this.next())) {
                throw this.syntaxError("Unterminated string");
            }
            if (quote == c) {
                return sb.toString();
            }
            sb.append(c);
        }
    }

    public String nextValue() throws SimpleJsonException {
        char c = this.nextClean();
        switch (c) {
            case '\"': 
            case '\'': {
                return this.stringTill(c);
            }
        }
        StringBuffer sb = new StringBuffer();
        while (c >= ' ' && ",:]}/\\\"[{;=#".indexOf(c) < 0) {
            sb.append(c);
            c = this.next();
        }
        this.back();
        String s = sb.toString().trim();
        if (s.equals("")) {
            throw this.syntaxError("Missing value.");
        }
        if (s.toLowerCase().equals("null")) {
            return null;
        }
        return s;
    }

    public SimpleJsonException syntaxError(String message) {
        return new SimpleJsonException(message + this.toString());
    }

    public String toString() {
        return " at character " + this.index + " of " + this.source;
    }
}

