/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.bundles.jcrcommands;

import java.util.UUID;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.apache.karaf.shell.api.console.Session;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionWrapper;

public class JCRCommandSupport {
    public static String WORKSPACE = "JcrCommand.WORKSPACE";
    public static String PATH = "JcrCommand.PATH";

    protected String getCurrentPath(Session session) {
        String path = (String)session.get(PATH);
        if (path == null) {
            path = "/";
            this.setCurrentPath(session, path);
        }
        return path;
    }

    protected void setCurrentPath(Session session, String path) {
        session.put(PATH, (Object)path);
    }

    protected String getCurrentWorkspace(Session session) {
        String workspace = (String)session.get(WORKSPACE);
        if (workspace == null) {
            workspace = "default";
            this.setCurrentWorkspace(session, workspace);
        }
        return workspace;
    }

    protected void setCurrentWorkspace(Session session, String workspace) {
        session.put(WORKSPACE, (Object)workspace);
    }

    protected JCRNodeWrapper getNode(JCRSessionWrapper jcrsession, String path, Session session) throws RepositoryException {
        if (path == null) {
            return jcrsession.getNode(this.getCurrentPath(session));
        }
        if (path.startsWith("/")) {
            return jcrsession.getNode(path);
        }
        if (path.equals("..")) {
            JCRNodeWrapper n = jcrsession.getNode(this.getCurrentPath(session));
            return n.getParent();
        }
        try {
            JCRNodeWrapper n = jcrsession.getNode(this.getCurrentPath(session));
            return n.getNode(path);
        }
        catch (PathNotFoundException e) {
            try {
                UUID.fromString(path);
                return jcrsession.getNodeByIdentifier(path);
            }
            catch (IllegalArgumentException e1) {
                throw e;
            }
        }
    }
}

