/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.bundles.jcrcommands;

import java.util.List;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.StringUtils;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.api.console.CommandLine;
import org.apache.karaf.shell.api.console.Completer;
import org.apache.karaf.shell.api.console.Session;
import org.jahia.bundles.jcrcommands.JCRCommandSupport;
import org.jahia.services.content.JCRCallback;
import org.jahia.services.content.JCRNodeIteratorWrapper;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRTemplate;

@Service
public class JCRNodeCompleter
extends JCRCommandSupport
implements Completer {
    public int complete(final Session session, final CommandLine commandLine, final List<String> candidates) {
        try {
            JCRTemplate.getInstance().doExecuteWithSystemSession(null, this.getCurrentWorkspace(session), null, (JCRCallback)new JCRCallback<Object>(){

                public Object doInJCR(JCRSessionWrapper jcrsession) throws RepositoryException {
                    String arg = commandLine.getCursorArgument();
                    arg = arg == null ? "" : arg.substring(0, commandLine.getArgumentPosition());
                    JCRNodeWrapper n = jcrsession.getNode(JCRNodeCompleter.this.getCurrentPath(session));
                    String prefix = "";
                    if (arg.indexOf(47) > -1) {
                        prefix = StringUtils.substringBeforeLast((String)arg, (String)"/") + "/";
                        n = prefix.startsWith("/") ? jcrsession.getNode(prefix) : n.getNode(prefix);
                        arg = StringUtils.substringAfterLast((String)arg, (String)"/");
                    }
                    JCRNodeIteratorWrapper nodes = n.getNodes();
                    while (nodes.hasNext()) {
                        JCRNodeWrapper next = (JCRNodeWrapper)nodes.nextNode();
                        if (!next.getName().startsWith(arg)) continue;
                        candidates.add(prefix + next.getName() + "/");
                    }
                    return null;
                }
            });
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        return candidates.isEmpty() ? -1 : commandLine.getBufferPosition() - commandLine.getArgumentPosition();
    }
}

