/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.bundles.jcrcommands;

import java.util.HashSet;
import java.util.List;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.api.console.CommandLine;
import org.apache.karaf.shell.api.console.Completer;
import org.apache.karaf.shell.api.console.Session;
import org.apache.karaf.shell.support.completers.StringsCompleter;
import org.jahia.bundles.jcrcommands.JCRCommandSupport;
import org.jahia.services.content.JCRCallback;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRPropertyWrapper;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRTemplate;

@Service
public class JCRPropCompleter
extends JCRCommandSupport
implements Completer {
    public int complete(final Session session, CommandLine commandLine, List<String> candidates) {
        final HashSet strings = new HashSet();
        try {
            JCRTemplate.getInstance().doExecuteWithSystemSession((JCRCallback)new JCRCallback<Object>(){

                public Object doInJCR(JCRSessionWrapper jcrsession) throws RepositoryException {
                    JCRNodeWrapper n = jcrsession.getNode(JCRPropCompleter.this.getCurrentPath(session));
                    PropertyIterator props = n.getProperties();
                    while (props.hasNext()) {
                        JCRPropertyWrapper next = (JCRPropertyWrapper)props.nextProperty();
                        strings.add(next.getName());
                    }
                    return null;
                }
            });
        }
        catch (RepositoryException e) {
            System.err.print(e.getMessage());
        }
        return new StringsCompleter(strings).complete(session, commandLine, candidates);
    }
}

