/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.bundles.jcrcommands;

import java.util.ArrayList;
import javax.jcr.PropertyIterator;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.StringUtils;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.api.console.Session;
import org.apache.karaf.shell.support.table.Col;
import org.apache.karaf.shell.support.table.ShellTable;
import org.jahia.bundles.jcrcommands.JCRCommandSupport;
import org.jahia.bundles.jcrcommands.JCRPropCompleter;
import org.jahia.services.content.JCRCallback;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRPropertyWrapper;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.content.JCRValueWrapper;

@Command(scope="jcr", name="prop-get")
@Service
public class PropGetCommand
extends JCRCommandSupport
implements Action {
    @Argument(description="Name")
    @Completion(value=JCRPropCompleter.class)
    private String name;
    @Reference
    Session session;

    public Object execute() throws Exception {
        final ShellTable table = new ShellTable();
        table.column(new Col("Name"));
        table.column(new Col("Type"));
        table.column(new Col("Value"));
        JCRTemplate.getInstance().doExecuteWithSystemSessionAsUser(null, this.getCurrentWorkspace(this.session), null, (JCRCallback)new JCRCallback<Object>(){

            public Object doInJCR(JCRSessionWrapper jcrsession) throws RepositoryException {
                PropertyIterator properties;
                JCRNodeWrapper n = jcrsession.getNode(PropGetCommand.this.getCurrentPath(PropGetCommand.this.session));
                PropertyIterator propertyIterator = properties = PropGetCommand.this.name == null ? n.getProperties() : n.getProperties(PropGetCommand.this.name);
                while (properties.hasNext()) {
                    String value;
                    JCRPropertyWrapper next = (JCRPropertyWrapper)properties.nextProperty();
                    if (next.isMultiple()) {
                        ArrayList<String> l = new ArrayList<String>();
                        for (JCRValueWrapper wrapper : next.getValues()) {
                            l.add(wrapper.getString());
                        }
                        value = StringUtils.join(l, (String)", ");
                    } else {
                        value = next.getValue().getString();
                    }
                    table.addRow().addContent(new Object[]{next.getName(), PropertyType.nameFromValue((int)next.getType()), value});
                }
                return null;
            }
        });
        table.print(System.out, true);
        return null;
    }
}

