/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.bundles.jcrcommands;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.commons.lang.StringUtils;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.api.console.Session;
import org.apache.karaf.shell.support.completers.StringsCompleter;
import org.apache.karaf.shell.support.table.Col;
import org.apache.karaf.shell.support.table.ShellTable;
import org.jahia.bundles.jcrcommands.JCRCommandSupport;
import org.jahia.bundles.jcrcommands.JCRPropCompleter;
import org.jahia.services.content.JCRCallback;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRPropertyWrapper;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.content.JCRValueWrapper;

@Command(scope="jcr", name="prop-set")
@Service
public class PropSetCommand
extends JCRCommandSupport
implements Action {
    @Argument(description="Name")
    @Completion(value=JCRPropCompleter.class)
    private String name;
    @Argument(description="Value", index=1, multiValued=true)
    private List<String> valuesAsString;
    @Option(name="-multiple", required=false, multiValued=false)
    private boolean multiple;
    @Option(name="-op", required=false, multiValued=false)
    @Completion(value=StringsCompleter.class, values={"add", "replace", "remove"})
    private String multipleOp = "add";
    @Option(name="-type", required=false, multiValued=false)
    @Completion(value=StringsCompleter.class, values={"String", "Binary", "Long", "Double", "Decimal", "Date", "Boolean", "Name", "Path", "Reference", "WeakReference", "URI", "undefined"})
    private String type = "undefined";
    @Reference
    Session session;

    public Object execute() throws Exception {
        final ShellTable table = new ShellTable();
        table.column(new Col("Name"));
        table.column(new Col("Type"));
        table.column(new Col("Value"));
        JCRTemplate.getInstance().doExecuteWithSystemSessionAsUser(null, this.getCurrentWorkspace(this.session), null, (JCRCallback)new JCRCallback<Object>(){

            public Object doInJCR(JCRSessionWrapper jcrsession) throws RepositoryException {
                JCRNodeWrapper n = jcrsession.getNode(PropSetCommand.this.getCurrentPath(PropSetCommand.this.session));
                int typeAsInt = PropertyType.valueFromName((String)PropSetCommand.this.type);
                ArrayList<Value> values = new ArrayList<Value>(PropSetCommand.this.valuesAsString.size());
                for (String input : PropSetCommand.this.valuesAsString) {
                    if (typeAsInt != 0) {
                        values.add(jcrsession.getValueFactory().createValue(input, typeAsInt));
                        continue;
                    }
                    values.add(jcrsession.getValueFactory().createValue(input));
                }
                String output = null;
                JCRPropertyWrapper property = null;
                if (n.hasProperty(PropSetCommand.this.name)) {
                    property = n.getProperty(PropSetCommand.this.name);
                }
                if (PropSetCommand.this.multiple) {
                    if (PropSetCommand.this.multipleOp.equals("remove")) {
                        if (property != null) {
                            for (JCRValueWrapper v : n.getProperty(PropSetCommand.this.name).getValues()) {
                                if (!PropSetCommand.this.valuesAsString.contains(v.getString())) continue;
                                n.getProperty(PropSetCommand.this.name).removeValue((Value)v);
                            }
                        }
                    } else if (PropSetCommand.this.multipleOp.equals("replace") || property == null) {
                        property = n.setProperty(PropSetCommand.this.name, values.toArray(new Value[values.size()]));
                    } else if (PropSetCommand.this.multipleOp.equals("add")) {
                        property = n.getProperty(PropSetCommand.this.name);
                        for (Value s : values) {
                            property.addValue(s);
                        }
                    }
                    if (property != null) {
                        ArrayList<String> l = new ArrayList<String>();
                        for (JCRValueWrapper wrapper : property.getValues()) {
                            l.add(wrapper.getString());
                        }
                        output = StringUtils.join(l, (String)", ");
                    }
                } else if (values.size() == 1) {
                    property = n.setProperty(PropSetCommand.this.name, (Value)values.iterator().next());
                    output = property.getValue().getString();
                }
                if (property != null && output != null) {
                    table.addRow().addContent(new Object[]{PropSetCommand.this.name, PropertyType.nameFromValue((int)property.getType()), output});
                }
                jcrsession.save();
                return null;
            }
        });
        table.print(System.out, true);
        return null;
    }
}

