/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.bundles.jcrcommands;

import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.api.console.Session;
import org.apache.karaf.shell.support.completers.StringsCompleter;
import org.apache.karaf.shell.support.table.Col;
import org.apache.karaf.shell.support.table.ShellTable;
import org.jahia.bundles.jcrcommands.JCRCommandSupport;
import org.jahia.services.content.JCRCallback;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.query.QueryWrapper;

@Command(scope="jcr", name="query")
@Service
public class QueryCommand
extends JCRCommandSupport
implements Action {
    @Argument(description="Query")
    private String query;
    @Option(name="-lang", description="query language")
    @Completion(value=StringsCompleter.class, values={"JCR-SQL2", "xpath"})
    private String language = "JCR-SQL2";
    @Option(name="-l", description="limit")
    private int limit = 50;
    @Reference
    Session session;

    public Object execute() throws Exception {
        final ShellTable table = new ShellTable();
        table.column(new Col("Path"));
        table.column(new Col("UUID"));
        table.column(new Col("Type"));
        JCRTemplate.getInstance().doExecuteWithSystemSessionAsUser(null, this.getCurrentWorkspace(this.session), null, (JCRCallback)new JCRCallback<Object>(){

            public Object doInJCR(JCRSessionWrapper jcrsession) throws RepositoryException {
                QueryWrapper q = jcrsession.getWorkspace().getQueryManager().createQuery(QueryCommand.this.query, QueryCommand.this.language);
                q.setLimit((long)QueryCommand.this.limit);
                NodeIterator nodes = q.execute().getNodes();
                while (nodes.hasNext()) {
                    JCRNodeWrapper next = (JCRNodeWrapper)nodes.nextNode();
                    table.addRow().addContent(new Object[]{next.getPath(), next.getIdentifier(), next.getPrimaryNodeTypeName()});
                }
                return null;
            }
        });
        table.print(System.out, true);
        return null;
    }
}

