/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.bundles.websocket;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.websocket.CloseReason;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.Session;
import org.osgi.framework.ServiceObjects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModuleEndpoint
extends Endpoint {
    private static final Logger logger = LoggerFactory.getLogger(ModuleEndpoint.class);
    private final ServiceObjects<Endpoint> endpointServiceRef;
    private final Endpoint endpoint;
    private final Set<Session> sessions = new HashSet<Session>();
    private volatile boolean closed;

    public ModuleEndpoint(ServiceObjects<Endpoint> endpointServiceRef) {
        this.endpointServiceRef = endpointServiceRef;
        this.endpoint = (Endpoint)endpointServiceRef.getService();
    }

    public void onClose(Session session, CloseReason closeReason) {
        if (this.closed) {
            return;
        }
        this.endpoint.onClose(session, closeReason);
        this.sessions.remove(session);
        this.endpointServiceRef.ungetService((Object)this.endpoint);
    }

    public void onError(Session session, Throwable throwable) {
        if (this.closed) {
            return;
        }
        this.endpoint.onError(session, throwable);
    }

    public void onOpen(Session session, EndpointConfig endpointConfig) {
        if (this.closed) {
            return;
        }
        this.endpoint.onOpen(session, endpointConfig);
        this.sessions.add(session);
    }

    protected void close() {
        this.closed = true;
        Iterator<Session> iterator = this.sessions.iterator();
        while (iterator.hasNext()) {
            Session session = iterator.next();
            iterator.remove();
            try {
                CloseReason closeReason = new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.GOING_AWAY, "Service is unregistered");
                session.close(closeReason);
                this.endpoint.onClose(session, closeReason);
                this.endpointServiceRef.ungetService((Object)this.endpoint);
            }
            catch (IOException e) {
                logger.error("Unable to close session", (Throwable)e);
            }
        }
    }
}

