/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.bundles.websocket;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.websocket.Endpoint;
import javax.websocket.Extension;
import javax.websocket.HandshakeResponse;
import javax.websocket.server.HandshakeRequest;
import javax.websocket.server.ServerEndpointConfig;
import org.jahia.bundles.websocket.ModuleEndpoint;
import org.osgi.framework.ServiceObjects;

public class ModuleEndpointConfigurator
extends ServerEndpointConfig.Configurator {
    private final Set<ModuleEndpoint> endpoints = new HashSet<ModuleEndpoint>();
    private final ServiceObjects<Endpoint> endpointServiceRef;
    private ServerEndpointConfig.Configurator customConfigurator;

    public ModuleEndpointConfigurator(ServiceObjects<Endpoint> endpointServiceRef, ServerEndpointConfig.Configurator customConfigurator) {
        this.endpointServiceRef = endpointServiceRef;
        this.customConfigurator = customConfigurator;
    }

    public void close() {
        Iterator<ModuleEndpoint> iterator = this.endpoints.iterator();
        while (iterator.hasNext()) {
            ModuleEndpoint moduleEndpoint = iterator.next();
            iterator.remove();
            moduleEndpoint.close();
        }
    }

    public <T> T getEndpointInstance(Class<T> endpointClass) {
        ModuleEndpoint moduleEndpoint = new ModuleEndpoint(this.endpointServiceRef);
        this.endpoints.add(moduleEndpoint);
        return (T)((Object)moduleEndpoint);
    }

    public void modifyHandshake(ServerEndpointConfig sec, HandshakeRequest request, HandshakeResponse response) {
        if (this.customConfigurator != null) {
            this.customConfigurator.modifyHandshake(sec, request, response);
        }
    }

    public String getNegotiatedSubprotocol(List<String> supported, List<String> requested) {
        if (this.customConfigurator != null) {
            return this.customConfigurator.getNegotiatedSubprotocol(supported, requested);
        }
        return super.getNegotiatedSubprotocol(supported, requested);
    }

    public List<Extension> getNegotiatedExtensions(List<Extension> installed, List<Extension> requested) {
        if (this.customConfigurator != null) {
            return this.customConfigurator.getNegotiatedExtensions(installed, requested);
        }
        return super.getNegotiatedExtensions(installed, requested);
    }

    public boolean checkOrigin(String originHeaderValue) {
        if (this.customConfigurator != null) {
            return this.customConfigurator.checkOrigin(originHeaderValue);
        }
        return super.checkOrigin(originHeaderValue);
    }
}

