/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.bundles.websocket;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.ServletContext;
import javax.websocket.Decoder;
import javax.websocket.DeploymentException;
import javax.websocket.Encoder;
import javax.websocket.Endpoint;
import javax.websocket.server.ServerContainer;
import javax.websocket.server.ServerEndpoint;
import javax.websocket.server.ServerEndpointConfig;
import org.jahia.bin.listeners.JahiaContextLoaderListener;
import org.jahia.bundles.websocket.ModuleEndpointConfigurator;
import org.jahia.bundles.websocket.ModuleServerEndpointConfig;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceObjects;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={ModuleEndpointTracker.class})
public class ModuleEndpointTracker {
    private static final Logger logger = LoggerFactory.getLogger(ModuleEndpointTracker.class);
    private final ConcurrentMap<String, ModuleServerEndpointConfig> moduleServerEndpointConfigs = new ConcurrentHashMap<String, ModuleServerEndpointConfig>();
    private ServiceTracker<Endpoint, ModuleServerEndpointConfig> serverEndpointConfigWrapperServiceTracker;

    @Activate
    protected void activate(final BundleContext bundleContext) {
        ServletContext servletContext = JahiaContextLoaderListener.getServletContext();
        final ServerContainer serverContainer = (ServerContainer)servletContext.getAttribute(ServerContainer.class.getName());
        if (serverContainer == null) {
            logger.warn("No WebSocket server container available");
            return;
        }
        this.serverEndpointConfigWrapperServiceTracker = new ServiceTracker(bundleContext, Endpoint.class, (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<Endpoint, ModuleServerEndpointConfig>(){

            public ModuleServerEndpointConfig addingService(ServiceReference<Endpoint> serviceReference) {
                ServiceObjects endpointServiceRef = bundleContext.getServiceObjects(serviceReference);
                ServerEndpoint serverEndpoint = ((Endpoint)endpointServiceRef.getService()).getClass().getAnnotation(ServerEndpoint.class);
                if (serverEndpoint == null) {
                    return null;
                }
                String path = "/modules" + serverEndpoint.value();
                List<Class<? extends Decoder>> decoders = Arrays.asList(serverEndpoint.decoders());
                List<Class<? extends Encoder>> encoders = Arrays.asList(serverEndpoint.encoders());
                List<String> subprotocol = Arrays.asList(serverEndpoint.subprotocols());
                ServerEndpointConfig.Configurator customConfigurator = null;
                try {
                    customConfigurator = (ServerEndpointConfig.Configurator)serverEndpoint.configurator().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    logger.error("Cannot instantiate configurator", (Throwable)e);
                }
                ModuleServerEndpointConfig moduleServerEndpointConfig = (ModuleServerEndpointConfig)ModuleEndpointTracker.this.moduleServerEndpointConfigs.get(path);
                if (moduleServerEndpointConfig == null) {
                    moduleServerEndpointConfig = new ModuleServerEndpointConfig(path, decoders, encoders, subprotocol);
                    moduleServerEndpointConfig.setConfigurator(new ModuleEndpointConfigurator((ServiceObjects<Endpoint>)endpointServiceRef, customConfigurator));
                    try {
                        serverContainer.addEndpoint((ServerEndpointConfig)moduleServerEndpointConfig);
                    }
                    catch (DeploymentException e) {
                        logger.error("Unable to register module WebSocket endpoint for path {}", (Object)path, (Object)e);
                        return null;
                    }
                    ModuleEndpointTracker.this.moduleServerEndpointConfigs.put(path, moduleServerEndpointConfig);
                } else {
                    ServerEndpointConfig.Configurator configurator = moduleServerEndpointConfig.getConfigurator();
                    if (configurator.getClass().equals(ModuleServerEndpointConfig.UnregisteredEndpointConfigurator.class)) {
                        moduleServerEndpointConfig.update(decoders, encoders, subprotocol);
                    }
                    moduleServerEndpointConfig.setConfigurator(new ModuleEndpointConfigurator((ServiceObjects<Endpoint>)endpointServiceRef, customConfigurator));
                }
                return moduleServerEndpointConfig;
            }

            public void modifiedService(ServiceReference<Endpoint> serviceReference, ModuleServerEndpointConfig serverEndpointConfigWrapper) {
                this.removedService(serviceReference, serverEndpointConfigWrapper);
                this.addingService((ServiceReference)serviceReference);
            }

            public void removedService(ServiceReference<Endpoint> serviceReference, ModuleServerEndpointConfig serverEndpointConfigWrapper) {
                serverEndpointConfigWrapper.removeConfigurator();
            }
        });
        this.serverEndpointConfigWrapperServiceTracker.open();
    }

    @Deactivate
    protected void deactivate() {
        if (this.serverEndpointConfigWrapperServiceTracker != null) {
            this.serverEndpointConfigWrapperServiceTracker.close();
        }
    }
}

