/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.bundles.websocket;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.websocket.CloseReason;
import javax.websocket.Decoder;
import javax.websocket.Encoder;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.Extension;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpointConfig;
import org.jahia.bundles.websocket.ModuleEndpointConfigurator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModuleServerEndpointConfig
implements ServerEndpointConfig {
    private static final Logger logger = LoggerFactory.getLogger(ModuleServerEndpointConfig.class);
    private final UnregisteredEndpointConfigurator unregisteredEndpointConfigurator = new UnregisteredEndpointConfigurator();
    private ModuleEndpointConfigurator moduleEndpointConfigurator = null;
    private ServerEndpointConfig serverEndpointConfig;

    public ModuleServerEndpointConfig(String path, List<Class<? extends Decoder>> decoders, List<Class<? extends Encoder>> encoders, List<String> subprotocols) {
        this.buildConfig(path, decoders, encoders, subprotocols);
    }

    private void buildConfig(String path, List<Class<? extends Decoder>> decoders, List<Class<? extends Encoder>> encoders, List<String> subprotocols) {
        ServerEndpointConfig.Builder builder = ServerEndpointConfig.Builder.create(Endpoint.class, (String)path);
        builder.decoders(decoders);
        builder.encoders(encoders);
        builder.subprotocols(subprotocols);
        this.serverEndpointConfig = builder.build();
    }

    public void update(List<Class<? extends Decoder>> decoders, List<Class<? extends Encoder>> encoders, List<String> subprotocols) {
        this.buildConfig(this.serverEndpointConfig.getPath(), decoders, encoders, subprotocols);
    }

    public void removeConfigurator() {
        this.moduleEndpointConfigurator.close();
        this.moduleEndpointConfigurator = null;
    }

    public ServerEndpointConfig.Configurator getConfigurator() {
        if (this.moduleEndpointConfigurator == null) {
            return this.unregisteredEndpointConfigurator;
        }
        return this.moduleEndpointConfigurator;
    }

    public void setConfigurator(ModuleEndpointConfigurator moduleEndpointConfigurator) {
        this.moduleEndpointConfigurator = moduleEndpointConfigurator;
    }

    public List<Class<? extends Decoder>> getDecoders() {
        return this.serverEndpointConfig.getDecoders();
    }

    public List<Class<? extends Encoder>> getEncoders() {
        return this.serverEndpointConfig.getEncoders();
    }

    public Class<?> getEndpointClass() {
        return this.serverEndpointConfig.getEndpointClass();
    }

    public List<Extension> getExtensions() {
        return this.serverEndpointConfig.getExtensions();
    }

    public String getPath() {
        return this.serverEndpointConfig.getPath();
    }

    public List<String> getSubprotocols() {
        return this.serverEndpointConfig.getSubprotocols();
    }

    public Map<String, Object> getUserProperties() {
        return this.serverEndpointConfig.getUserProperties();
    }

    public static final class UnregisteredEndpointConfigurator
    extends ServerEndpointConfig.Configurator {
        public <T> T getEndpointInstance(Class<T> endpointClass) {
            return (T)new Endpoint(){

                public void onOpen(Session session, EndpointConfig config) {
                    try {
                        session.close(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.GOING_AWAY, "Service is unregistered"));
                    }
                    catch (IOException e) {
                        logger.error("Unable to close the session", (Throwable)e);
                    }
                }
            };
        }
    }
}

