/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.Provides;
import com.google.inject.TypeLiteral;
import com.google.inject.internal.Annotations;
import com.google.inject.internal.Errors;
import com.google.inject.internal.ProviderMethod;
import com.google.inject.internal.UniqueAnnotations;
import com.google.inject.spi.Dependency;
import com.google.inject.spi.Message;
import com.google.inject.util.Modules;
import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;

public final class ProviderMethodsModule
implements Module {
    private static final Key<Logger> LOGGER_KEY = Key.get(Logger.class);
    private final Object delegate;
    private final TypeLiteral<?> typeLiteral;
    private final boolean skipFastClassGeneration;

    private ProviderMethodsModule(Object delegate, boolean skipFastClassGeneration) {
        this.delegate = Preconditions.checkNotNull(delegate, "delegate");
        this.typeLiteral = TypeLiteral.get(this.delegate.getClass());
        this.skipFastClassGeneration = skipFastClassGeneration;
    }

    public static Module forModule(Module module) {
        return ProviderMethodsModule.forObject(module, false);
    }

    public static Module forObject(Object object) {
        return ProviderMethodsModule.forObject(object, true);
    }

    private static Module forObject(Object object, boolean skipFastClassGeneration) {
        if (object instanceof ProviderMethodsModule) {
            return Modules.EMPTY_MODULE;
        }
        return new ProviderMethodsModule(object, skipFastClassGeneration);
    }

    @Override
    public synchronized void configure(Binder binder) {
        for (ProviderMethod<?> providerMethod : this.getProviderMethods(binder)) {
            providerMethod.configure(binder);
        }
    }

    public List<ProviderMethod<?>> getProviderMethods(Binder binder) {
        ArrayList<ProviderMethod<?>> result = Lists.newArrayList();
        HashMultimap<Signature, Method> methodsBySignature = HashMultimap.create();
        for (Class<?> c2 = this.delegate.getClass(); c2 != Object.class; c2 = c2.getSuperclass()) {
            for (Method method : c2.getDeclaredMethods()) {
                if ((method.getModifiers() & 0xA) == 0 && !method.isBridge() && !method.isSynthetic()) {
                    methodsBySignature.put(new Signature(method), method);
                }
                if (!ProviderMethodsModule.isProvider(method)) continue;
                result.add(this.createProviderMethod(binder, method));
            }
        }
        block2: for (ProviderMethod providerMethod : result) {
            Method method = providerMethod.getMethod();
            for (Method matchingSignature : methodsBySignature.get(new Signature(method))) {
                if (matchingSignature.getDeclaringClass().isAssignableFrom(method.getDeclaringClass()) || !ProviderMethodsModule.overrides(matchingSignature, method)) continue;
                binder.addError("Overriding @Provides methods is not allowed.\n\t@Provides method: %s\n\toverridden by: %s", method, matchingSignature);
                continue block2;
            }
        }
        return result;
    }

    private static boolean isProvider(Method method) {
        return !method.isBridge() && !method.isSynthetic() && method.isAnnotationPresent(Provides.class);
    }

    private static boolean overrides(Method a2, Method b2) {
        int modifiers = b2.getModifiers();
        if (Modifier.isPublic(modifiers) || Modifier.isProtected(modifiers)) {
            return true;
        }
        if (Modifier.isPrivate(modifiers)) {
            return false;
        }
        return a2.getDeclaringClass().getPackage().equals(b2.getDeclaringClass().getPackage());
    }

    private <T> ProviderMethod<T> createProviderMethod(Binder binder, Method method) {
        Key<Object> key;
        binder = binder.withSource(method);
        Errors errors = new Errors(method);
        ArrayList<Dependency<?>> dependencies = Lists.newArrayList();
        ArrayList<Provider<?>> parameterProviders = Lists.newArrayList();
        List<TypeLiteral<?>> parameterTypes = this.typeLiteral.getParameterTypes(method);
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        for (int i2 = 0; i2 < parameterTypes.size(); ++i2) {
            key = this.getKey(errors, parameterTypes.get(i2), method, parameterAnnotations[i2]);
            if (key.equals(LOGGER_KEY)) {
                Key<Logger> loggerKey = Key.get(Logger.class, UniqueAnnotations.create());
                binder.bind(loggerKey).toProvider(new LogProvider(method));
                key = loggerKey;
            }
            dependencies.add(Dependency.get(key));
            parameterProviders.add(binder.getProvider(key));
        }
        TypeLiteral<?> returnType = this.typeLiteral.getReturnType(method);
        key = this.getKey(errors, returnType, method, method.getAnnotations());
        Class<? extends Annotation> scopeAnnotation = Annotations.findScopeAnnotation(errors, method.getAnnotations());
        for (Message message : errors.getMessages()) {
            binder.addError(message);
        }
        return ProviderMethod.create(key, method, this.delegate, ImmutableSet.copyOf(dependencies), parameterProviders, scopeAnnotation, this.skipFastClassGeneration);
    }

    <T> Key<T> getKey(Errors errors, TypeLiteral<T> type, Member member, Annotation[] annotations) {
        Annotation bindingAnnotation = Annotations.findBindingAnnotation(errors, member, annotations);
        return bindingAnnotation == null ? Key.get(type) : Key.get(type, bindingAnnotation);
    }

    public boolean equals(Object o2) {
        return o2 instanceof ProviderMethodsModule && ((ProviderMethodsModule)o2).delegate == this.delegate;
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    private static final class LogProvider
    implements Provider<Logger> {
        private final String name;

        public LogProvider(Method method) {
            this.name = method.getDeclaringClass().getName() + "." + method.getName();
        }

        @Override
        public Logger get() {
            return Logger.getLogger(this.name);
        }
    }

    private final class Signature {
        final Class<?>[] parameters;
        final String name;
        final int hashCode;

        Signature(Method method) {
            this.name = method.getName();
            List<TypeLiteral<?>> resolvedParameterTypes = ProviderMethodsModule.this.typeLiteral.getParameterTypes(method);
            this.parameters = new Class[resolvedParameterTypes.size()];
            int i2 = 0;
            for (TypeLiteral<?> type : resolvedParameterTypes) {
                this.parameters[i2] = type.getRawType();
            }
            this.hashCode = this.name.hashCode() + 31 * Arrays.hashCode(this.parameters);
        }

        public boolean equals(Object obj) {
            if (obj instanceof Signature) {
                Signature other = (Signature)obj;
                return other.name.equals(this.name) && Arrays.equals(this.parameters, other.parameters);
            }
            return false;
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

