/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.BaseInputStream;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;

final class AsciiFilteredInputStream
extends InputStream {
    private final InputStream containedStream;
    private static final byte[] ASCII_FILTER;

    AsciiFilteredInputStream(BaseInputStream containedStream) throws SQLServerException {
        if (BaseInputStream.logger.isLoggable(Level.FINER)) {
            BaseInputStream.logger.finer(containedStream.toString() + " wrapping in AsciiFilteredInputStream");
        }
        this.containedStream = containedStream;
    }

    @Override
    public void close() throws IOException {
        this.containedStream.close();
    }

    @Override
    public long skip(long n2) throws IOException {
        return this.containedStream.skip(n2);
    }

    @Override
    public int available() throws IOException {
        return this.containedStream.available();
    }

    @Override
    public int read() throws IOException {
        int value = this.containedStream.read();
        if (value >= 0 && value <= 255) {
            return ASCII_FILTER[value];
        }
        return value;
    }

    @Override
    public int read(byte[] b2) throws IOException {
        int bytesRead = this.containedStream.read(b2);
        if (bytesRead > 0) {
            assert (bytesRead <= b2.length);
            for (int i2 = 0; i2 < bytesRead; ++i2) {
                b2[i2] = ASCII_FILTER[b2[i2] & 0xFF];
            }
        }
        return bytesRead;
    }

    @Override
    public int read(byte[] b2, int offset, int maxBytes) throws IOException {
        int bytesRead = this.containedStream.read(b2, offset, maxBytes);
        if (bytesRead > 0) {
            assert (offset + bytesRead <= b2.length);
            for (int i2 = 0; i2 < bytesRead; ++i2) {
                b2[offset + i2] = ASCII_FILTER[b2[offset + i2] & 0xFF];
            }
        }
        return bytesRead;
    }

    @Override
    public boolean markSupported() {
        return this.containedStream.markSupported();
    }

    @Override
    public void mark(int readLimit) {
        this.containedStream.mark(readLimit);
    }

    @Override
    public void reset() throws IOException {
        this.containedStream.reset();
    }

    static {
        int i2;
        ASCII_FILTER = new byte[256];
        for (i2 = 0; i2 < 128; ++i2) {
            AsciiFilteredInputStream.ASCII_FILTER[i2] = (byte)i2;
        }
        for (i2 = 128; i2 < 256; ++i2) {
            AsciiFilteredInputStream.ASCII_FILTER[i2] = 63;
        }
    }
}

