/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.result;

import com.mysql.cj.Constants;
import com.mysql.cj.Messages;
import com.mysql.cj.conf.PropertySet;
import com.mysql.cj.exceptions.NumberOutOfRange;
import com.mysql.cj.result.AbstractNumericValueFactory;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;

public class FloatValueFactory
extends AbstractNumericValueFactory<Float> {
    public FloatValueFactory(PropertySet pset) {
        super(pset);
    }

    @Override
    public Float createFromBigInteger(BigInteger i2) {
        if (this.jdbcCompliantTruncationForReads && (new BigDecimal(i2).compareTo(Constants.BIG_DECIMAL_MAX_NEGATIVE_FLOAT_VALUE) < 0 || new BigDecimal(i2).compareTo(Constants.BIG_DECIMAL_MAX_FLOAT_VALUE) > 0)) {
            throw new NumberOutOfRange(Messages.getString("ResultSet.NumberOutOfRange", new Object[]{i2, this.getTargetTypeName()}));
        }
        return Float.valueOf((float)i2.doubleValue());
    }

    @Override
    public Float createFromLong(long l2) {
        if (this.jdbcCompliantTruncationForReads && ((float)l2 < -3.4028235E38f || (float)l2 > Float.MAX_VALUE)) {
            throw new NumberOutOfRange(Messages.getString("ResultSet.NumberOutOfRange", new Object[]{l2, this.getTargetTypeName()}));
        }
        return Float.valueOf(l2);
    }

    @Override
    public Float createFromBigDecimal(BigDecimal d2) {
        if (this.jdbcCompliantTruncationForReads && (d2.compareTo(Constants.BIG_DECIMAL_MAX_NEGATIVE_FLOAT_VALUE) < 0 || d2.compareTo(Constants.BIG_DECIMAL_MAX_FLOAT_VALUE) > 0)) {
            throw new NumberOutOfRange(Messages.getString("ResultSet.NumberOutOfRange", new Object[]{d2, this.getTargetTypeName()}));
        }
        return Float.valueOf((float)d2.doubleValue());
    }

    @Override
    public Float createFromDouble(double d2) {
        if (this.jdbcCompliantTruncationForReads && (d2 < -3.4028234663852886E38 || d2 > 3.4028234663852886E38)) {
            throw new NumberOutOfRange(Messages.getString("ResultSet.NumberOutOfRange", new Object[]{d2, this.getTargetTypeName()}));
        }
        return Float.valueOf((float)d2);
    }

    @Override
    public Float createFromBit(byte[] bytes, int offset, int length) {
        return Float.valueOf(new BigInteger(ByteBuffer.allocate(length + 1).put((byte)0).put(bytes, offset, length).array()).floatValue());
    }

    @Override
    public String getTargetTypeName() {
        return Float.class.getName();
    }
}

