/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.text;

public class UTFUtility {
    private UTFUtility() {
    }

    public static final boolean isHiSurrogate(char c2) {
        return (char)(c2 & 0xFC00) == '\ud800';
    }

    public static final boolean isLoSurrogate(char c2) {
        return (char)(c2 & 0xFC00) == '\udc00';
    }

    static final boolean check80toBF(byte by) {
        return (by & 0xFFFFFFC0) == -128;
    }

    static final boolean check80to8F(byte by) {
        return (by & 0xFFFFFFF0) == -128;
    }

    static final boolean check80to9F(byte by) {
        return (by & 0xFFFFFFE0) == -128;
    }

    static final boolean checkA0toBF(byte by) {
        return (by & 0xFFFFFFE0) == -96;
    }

    static final boolean check90toBF(byte by) {
        return (by & 0xFFFFFFC0) == -128 && (by & 0x30) != 0;
    }

    static final char conv2ByteUTFtoUTF16(byte by, byte by2) {
        if (by < -62 || by > -33 || !UTFUtility.check80toBF(by2)) {
            return '\ufffd';
        }
        return (char)((by & 0x1F) << 6 | by2 & 0x3F);
    }

    static final char conv3ByteUTFtoUTF16(byte by, byte by2, byte by3) {
        if (!(by == -32 && UTFUtility.checkA0toBF(by2) && UTFUtility.check80toBF(by3) || by >= -31 && by <= -17 && UTFUtility.check80toBF(by2) && UTFUtility.check80toBF(by3))) {
            return '\ufffd';
        }
        return (char)((by & 0xF) << 12 | (by2 & 0x3F) << 6 | by3 & 0x3F);
    }

    static final char conv3ByteAL32UTF8toUTF16(byte by, byte by2, byte by3) {
        if (!(by == -32 && UTFUtility.checkA0toBF(by2) && UTFUtility.check80toBF(by3) || by >= -31 && by <= -20 && UTFUtility.check80toBF(by2) && UTFUtility.check80toBF(by3) || by == -19 && UTFUtility.check80to9F(by2) && UTFUtility.check80toBF(by3) || by >= -18 && by <= -17 && UTFUtility.check80toBF(by2) && UTFUtility.check80toBF(by3))) {
            return '\ufffd';
        }
        return (char)((by & 0xF) << 12 | (by2 & 0x3F) << 6 | by3 & 0x3F);
    }

    static final int conv4ByteAL32UTF8toUTF16(byte by, byte by2, byte by3, byte by4, char[] cArray, int n2) {
        boolean bl = false;
        if (!(by == -16 && UTFUtility.check90toBF(by2) && UTFUtility.check80toBF(by3) && UTFUtility.check80toBF(by4) || by >= -15 && by <= -13 && UTFUtility.check80toBF(by2) && UTFUtility.check80toBF(by3) && UTFUtility.check80toBF(by4) || by == -12 && UTFUtility.check80to8F(by2) && UTFUtility.check80toBF(by3) && UTFUtility.check80toBF(by4))) {
            cArray[n2] = 65533;
            return 1;
        }
        cArray[n2] = (char)((((by & 7) << 2 | by2 >>> 4 & 3) - 1 & 0xF) << 6 | (by2 & 0xF) << 2 | by3 >>> 4 & 3 | 0xD800);
        cArray[n2 + 1] = (char)((by3 & 0xF) << 6 | by4 & 0x3F | 0xDC00);
        return 2;
    }
}

