/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.text.converter;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import oracle.i18n.text.UTFUtility;
import oracle.i18n.text.converter.CharacterConverter;
import oracle.i18n.text.converter.GDKMessage;
import oracle.i18n.util.GDKOracleMetaData;

public abstract class CharacterConverterOGS
extends CharacterConverter {
    static final long serialVersionUID = GDKOracleMetaData.getOracleVersionID();
    static final String CONVERTERNAMEPREFIX = GDKOracleMetaData.getDataPath() + "lx2";
    static final String CONVERTERIDPREFIX = "0000";
    public static final byte UNDEFINED_DISPLAY_WIDTH = -1;
    public static final int BELOW_CJK = 12287;
    static final int HIBYTEMASK = 65280;
    static final int LOWBYTEMASK = 255;
    static final int STORE_INCREMENT = 10;
    static final int INVALID_ORA_CHAR = -1;
    static final int FIRSTBSHIFT = 24;
    static final int SECONDBSHIFT = 16;
    static final int THIRDBSHIFT = 8;
    static final int UB2MASK = 65535;
    static final int UB4MASK = 65535;
    protected static final String BEGIN_UNISTR = "UNISTR('";
    protected static final String END_UNISTR = "')";
    static final HashMap m_converterStore = new HashMap();
    public int m_groupId;
    public int m_oracleId;
    protected float averageCharsPerByte;
    protected float maxCharsPerByte;
    protected float maxBytesPerChar;

    public static final synchronized CharacterConverter getInstance(int n2) {
        CharacterConverterOGS characterConverterOGS = null;
        boolean bl = false;
        boolean bl2 = false;
        String string = Integer.toHexString(n2);
        characterConverterOGS = (CharacterConverterOGS)m_converterStore.get(string);
        if (characterConverterOGS != null) {
            return characterConverterOGS;
        }
        String string2 = CONVERTERNAMEPREFIX + CONVERTERIDPREFIX.substring(0, 4 - string.length()) + string;
        characterConverterOGS = (CharacterConverterOGS)CharacterConverterOGS.readObj(string2 + ".glb");
        if (characterConverterOGS == null) {
            return null;
        }
        characterConverterOGS.buildUnicodeToOracleMapping();
        m_converterStore.put(string, characterConverterOGS);
        return characterConverterOGS;
    }

    @Override
    protected void storeMappingRange(int n2, Hashtable hashtable, Hashtable hashtable2) {
        char[] cArray;
        int n3 = n2 >> 24 & 0xFF;
        int n4 = n2 >> 16 & 0xFF;
        int n5 = n2 >> 8 & 0xFF;
        int n6 = n2 & 0xFF;
        Integer n7 = new Integer(n3);
        Integer n8 = new Integer(n2 >> 16 & 0xFFFF);
        Integer n9 = new Integer(n2 >> 8 & 0xFFFFFF);
        if (n2 >>> 26 == 54) {
            cArray = (char[])hashtable.get(n7);
            if (cArray == null) {
                cArray = new char[]{'\u00ff', '\u0000'};
            }
            if (cArray[0] == '\u00ff' && cArray[1] == '\u0000') {
                cArray[0] = (char)n4;
                cArray[1] = (char)n4;
            } else {
                if (n4 < (cArray[0] & 0xFFFF)) {
                    cArray[0] = (char)n4;
                }
                if (n4 > (cArray[0] & 0xFFFF)) {
                    cArray[1] = (char)n4;
                }
            }
            hashtable.put(n7, cArray);
            cArray = (char[])hashtable.get(n8);
            if (cArray == null) {
                cArray = new char[]{'\u00ff', '\u0000'};
            }
            if (cArray[0] == '\u00ff' && cArray[1] == '\u0000') {
                cArray[0] = (char)n5;
                cArray[1] = (char)n5;
            } else {
                if (n5 < (cArray[0] & 0xFFFF)) {
                    cArray[0] = (char)n5;
                }
                if (n5 > (cArray[0] & 0xFFFF)) {
                    cArray[1] = (char)n5;
                }
            }
            hashtable.put(n8, cArray);
        }
        if ((cArray = (char[])hashtable2.get(n9)) == null) {
            cArray = new char[]{'\u00ff', '\u0000'};
        }
        if (cArray[0] == '\u00ff' && cArray[1] == '\u0000') {
            cArray[0] = (char)n6;
            cArray[1] = (char)n6;
        } else {
            if (n6 < (cArray[0] & 0xFFFF)) {
                cArray[0] = (char)n6;
            }
            if (n6 > (cArray[0] & 0xFFFF)) {
                cArray[1] = (char)n6;
            }
        }
        hashtable2.put(n9, cArray);
    }

    @Override
    public int getGroupId() {
        return this.m_groupId;
    }

    @Override
    public int getOracleId() {
        return this.m_oracleId;
    }

    public float getAverageRatio() {
        return this.averageCharsPerByte;
    }

    public float getMaxRatio() {
        return this.maxCharsPerByte;
    }

    public float getMaxBytesRatio() {
        return this.maxBytesPerChar;
    }

    protected static String toUnistrChar(char c2) {
        String string = Integer.toHexString(c2);
        return "\\" + new String("000" + string).substring(string.length() - 1);
    }

    protected int getDefaultDisplayWidth(int n2) {
        return n2 >>> 8 > 0 ? 2 : 1;
    }

    protected char[] parseUnicodeCodePoint(int n2) throws UnsupportedEncodingException {
        char c2 = (char)(n2 & 0xFFFF);
        char c3 = (char)(n2 >>> 16);
        if (UTFUtility.isHiSurrogate(c3)) {
            if (UTFUtility.isLoSurrogate(c2)) {
                return new char[]{c3, c2};
            }
            throw new UnsupportedEncodingException(GDKMessage.getMessage(7002, (Object)Integer.toHexString(n2)));
        }
        return new char[]{c2, '\u0000'};
    }

    public abstract int getDisplayWidth(int var1, boolean var2) throws UnsupportedEncodingException, SQLException;

    @Override
    public abstract String toUnicodeString(byte[] var1, int var2, int var3) throws SQLException;

    @Override
    public abstract String toUnicodeStringWithReplacement(byte[] var1, int var2, int var3);

    @Override
    public abstract byte[] toOracleString(String var1) throws SQLException;

    @Override
    public abstract void buildUnicodeToOracleMapping();

    @Override
    public byte[] toOracleStringWithReplacement(String string) {
        int[] nArray = new int[]{string.length()};
        if (nArray[0] == 0) {
            return new byte[0];
        }
        char[] cArray = new char[nArray[0]];
        string.getChars(0, nArray[0], cArray, 0);
        return this.toOracleStringWithReplacement(cArray, 0, null, 0, nArray);
    }

    @Override
    public abstract byte[] toOracleStringWithReplacement(char[] var1, int var2, byte[] var3, int var4, int[] var5);

    @Override
    public abstract void extractCodepoints(Vector var1);

    @Override
    public abstract void extractExtraMappings(Vector var1);

    @Override
    public abstract boolean hasExtraMappings();

    @Override
    public abstract char getOraChar1ByteRep();

    @Override
    public abstract char getOraChar2ByteRep();

    @Override
    public abstract int getUCS2CharRep();

    protected abstract boolean isOraCharacterReplacement(char var1, char var2);

    public String toUnistr(String string) {
        StringBuffer stringBuffer = new StringBuffer(BEGIN_UNISTR);
        char[] cArray = string.toCharArray();
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            if (cArray[i2] >= '\ud800' && cArray[i2] <= '\udbff') {
                if (i2 + 1 < cArray.length && cArray[i2 + 1] >= '\udc00' && cArray[i2 + 1] <= '\udfff') {
                    if (this.isOraCharacterReplacement(cArray[i2], cArray[i2 + 1])) {
                        stringBuffer.append(CharacterConverterOGS.toUnistrChar(cArray[i2++]));
                        stringBuffer.append(CharacterConverterOGS.toUnistrChar(cArray[i2]));
                        continue;
                    }
                    stringBuffer.append(cArray[i2++]);
                    stringBuffer.append(cArray[i2]);
                    continue;
                }
                stringBuffer.append(CharacterConverterOGS.toUnistrChar(cArray[i2]));
                continue;
            }
            if (this.isOraCharacterReplacement(cArray[i2], '\u0000')) {
                stringBuffer.append(CharacterConverterOGS.toUnistrChar(cArray[i2]));
                continue;
            }
            if (cArray[i2] == '\'') {
                stringBuffer.append("''");
                continue;
            }
            stringBuffer.append(cArray[i2]);
        }
        stringBuffer.append(END_UNISTR);
        return stringBuffer.toString();
    }

    private static Object readObj(String string) {
        final Class<CharacterConverterOGS> clazz = CharacterConverterOGS.class;
        final String string2 = string;
        try {
            final URL uRL = (URL)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws ClassNotFoundException {
                    return clazz.getResource(string2);
                }
            });
            if (uRL == null) {
                return null;
            }
            Object t2 = AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException, ClassNotFoundException {
                    InputStream inputStream = uRL.openStream();
                    ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
                    Object object = objectInputStream.readObject();
                    objectInputStream.close();
                    inputStream.close();
                    return object;
                }
            });
            return t2;
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw new RuntimeException("IOException" + privilegedActionException.getMessage());
        }
    }
}

