/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.text.converter;

import java.sql.SQLException;
import oracle.i18n.text.converter.CharacterConverter12Byte;
import oracle.i18n.text.converter.GDKMessage;
import oracle.i18n.util.GDKOracleMetaData;

public class CharacterConverterShift
extends CharacterConverter12Byte {
    static final long serialVersionUID = GDKOracleMetaData.getOracleVersionID();
    public final byte SHIFT_OUT = (byte)14;
    public final byte SHIFT_IN = (byte)15;

    public CharacterConverterShift() {
        this.m_groupId = 7;
        this.averageCharsPerByte = 1.0f;
        this.maxCharsPerByte = 1.0f;
        this.maxBytesPerChar = 4.0f;
    }

    @Override
    public String toUnicodeString(byte[] byArray, int n2, int n3) throws SQLException {
        int n4 = n2 + n3;
        char[] cArray = new char[n3 * 2];
        int n5 = 0;
        int n6 = n2;
        int n7 = 15;
        while (n6 < n4) {
            int n8;
            int n9;
            if (byArray[n6] == 15) {
                n7 = 15;
                ++n6;
                continue;
            }
            if (byArray[n6] == 14) {
                n7 = 14;
                ++n6;
                continue;
            }
            if (n7 == 15) {
                n9 = byArray[n6] & 0xFF;
                n8 = this.toUnicode(n9);
                if (((long)n8 & 0xFFFFFFFFL) > 65535L) {
                    cArray[n5++] = (char)(n8 >>> 16);
                    cArray[n5++] = (char)(n8 & 0xFFFF);
                } else {
                    cArray[n5++] = (char)n8;
                }
                ++n6;
                continue;
            }
            if (n6 < n4 - 1) {
                n9 = byArray[n6] << 8 & 0xFF00 | byArray[n6 + 1] & 0xFF;
                n8 = this.toUnicode(n9);
                if (((long)n8 & 0xFFFFFFFFL) > 65535L) {
                    cArray[n5++] = (char)(n8 >>> 16);
                    cArray[n5++] = (char)(n8 & 0xFFFF);
                } else {
                    cArray[n5++] = (char)n8;
                }
                n6 += 2;
                continue;
            }
            throw new SQLException(GDKMessage.getORAMessage(17154), null, 17154);
        }
        return new String(cArray, 0, n5);
    }

    @Override
    public String toUnicodeStringWithReplacement(byte[] byArray, int n2, int n3) {
        int n4 = n2 + n3;
        char[] cArray = new char[n3 * 2];
        int n5 = 0;
        int n6 = n2;
        int n7 = 15;
        while (n6 < n4) {
            int n8;
            int n9;
            if (byArray[n6] == 15) {
                n7 = 15;
                ++n6;
                continue;
            }
            if (byArray[n6] == 14) {
                n7 = 14;
                ++n6;
                continue;
            }
            if (n7 == 15) {
                n9 = byArray[n6] & 0xFF;
                n8 = this.toUnicodeWithReplacement(n9);
                if (((long)n8 & 0xFFFFFFFFL) > 65535L) {
                    cArray[n5++] = (char)(n8 >>> 16);
                    cArray[n5++] = (char)(n8 & 0xFFFF);
                } else {
                    cArray[n5++] = (char)n8;
                }
                ++n6;
                continue;
            }
            if (n6 >= n4 - 1) break;
            n9 = byArray[n6] << 8 & 0xFF00 | byArray[n6 + 1] & 0xFF;
            n8 = this.toUnicodeWithReplacement(n9);
            if (((long)n8 & 0xFFFFFFFFL) > 65535L) {
                cArray[n5++] = (char)(n8 >>> 16);
                cArray[n5++] = (char)(n8 & 0xFFFF);
            } else {
                cArray[n5++] = (char)n8;
            }
            n6 += 2;
        }
        return new String(cArray, 0, n5);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public byte[] toOracleString(String string) throws SQLException {
        int n2 = string.length();
        if (n2 == 0) {
            return new byte[0];
        }
        char[] cArray = new char[n2];
        string.getChars(0, n2, cArray, 0);
        byte[] byArray = new byte[n2 * 4];
        int n3 = 0;
        int n4 = 15;
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2;
            if (cArray[i2] >= '\ud800' && cArray[i2] < '\udc00') {
                if (i2 + 1 >= n2 || cArray[i2 + 1] < '\udc00' || cArray[i2 + 1] > '\udfff') throw new SQLException(GDKMessage.getORAMessage(17155), null, 17155);
                c2 = this.toOracleCharacterWithReplacement(cArray[i2], cArray[i2 + 1]);
                ++i2;
            } else {
                c2 = this.toOracleCharacter(cArray[i2], '\u0000');
            }
            int n5 = c2 & 0xFF00;
            if (n5 != 0) {
                if (n4 == 15) {
                    n4 = 14;
                    byArray[n3++] = 14;
                }
                byArray[n3++] = (byte)(n5 >> 8);
                byArray[n3++] = (byte)c2;
                continue;
            }
            if (n4 == 14) {
                n4 = 15;
                byArray[n3++] = 15;
            }
            byArray[n3++] = (byte)c2;
        }
        if (n3 >= byArray.length) return byArray;
        byte[] byArray2 = new byte[n3];
        System.arraycopy(byArray, 0, byArray2, 0, n3);
        return byArray2;
    }

    @Override
    public byte[] toOracleStringWithReplacement(char[] cArray, int n2, byte[] byArray, int n3, int[] nArray) {
        int n4;
        byte[] byArray2;
        int n5 = nArray[0];
        int n6 = 65535;
        int n7 = n2 + n5;
        int n8 = 15;
        if (byArray != null) {
            byArray2 = byArray;
            n4 = n3;
        } else {
            byArray2 = new byte[n5 * 4];
            n4 = 0;
            n3 = 0;
        }
        for (int i2 = n2; i2 < n7; ++i2) {
            if (cArray[i2] >= '\ud800' && cArray[i2] < '\udc00') {
                if (i2 + 1 < n7 && cArray[i2 + 1] >= '\udc00' && cArray[i2 + 1] <= '\udfff') {
                    n6 = this.toOracleCharacterWithReplacement(cArray[i2], cArray[i2 + 1]);
                    ++i2;
                } else {
                    byArray2[n4++] = (byte)(this.m_2ByteOraCharReplacement >> 8);
                    byArray2[n4++] = (byte)this.m_2ByteOraCharReplacement;
                }
            } else {
                n6 = this.toOracleCharacterWithReplacement(cArray[i2], '\u0000');
            }
            int n9 = n6 & 0xFF00;
            if (n9 != 0) {
                if (n8 == 15) {
                    n8 = 14;
                    byArray2[n4++] = 14;
                }
                byArray2[n4++] = (byte)(n9 >> 8);
                byArray2[n4++] = (byte)n6;
                continue;
            }
            if (n8 == 14) {
                n8 = 15;
                byArray2[n4++] = 15;
            }
            byArray2[n4++] = (byte)n6;
        }
        if (n8 == 14) {
            n8 = 15;
            byArray2[n4++] = 15;
        }
        nArray[0] = n4 - n3;
        if (byArray == null && n4 < byArray2.length) {
            byte[] byArray3 = new byte[n4];
            System.arraycopy(byArray2, 0, byArray3, 0, n4);
            return byArray3;
        }
        return byArray2;
    }
}

