/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.beanutils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration2.beanutils.BeanDeclaration;
import org.apache.commons.configuration2.beanutils.ConstructorArg;

public class CombinedBeanDeclaration
implements BeanDeclaration {
    private final List<BeanDeclaration> childDeclarations;

    public CombinedBeanDeclaration(BeanDeclaration ... decl) {
        this.childDeclarations = new ArrayList<BeanDeclaration>(Arrays.asList(decl));
    }

    @Override
    public String getBeanFactoryName() {
        for (BeanDeclaration d2 : this.childDeclarations) {
            String factoryName = d2.getBeanFactoryName();
            if (factoryName == null) continue;
            return factoryName;
        }
        return null;
    }

    @Override
    public Object getBeanFactoryParameter() {
        for (BeanDeclaration d2 : this.childDeclarations) {
            Object factoryParam = d2.getBeanFactoryParameter();
            if (factoryParam == null) continue;
            return factoryParam;
        }
        return null;
    }

    @Override
    public String getBeanClassName() {
        for (BeanDeclaration d2 : this.childDeclarations) {
            String beanClassName = d2.getBeanClassName();
            if (beanClassName == null) continue;
            return beanClassName;
        }
        return null;
    }

    @Override
    public Map<String, Object> getBeanProperties() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (int i2 = this.childDeclarations.size() - 1; i2 >= 0; --i2) {
            Map<String, Object> props = this.childDeclarations.get(i2).getBeanProperties();
            if (props == null) continue;
            result.putAll(props);
        }
        return result;
    }

    @Override
    public Map<String, Object> getNestedBeanDeclarations() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (int i2 = this.childDeclarations.size() - 1; i2 >= 0; --i2) {
            Map<String, Object> decls = this.childDeclarations.get(i2).getNestedBeanDeclarations();
            if (decls == null) continue;
            result.putAll(decls);
        }
        return result;
    }

    @Override
    public Collection<ConstructorArg> getConstructorArgs() {
        for (BeanDeclaration d2 : this.childDeclarations) {
            Collection<ConstructorArg> args = d2.getConstructorArgs();
            if (args == null || args.isEmpty()) continue;
            return args;
        }
        return Collections.emptyList();
    }
}

