/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.convert;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.configuration2.convert.AbstractListDelimiterHandler;
import org.apache.commons.configuration2.convert.ValueTransformer;
import org.apache.commons.lang3.StringUtils;

public class DefaultListDelimiterHandler
extends AbstractListDelimiterHandler {
    private static final char ESCAPE = '\\';
    private static final int BUF_SIZE = 16;
    private final char delimiter;

    public DefaultListDelimiterHandler(char listDelimiter) {
        this.delimiter = listDelimiter;
    }

    public char getDelimiter() {
        return this.delimiter;
    }

    @Override
    public Object escapeList(List<?> values, ValueTransformer transformer) {
        Object[] escapedValues = new String[values.size()];
        int idx = 0;
        for (Object v2 : values) {
            escapedValues[idx++] = this.escape(v2, transformer);
        }
        return StringUtils.join(escapedValues, this.getDelimiter());
    }

    @Override
    protected String escapeString(String s2) {
        StringBuilder buf = new StringBuilder(s2.length() + 16);
        for (int i2 = 0; i2 < s2.length(); ++i2) {
            char c2 = s2.charAt(i2);
            if (c2 == this.getDelimiter() || c2 == '\\') {
                buf.append('\\');
            }
            buf.append(c2);
        }
        return buf.toString();
    }

    @Override
    protected Collection<String> splitString(String s2, boolean trim) {
        LinkedList<String> list = new LinkedList<String>();
        StringBuilder token = new StringBuilder();
        boolean inEscape = false;
        for (int i2 = 0; i2 < s2.length(); ++i2) {
            char c2 = s2.charAt(i2);
            if (inEscape) {
                if (c2 != this.getDelimiter() && c2 != '\\') {
                    token.append('\\');
                }
                token.append(c2);
                inEscape = false;
                continue;
            }
            if (c2 == this.getDelimiter()) {
                String t2 = token.toString();
                if (trim) {
                    t2 = t2.trim();
                }
                list.add(t2);
                token = new StringBuilder();
                continue;
            }
            if (c2 == '\\') {
                inEscape = true;
                continue;
            }
            token.append(c2);
        }
        if (inEscape) {
            token.append('\\');
        }
        String t3 = token.toString();
        if (trim) {
            t3 = t3.trim();
        }
        list.add(t3);
        return list;
    }
}

