/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.sftp;

import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Collection;
import java.util.Objects;
import org.apache.commons.lang3.time.DurationUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.AbstractFileSystem;
import org.apache.commons.vfs2.provider.GenericFileName;
import org.apache.commons.vfs2.provider.sftp.SftpFileObject;
import org.apache.commons.vfs2.provider.sftp.SftpFileProvider;
import org.apache.commons.vfs2.provider.sftp.SftpFileSystemConfigBuilder;

public class SftpFileSystem
extends AbstractFileSystem {
    private static final Log LOG = LogFactory.getLog(SftpFileSystem.class);
    private static final int UNIDENTIFED = -1;
    private static final int SLEEP_MILLIS = 100;
    private static final int EXEC_BUFFER_SIZE = 128;
    private static final long LAST_MOD_TIME_ACCURACY = 1000L;
    private volatile Session session;
    private volatile ChannelSftp idleChannel;
    private final Duration connectTimeout;
    private volatile int uid = -1;
    private volatile int[] groupsIds;
    private final boolean execDisabled;

    protected SftpFileSystem(GenericFileName rootName, Session session, FileSystemOptions fileSystemOptions) {
        super(rootName, null, fileSystemOptions);
        this.session = Objects.requireNonNull(session, "session");
        this.connectTimeout = SftpFileSystemConfigBuilder.getInstance().getConnectTimeout(fileSystemOptions);
        this.execDisabled = SftpFileSystemConfigBuilder.getInstance().isDisableDetectExecChannel(fileSystemOptions) ? true : this.detectExecDisabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doCloseCommunicationLink() {
        if (this.idleChannel != null) {
            SftpFileSystem sftpFileSystem = this;
            synchronized (sftpFileSystem) {
                if (this.idleChannel != null) {
                    this.idleChannel.disconnect();
                    this.idleChannel = null;
                }
            }
        }
        if (this.session != null) {
            this.session.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ChannelSftp getChannel() throws IOException {
        try {
            String fileNameEncoding;
            ChannelSftp channel = null;
            if (this.idleChannel != null) {
                SftpFileSystem sftpFileSystem = this;
                synchronized (sftpFileSystem) {
                    if (this.idleChannel != null) {
                        channel = this.idleChannel;
                        this.idleChannel = null;
                    }
                }
            }
            if (channel == null) {
                channel = (ChannelSftp)this.getSession().openChannel("sftp");
                channel.connect(DurationUtils.toMillisInt((Duration)this.connectTimeout));
                Boolean userDirIsRoot = SftpFileSystemConfigBuilder.getInstance().getUserDirIsRoot(this.getFileSystemOptions());
                String workingDirectory = this.getRootName().getPath();
                if (!(workingDirectory == null || userDirIsRoot != null && userDirIsRoot.booleanValue())) {
                    try {
                        channel.cd(workingDirectory);
                    }
                    catch (SftpException e2) {
                        throw new FileSystemException("vfs.provider.sftp/change-work-directory.error", (Object)workingDirectory, (Throwable)e2);
                    }
                }
            }
            if ((fileNameEncoding = SftpFileSystemConfigBuilder.getInstance().getFileNameEncoding(this.getFileSystemOptions())) != null) {
                try {
                    channel.setFilenameEncoding(fileNameEncoding);
                }
                catch (SftpException e3) {
                    throw new FileSystemException("vfs.provider.sftp/filename-encoding.error", (Object)fileNameEncoding);
                }
            }
            return channel;
        }
        catch (JSchException e4) {
            throw new FileSystemException("vfs.provider.sftp/connect.error", (Object)this.getRootName(), (Throwable)e4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Session getSession() throws FileSystemException {
        if (!this.session.isConnected()) {
            SftpFileSystem sftpFileSystem = this;
            synchronized (sftpFileSystem) {
                if (!this.session.isConnected()) {
                    this.doCloseCommunicationLink();
                    this.session = SftpFileProvider.createSession((GenericFileName)this.getRootName(), this.getFileSystemOptions());
                }
            }
        }
        return this.session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void putChannel(ChannelSftp channel) {
        if (this.idleChannel == null) {
            SftpFileSystem sftpFileSystem = this;
            synchronized (sftpFileSystem) {
                if (this.idleChannel == null) {
                    if (channel.isConnected() && !channel.isClosed()) {
                        this.idleChannel = channel;
                    }
                } else {
                    channel.disconnect();
                }
            }
        } else {
            channel.disconnect();
        }
    }

    @Override
    protected void addCapabilities(Collection<Capability> caps) {
        caps.addAll(SftpFileProvider.capabilities);
    }

    @Override
    protected FileObject createFile(AbstractFileName name) throws FileSystemException {
        return new SftpFileObject(name, this);
    }

    @Override
    public double getLastModTimeAccuracy() {
        return 1000.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getGroupsIds() throws JSchException, IOException {
        if (this.groupsIds == null) {
            SftpFileSystem sftpFileSystem = this;
            synchronized (sftpFileSystem) {
                if (this.groupsIds == null) {
                    StringBuilder output = new StringBuilder();
                    int code = this.executeCommand("id -G", output);
                    if (code != 0) {
                        throw new JSchException("Could not get the groups id of the current user (error code: " + code + ")");
                    }
                    String[] groups = output.toString().trim().split("\\s+");
                    int[] groupsIds = new int[groups.length];
                    for (int i2 = 0; i2 < groups.length; ++i2) {
                        groupsIds[i2] = Integer.parseInt(groups[i2]);
                    }
                    this.groupsIds = groupsIds;
                }
            }
        }
        return this.groupsIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getUId() throws JSchException, IOException {
        if (this.uid == -1) {
            SftpFileSystem sftpFileSystem = this;
            synchronized (sftpFileSystem) {
                if (this.uid == -1) {
                    StringBuilder output = new StringBuilder();
                    int code = this.executeCommand("id -u", output);
                    if (code != 0) {
                        throw new FileSystemException("Could not get the user id of the current user (error code: " + code + ")");
                    }
                    String uidString = output.toString().trim();
                    try {
                        this.uid = Integer.parseInt(uidString);
                    }
                    catch (NumberFormatException e2) {
                        LOG.debug("Cannot convert UID to integer: '" + uidString + "'", e2);
                    }
                }
            }
        }
        return this.uid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int executeCommand(String command, StringBuilder output) throws JSchException, IOException {
        ChannelExec channel = (ChannelExec)this.getSession().openChannel("exec");
        try {
            channel.setCommand(command);
            channel.setInputStream(null);
            try (InputStreamReader stream = new InputStreamReader(channel.getInputStream(), StandardCharsets.UTF_8);){
                int read;
                channel.setErrStream((OutputStream)System.err, true);
                channel.connect(DurationUtils.toMillisInt((Duration)this.connectTimeout));
                char[] buffer = new char[128];
                while ((read = stream.read(buffer, 0, buffer.length)) >= 0) {
                    output.append(buffer, 0, read);
                }
            }
            while (!channel.isClosed()) {
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {}
            }
        }
        finally {
            channel.disconnect();
        }
        return channel.getExitStatus();
    }

    public boolean isExecDisabled() {
        return this.execDisabled;
    }

    private boolean detectExecDisabled() {
        try {
            return this.getUId() == -1;
        }
        catch (JSchException | IOException e2) {
            LOG.debug("Cannot get UID, assuming no exec channel is present", e2);
            return true;
        }
    }
}

