/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.derby.client.am.ClientBlob;
import org.apache.derby.client.am.ClientConnection;
import org.apache.derby.client.am.SqlException;

class BlobLocatorOutputStream
extends OutputStream {
    private final ClientConnection connection;
    private final ClientBlob blob;
    private long currentPos;

    BlobLocatorOutputStream(ClientConnection clientConnection, ClientBlob clientBlob, long l2) throws SqlException {
        if (l2 - 1L > clientBlob.sqlLength()) {
            throw new IndexOutOfBoundsException();
        }
        this.connection = clientConnection;
        this.blob = clientBlob;
        this.currentPos = l2;
    }

    @Override
    public void write(int n2) throws IOException {
        byte[] byArray = new byte[]{(byte)n2};
        this.writeBytes(byArray);
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        this.writeBytes(byArray);
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) throws IOException {
        if (n3 == 0) {
            return;
        }
        if (n2 < 0 || n2 > byArray.length || n3 < 0 || n2 + n3 > byArray.length || n2 + n3 < 0) {
            throw new IndexOutOfBoundsException();
        }
        byte[] byArray2 = byArray;
        if (n2 > 0 || n3 < byArray.length) {
            byArray2 = new byte[n3];
            System.arraycopy(byArray, n2, byArray2, 0, n3);
        }
        this.writeBytes(byArray2);
    }

    private void writeBytes(byte[] byArray) throws IOException {
        try {
            this.blob.setBytesX(this.currentPos, byArray, 0, byArray.length);
            this.currentPos += (long)byArray.length;
        }
        catch (SqlException sqlException) {
            IOException iOException = new IOException();
            iOException.initCause(sqlException);
            throw iOException;
        }
    }
}

