/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Iterator;
import java.util.Map;
import org.apache.derby.client.am.Agent;
import org.apache.derby.client.am.AsciiStream;
import org.apache.derby.client.am.ClientBlob;
import org.apache.derby.client.am.ClientClob;
import org.apache.derby.client.am.ClientConnection;
import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.ClientPreparedStatement;
import org.apache.derby.client.am.ClientStatement;
import org.apache.derby.client.am.CloseFilterInputStream;
import org.apache.derby.client.am.ColumnMetaData;
import org.apache.derby.client.am.ConnectionCallbackInterface;
import org.apache.derby.client.am.Cursor;
import org.apache.derby.client.am.DisconnectException;
import org.apache.derby.client.am.LOBStateTracker;
import org.apache.derby.client.am.ResultSetCallbackInterface;
import org.apache.derby.client.am.SQLExceptionFactory;
import org.apache.derby.client.am.Section;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.client.am.SqlWarning;
import org.apache.derby.client.am.Sqlca;
import org.apache.derby.client.am.StatementCallbackInterface;
import org.apache.derby.client.am.Utils;

public abstract class ClientResultSet
implements ResultSet,
ResultSetCallbackInterface {
    public ClientStatement statement_;
    ClientStatement outerStatement_;
    public ColumnMetaData resultSetMetaData_;
    private SqlWarning warnings_;
    public Cursor cursor_;
    private LOBStateTracker lobState = null;
    protected Agent agent_;
    public Section generatedSection_ = null;
    private CloseFilterInputStream currentStream;
    private Reader currentReader;
    private final ClientConnection connection_;
    public static final int scrollOrientation_relative__ = 1;
    public static final int scrollOrientation_absolute__ = 2;
    public static final int scrollOrientation_after__ = 3;
    public static final int scrollOrientation_before__ = 4;
    private static final int scrollOrientation_prior__ = 5;
    private static final int scrollOrientation_first__ = 6;
    private static final int scrollOrientation_last__ = 7;
    private static final int scrollOrientation_current__ = 8;
    private static final int scrollOrientation_next__ = 0;
    public static final int sensitivity_unknown__ = 0;
    public static final int sensitivity_insensitive__ = 1;
    public static final int sensitivity_sensitive_static__ = 2;
    public static final int sensitivity_sensitive_dynamic__ = 3;
    private static final int WAS_NULL = 1;
    private static final int WAS_NOT_NULL = 2;
    private static final int WAS_NULL_UNSET = 0;
    private static final byte DDM_RETURN_CALLER = 1;
    private static final byte DDM_RETURN_CLIENT = 2;
    private int wasNull_ = 0;
    private byte rsReturnability_ = (byte)2;
    boolean openOnClient_ = true;
    public boolean openOnServer_ = true;
    public Sqlca queryTerminatingSqlca_;
    boolean autoCommitted_ = false;
    private boolean isValidCursorPosition_ = false;
    private boolean savedIsValidCursorPosition_ = false;
    public boolean cursorHold_;
    public long queryInstanceIdentifier_ = 0L;
    public int resultSetType_;
    int resultSetConcurrency_;
    int resultSetHoldability_;
    public boolean scrollable_ = false;
    public int sensitivity_;
    public boolean isRowsetCursor_ = false;
    private boolean isBeforeFirst_ = true;
    private boolean isAfterLast_ = false;
    private boolean isFirst_ = false;
    private boolean isLast_ = false;
    public Sqlca[] rowsetSqlca_;
    protected int suggestedFetchSize_;
    public int fetchSize_;
    private int fetchDirection_;
    private long rowCount_ = -1L;
    private long absolutePosition_ = 0L;
    private long firstRowInRowset_ = 0L;
    private long lastRowInRowset_ = 0L;
    private long currentRowInRowset_ = -1L;
    private boolean isOnInsertRow_ = false;
    private boolean isOnCurrentRow_ = true;
    public int rowsReceivedInCurrentRowset_ = 0;
    public int rowsYetToBeReceivedForRowset_ = 0;
    private Object[] updatedColumns_;
    private boolean[] columnUpdated_;
    private ClientPreparedStatement preparedStatementForUpdate_;
    private ClientPreparedStatement preparedStatementForDelete_;
    private ClientPreparedStatement preparedStatementForInsert_;
    private boolean cursorUnpositionedOnServer_ = false;
    private long maxRows_;
    private boolean[] columnUsedFlags_;
    private boolean listenToUnitOfWork_ = false;

    protected ClientResultSet(Agent agent, ClientStatement clientStatement, Cursor cursor, int n2, int n3, int n4) {
        this.agent_ = agent;
        this.statement_ = clientStatement;
        this.connection_ = this.statement_.connection_;
        this.cursor_ = cursor;
        if (this.cursor_ != null) {
            this.cursor_.maxFieldSize_ = this.statement_.maxFieldSize_;
        }
        this.resultSetType_ = n2;
        this.resultSetConcurrency_ = n3;
        this.resultSetHoldability_ = n4;
        this.fetchDirection_ = this.statement_.fetchDirection_;
        this.suggestedFetchSize_ = this.statement_.fetchSize_;
        this.maxRows_ = this.statement_.maxRows_;
        if (this.resultSetType_ < this.statement_.resultSetType_) {
            this.statement_.accumulateWarning(new SqlWarning(this.agent_.logWriter_, new ClientMessageId("01J08"), this.statement_.resultSetType_, this.resultSetType_));
        }
        if (this.resultSetConcurrency_ < this.statement_.resultSetConcurrency_) {
            this.accumulateWarning(new SqlWarning(this.agent_.logWriter_, new ClientMessageId("01J06"), new Object[0]));
        }
        this.listenToUnitOfWork();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean next() throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "next", new Object[0]);
                }
                boolean bl = this.nextX();
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "next", bl);
                }
                return bl;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    boolean nextX() throws SqlException {
        this.checkForClosedResultSet("next");
        this.clearWarningsX();
        this.moveToCurrentRowX();
        this.wasNull_ = 0;
        this.resetUpdatedColumns();
        this.unuseStreamsAndLOBs();
        if (this.resultSetType_ == 1003) {
            boolean bl = this.isValidCursorPosition_ = this.cursor_ == null ? false : this.cursor_.next();
            if (this.fetchSize_ != 0) {
                if (this.rowsYetToBeReceivedForRowset_ == 0) {
                    this.rowsYetToBeReceivedForRowset_ = this.fetchSize_;
                }
                if (this.isValidCursorPosition_) {
                    --this.rowsYetToBeReceivedForRowset_;
                }
            }
            if (!this.isValidCursorPosition_ && this.cursor_ != null || this.maxRows_ > 0L && this.cursor_.rowsRead_ > this.maxRows_) {
                this.isValidCursorPosition_ = false;
                SqlException sqlException = null;
                if (!this.openOnServer_) {
                    int n2 = Utils.getSqlcodeFromSqlca(this.queryTerminatingSqlca_);
                    if (n2 > 0 && n2 != 100) {
                        this.accumulateWarning(new SqlWarning(this.agent_.logWriter_, this.queryTerminatingSqlca_));
                    } else if (n2 < 0) {
                        sqlException = new SqlException(this.agent_.logWriter_, this.queryTerminatingSqlca_);
                    }
                }
                try {
                    this.statement_.resultSetCommitting(this);
                }
                catch (SqlException sqlException2) {
                    sqlException = Utils.accumulateSQLException(sqlException2, sqlException);
                }
                if (sqlException != null) {
                    throw sqlException;
                }
            }
        } else {
            this.isAfterLast_ = false;
            this.isLast_ = false;
            if (this.rowIsInCurrentRowset(this.firstRowInRowset_ + this.currentRowInRowset_ + 1L, 0)) {
                this.isValidCursorPosition_ = true;
                ++this.currentRowInRowset_;
            } else {
                this.checkAndThrowReceivedQueryTerminatingException();
                this.isValidCursorPosition_ = this.getNextRowset();
            }
            if (this.isValidCursorPosition_) {
                this.updateColumnInfoFromCache();
                this.checkRowsetSqlca();
                if (this.isBeforeFirst_) {
                    this.isFirst_ = true;
                }
                this.isBeforeFirst_ = false;
            } else {
                this.isFirst_ = false;
                return this.isValidCursorPosition_;
            }
        }
        if (!this.openOnClient_) {
            this.isValidCursorPosition_ = false;
        } else if (this.sensitivity_ != 3 && this.maxRows_ > 0L && this.firstRowInRowset_ + this.currentRowInRowset_ > this.maxRows_) {
            this.isValidCursorPosition_ = false;
        }
        return this.isValidCursorPosition_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "close", new Object[0]);
                }
                this.closeX();
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    public final void closeX() throws SqlException {
        if (!this.openOnClient_) {
            return;
        }
        this.closeOpenStreams();
        if (this.isValidCursorPosition_ && !this.isOnInsertRow_) {
            this.lobState.checkCurrentRow(this.cursor_);
        }
        this.preClose_();
        try {
            if (this.openOnServer_) {
                this.flowCloseAndAutoCommitIfNotAutoCommitted();
            } else {
                this.statement_.resultSetCommitting(this);
            }
        }
        finally {
            this.markClosed(true);
        }
        if (this.statement_.openOnClient_ && this.statement_.isCatalogQuery_) {
            this.statement_.closeX();
        }
        this.nullDataForGC();
    }

    private void closeStatementOnCompletion() {
        this.statement_.closeMeOnCompletion();
        if (this.outerStatement_ != null && this.outerStatement_ != this.statement_) {
            this.outerStatement_.closeMeOnCompletion();
        }
        this.outerStatement_ = null;
    }

    private void nullDataForGC() {
        if (this.cursor_ != null && !this.statement_.isPreparedStatement_) {
            this.cursor_.nullDataForGC();
        }
        this.cursor_ = null;
        this.resultSetMetaData_ = null;
    }

    private void flowCloseAndAutoCommitIfNotAutoCommitted() throws SqlException {
        this.agent_.beginWriteChain(this.statement_);
        boolean bl = this.writeCloseAndAutoCommit();
        this.agent_.flow(this.statement_);
        this.readCloseAndAutoCommit(bl);
        this.agent_.endReadChain();
    }

    private boolean writeCloseAndAutoCommit() throws SqlException {
        this.autoCommitted_ = false;
        if (this.generatedSection_ == null) {
            this.writeCursorClose_(this.statement_.getSection());
        } else {
            this.writeCursorClose_(this.generatedSection_);
        }
        return this.statement_.resultSetCommitting(this, true);
    }

    private void readCloseAndAutoCommit(boolean bl) throws SqlException {
        this.readCursorClose_();
        if (bl) {
            this.readAutoCommitIfNotAutoCommitted();
        }
    }

    void writeClose() throws SqlException {
        this.autoCommitted_ = false;
        if (this.generatedSection_ == null) {
            this.writeCursorClose_(this.statement_.getSection());
        } else {
            this.writeCursorClose_(this.generatedSection_);
        }
    }

    void readClose() throws SqlException {
        try {
            if (this.generatedSection_ == null) {
                this.readCursorClose_();
            } else {
                this.readCursorClose_();
            }
        }
        finally {
            this.markClosed();
        }
    }

    private void readAutoCommitIfNotAutoCommitted() throws SqlException {
        if (this.connection_.autoCommit_ && !this.autoCommitted_) {
            this.connection_.readAutoCommit();
            this.markAutoCommitted();
        }
    }

    @Override
    public boolean wasNull() throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "wasNull", new Object[0]);
            }
            this.checkForClosedResultSet("wasNull");
            if (this.wasNull_ == 0) {
                throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ088.S"), new Object[0]);
            }
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "wasNull", this.wasNull_ == 1);
            }
            return this.wasNull_ == 1;
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public boolean getBoolean(int n2) throws SQLException {
        try {
            this.closeOpenStreams();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "getBoolean", n2);
            }
            this.checkGetterPreconditions(n2, "getBoolean");
            boolean bl = false;
            if (this.wasNonNullSensitiveUpdate(n2) || this.isOnInsertRow_) {
                bl = this.isOnInsertRow_ && this.updatedColumns_[n2 - 1] == null ? false : this.agent_.crossConverters_.setBooleanFromObject(this.updatedColumns_[n2 - 1], this.resultSetMetaData_.types_[n2 - 1]);
            } else {
                boolean bl2 = bl = this.isNull(n2) ? false : this.cursor_.getBoolean(n2);
            }
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getBoolean", bl);
            }
            this.setWasNull(n2);
            return bl;
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public byte getByte(int n2) throws SQLException {
        try {
            this.closeOpenStreams();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "getByte", n2);
            }
            this.checkGetterPreconditions(n2, "getByte");
            byte by = 0;
            if (this.wasNonNullSensitiveUpdate(n2) || this.isOnInsertRow_) {
                by = this.isOnInsertRow_ && this.updatedColumns_[n2 - 1] == null ? (byte)0 : this.agent_.crossConverters_.setByteFromObject(this.updatedColumns_[n2 - 1], this.resultSetMetaData_.types_[n2 - 1]);
            } else {
                byte by2 = by = this.isNull(n2) ? (byte)0 : this.cursor_.getByte(n2);
            }
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getByte", by);
            }
            this.setWasNull(n2);
            return by;
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public short getShort(int n2) throws SQLException {
        try {
            this.closeOpenStreams();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "getShort", n2);
            }
            this.checkGetterPreconditions(n2, "getShort");
            short s2 = 0;
            if (this.wasNonNullSensitiveUpdate(n2) || this.isOnInsertRow_) {
                s2 = this.isOnInsertRow_ && this.updatedColumns_[n2 - 1] == null ? (short)0 : (Short)this.agent_.crossConverters_.setObject(5, this.updatedColumns_[n2 - 1]);
            } else {
                short s3 = s2 = this.isNull(n2) ? (short)0 : this.cursor_.getShort(n2);
            }
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getShort", s2);
            }
            this.setWasNull(n2);
            return s2;
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public int getInt(int n2) throws SQLException {
        try {
            this.closeOpenStreams();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "getInt", n2);
            }
            this.checkGetterPreconditions(n2, "getInt");
            int n3 = 0;
            if (this.wasNonNullSensitiveUpdate(n2) || this.isOnInsertRow_) {
                n3 = this.isOnInsertRow_ && this.updatedColumns_[n2 - 1] == null ? 0 : (Integer)this.agent_.crossConverters_.setObject(4, this.updatedColumns_[n2 - 1]);
            } else {
                int n4 = n3 = this.isNull(n2) ? 0 : this.cursor_.getInt(n2);
            }
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getInt", n3);
            }
            this.setWasNull(n2);
            return n3;
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public long getLong(int n2) throws SQLException {
        try {
            this.closeOpenStreams();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "getLong", n2);
            }
            this.checkGetterPreconditions(n2, "getLong");
            long l2 = 0L;
            if (this.wasNonNullSensitiveUpdate(n2) || this.isOnInsertRow_) {
                l2 = this.isOnInsertRow_ && this.updatedColumns_[n2 - 1] == null ? 0L : (Long)this.agent_.crossConverters_.setObject(-5, this.updatedColumns_[n2 - 1]);
            } else {
                long l3 = l2 = this.isNull(n2) ? 0L : this.cursor_.getLong(n2);
            }
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getLong", l2);
            }
            this.setWasNull(n2);
            return l2;
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public float getFloat(int n2) throws SQLException {
        try {
            this.closeOpenStreams();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "getFloat", n2);
            }
            this.checkGetterPreconditions(n2, "getFloat");
            float f2 = 0.0f;
            if (this.wasNonNullSensitiveUpdate(n2) || this.isOnInsertRow_) {
                f2 = this.isOnInsertRow_ && this.updatedColumns_[n2 - 1] == null ? 0.0f : ((Float)this.agent_.crossConverters_.setObject(7, this.updatedColumns_[n2 - 1])).floatValue();
            } else {
                float f3 = f2 = this.isNull(n2) ? 0.0f : this.cursor_.getFloat(n2);
            }
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getFloat", Float.valueOf(f2));
            }
            this.setWasNull(n2);
            return f2;
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public double getDouble(int n2) throws SQLException {
        try {
            this.closeOpenStreams();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "getDouble", n2);
            }
            this.checkGetterPreconditions(n2, "getDouble");
            double d2 = 0.0;
            if (this.wasNonNullSensitiveUpdate(n2) || this.isOnInsertRow_) {
                d2 = this.isOnInsertRow_ && this.updatedColumns_[n2 - 1] == null ? 0.0 : (Double)this.agent_.crossConverters_.setObject(8, this.updatedColumns_[n2 - 1]);
            } else {
                double d3 = d2 = this.isNull(n2) ? 0.0 : this.cursor_.getDouble(n2);
            }
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getDouble", d2);
            }
            this.setWasNull(n2);
            return d2;
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public BigDecimal getBigDecimal(int n2, int n3) throws SQLException {
        try {
            this.closeOpenStreams();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceDeprecatedEntry(this, "getBigDecimal", n2, n3);
            }
            this.checkGetterPreconditions(n2, "getBigDecimal");
            BigDecimal bigDecimal = null;
            if (this.wasNonNullSensitiveUpdate(n2)) {
                bigDecimal = ((BigDecimal)this.agent_.crossConverters_.setObject(3, this.updatedColumns_[n2 - 1])).setScale(n3, 1);
            } else {
                BigDecimal bigDecimal2 = bigDecimal = this.isNull(n2) ? null : this.cursor_.getBigDecimal(n2).setScale(n3, 1);
            }
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceDeprecatedExit(this, "getBigDecimal", bigDecimal);
            }
            this.setWasNull(n2);
            return bigDecimal;
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public BigDecimal getBigDecimal(int n2) throws SQLException {
        try {
            this.closeOpenStreams();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "getBigDecimal", n2);
            }
            this.checkGetterPreconditions(n2, "getBigDecimal");
            BigDecimal bigDecimal = null;
            if (this.wasNonNullSensitiveUpdate(n2)) {
                bigDecimal = (BigDecimal)this.agent_.crossConverters_.setObject(3, this.updatedColumns_[n2 - 1]);
            } else {
                BigDecimal bigDecimal2 = bigDecimal = this.isNull(n2) ? null : this.cursor_.getBigDecimal(n2);
            }
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getBigDecimal", bigDecimal);
            }
            this.setWasNull(n2);
            return bigDecimal;
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public Date getDate(int n2, Calendar calendar) throws SQLException {
        try {
            this.closeOpenStreams();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "getDate", n2);
            }
            this.checkGetterPreconditions(n2, "getDate");
            if (calendar == null) {
                throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ090.S"), new Object[0]);
            }
            Date date = null;
            if (this.wasNonNullSensitiveUpdate(n2)) {
                date = (Date)this.agent_.crossConverters_.setObject(91, this.updatedColumns_[n2 - 1]);
                date = this.convertFromDefaultCalendar(date, calendar);
            } else {
                Date date2 = date = this.isNull(n2) ? null : this.cursor_.getDate(n2, calendar);
            }
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getDate", date);
            }
            this.setWasNull(n2);
            return date;
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public Date getDate(int n2) throws SQLException {
        return this.getDate(n2, Calendar.getInstance());
    }

    @Override
    public Time getTime(int n2, Calendar calendar) throws SQLException {
        try {
            this.closeOpenStreams();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "getTime", n2, calendar);
            }
            this.checkGetterPreconditions(n2, "getTime");
            if (calendar == null) {
                throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ090.S"), new Object[0]);
            }
            Time time = null;
            if (this.wasNonNullSensitiveUpdate(n2)) {
                time = (Time)this.agent_.crossConverters_.setObject(92, this.updatedColumns_[n2 - 1]);
                time = this.convertFromDefaultCalendar(time, calendar);
            } else {
                Time time2 = time = this.isNull(n2) ? null : this.cursor_.getTime(n2, calendar);
            }
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getTime", time);
            }
            this.setWasNull(n2);
            return time;
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public Time getTime(int n2) throws SQLException {
        return this.getTime(n2, Calendar.getInstance());
    }

    @Override
    public Timestamp getTimestamp(int n2, Calendar calendar) throws SQLException {
        try {
            this.closeOpenStreams();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "getTimestamp", n2, calendar);
            }
            this.checkGetterPreconditions(n2, "getTimestamp");
            if (calendar == null) {
                throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ090.S"), new Object[0]);
            }
            Timestamp timestamp = null;
            if (this.wasNonNullSensitiveUpdate(n2)) {
                timestamp = (Timestamp)this.agent_.crossConverters_.setObject(93, this.updatedColumns_[n2 - 1]);
                timestamp = this.convertFromDefaultCalendar(timestamp, calendar);
            } else if (!this.isNull(n2)) {
                timestamp = this.cursor_.getTimestamp(n2, calendar);
            }
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getTimestamp", timestamp);
            }
            this.setWasNull(n2);
            return timestamp;
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public Timestamp getTimestamp(int n2) throws SQLException {
        return this.getTimestamp(n2, Calendar.getInstance());
    }

    private static Calendar createCalendar(java.util.Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar;
    }

    private Date convertFromDefaultCalendar(Date date, Calendar calendar) {
        Calendar calendar2 = ClientResultSet.createCalendar(date);
        calendar.clear();
        calendar.set(calendar2.get(1), calendar2.get(2), calendar2.get(5));
        return new Date(calendar.getTimeInMillis());
    }

    private Time convertFromDefaultCalendar(Time time, Calendar calendar) {
        Calendar calendar2 = ClientResultSet.createCalendar(time);
        calendar.clear();
        calendar.set(1970, 0, 1, calendar2.get(11), calendar2.get(12), calendar2.get(13));
        return new Time(calendar.getTimeInMillis());
    }

    private Timestamp convertFromDefaultCalendar(Timestamp timestamp, Calendar calendar) {
        Calendar calendar2 = ClientResultSet.createCalendar(timestamp);
        calendar.clear();
        calendar.set(calendar2.get(1), calendar2.get(2), calendar2.get(5), calendar2.get(11), calendar2.get(12), calendar2.get(13));
        Timestamp timestamp2 = new Timestamp(calendar.getTimeInMillis());
        timestamp2.setNanos(timestamp.getNanos());
        return timestamp2;
    }

    @Override
    public String getString(int n2) throws SQLException {
        try {
            this.closeOpenStreams();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "getString", n2);
            }
            this.checkGetterPreconditions(n2, "getString");
            int n3 = this.resultSetMetaData_.types_[n2 - 1];
            if (n3 == 2004 || n3 == 2005) {
                this.checkLOBMultiCall(n2);
            }
            String string = null;
            if (this.wasNonNullSensitiveUpdate(n2)) {
                string = (String)this.agent_.crossConverters_.setObject(1, this.updatedColumns_[n2 - 1]);
            } else {
                String string2 = string = this.isNull(n2) ? null : this.cursor_.getString(n2);
            }
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getString", string);
            }
            this.setWasNull(n2);
            return string;
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public byte[] getBytes(int n2) throws SQLException {
        try {
            this.closeOpenStreams();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "getBytes", n2);
            }
            this.checkGetterPreconditions(n2, "getBytes");
            int n3 = this.resultSetMetaData_.types_[n2 - 1];
            if (n3 == 2004) {
                this.checkLOBMultiCall(n2);
            }
            byte[] byArray = null;
            if (this.wasNonNullSensitiveUpdate(n2)) {
                byArray = (byte[])this.agent_.crossConverters_.setObject(-2, this.updatedColumns_[n2 - 1]);
            } else {
                byte[] byArray2 = byArray = this.isNull(n2) ? null : this.cursor_.getBytes(n2);
            }
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getBytes", byArray);
            }
            this.setWasNull(n2);
            return byArray;
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public InputStream getBinaryStream(int n2) throws SQLException {
        try {
            this.closeOpenStreams();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "getBinaryStream", n2);
            }
            this.checkGetterPreconditions(n2, "getBinaryStream");
            this.useStreamOrLOB(n2);
            InputStream inputStream = null;
            if (this.wasNonNullSensitiveUpdate(n2)) {
                inputStream = new ByteArrayInputStream((byte[])this.agent_.crossConverters_.setObject(-2, this.updatedColumns_[n2 - 1]));
            } else {
                InputStream inputStream2 = inputStream = this.isNull(n2) ? null : this.cursor_.getBinaryStream(n2);
            }
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getBinaryStream", inputStream);
            }
            this.setWasNull(n2);
            return this.createCloseFilterInputStream(inputStream);
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public InputStream getAsciiStream(int n2) throws SQLException {
        try {
            this.closeOpenStreams();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "getAsciiStream", n2);
            }
            this.checkGetterPreconditions(n2, "getAsciiStream");
            this.useStreamOrLOB(n2);
            InputStream inputStream = null;
            if (this.wasNonNullSensitiveUpdate(n2)) {
                inputStream = new AsciiStream((String)this.agent_.crossConverters_.setObject(1, this.updatedColumns_[n2 - 1]));
            } else {
                InputStream inputStream2 = inputStream = this.isNull(n2) ? null : this.cursor_.getAsciiStream(n2);
            }
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getAsciiStream", inputStream);
            }
            this.setWasNull(n2);
            return this.createCloseFilterInputStream(inputStream);
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public InputStream getUnicodeStream(int n2) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceDeprecatedEntry(this, "getUnicodeStream", n2);
        }
        throw SQLExceptionFactory.notImplemented("getUnicodeStream");
    }

    @Override
    public Reader getCharacterStream(int n2) throws SQLException {
        try {
            this.closeOpenStreams();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "getCharacterStream", n2);
            }
            this.checkGetterPreconditions(n2, "getCharacterStream");
            this.useStreamOrLOB(n2);
            Reader reader = null;
            if (this.wasNonNullSensitiveUpdate(n2)) {
                reader = new StringReader((String)this.agent_.crossConverters_.setObject(1, this.updatedColumns_[n2 - 1]));
            } else {
                Reader reader2 = reader = this.isNull(n2) ? null : this.cursor_.getCharacterStream(n2);
            }
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getCharacterStream", reader);
            }
            this.setWasNull(n2);
            this.currentReader = reader;
            return reader;
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public Blob getBlob(int n2) throws SQLException {
        try {
            this.closeOpenStreams();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "getBlob", n2);
            }
            this.checkGetterPreconditions(n2, "getBlob");
            this.useStreamOrLOB(n2);
            Blob blob = null;
            if (this.wasNonNullSensitiveUpdate(n2)) {
                blob = (Blob)this.agent_.crossConverters_.setObject(2004, this.updatedColumns_[n2 - 1]);
            } else {
                Blob blob2 = blob = this.isNull(n2) ? null : this.cursor_.getBlob(n2);
            }
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getBlob", blob);
            }
            this.setWasNull(n2);
            return blob;
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public Clob getClob(int n2) throws SQLException {
        try {
            this.closeOpenStreams();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "getClob", n2);
            }
            this.checkGetterPreconditions(n2, "getClob");
            this.useStreamOrLOB(n2);
            Clob clob = null;
            if (this.wasNonNullSensitiveUpdate(n2)) {
                clob = (Clob)this.agent_.crossConverters_.setObject(2005, this.updatedColumns_[n2 - 1]);
            } else {
                Clob clob2 = clob = this.isNull(n2) ? null : this.cursor_.getClob(n2);
            }
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getClob", clob);
            }
            this.setWasNull(n2);
            return clob;
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public Ref getRef(int n2) throws SQLException {
        try {
            this.closeOpenStreams();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "getRef", n2);
            }
            this.checkGetterPreconditions(n2, "getRef");
            Ref ref = this.isNull(n2) ? null : this.cursor_.getRef(n2);
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("0A000.S.1"), new Object[0]);
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public Array getArray(int n2) throws SQLException {
        try {
            this.closeOpenStreams();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "getArray", n2);
            }
            this.checkGetterPreconditions(n2, "getArray");
            Array array = this.isNull(n2) ? null : this.cursor_.getArray(n2);
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("0A000.S.1"), new Object[0]);
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public Object getObject(int n2) throws SQLException {
        try {
            this.closeOpenStreams();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "getObject", n2);
            }
            Object object = this.getObjectX(n2);
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getObject", object);
            }
            return object;
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    Object getObjectX(int n2) throws SqlException {
        this.checkGetterPreconditions(n2, "getObject");
        int n3 = this.resultSetMetaData_.types_[n2 - 1];
        if (n3 == 2004 || n3 == 2005) {
            this.useStreamOrLOB(n2);
        }
        Object object = null;
        object = this.wasNonNullSensitiveUpdate(n2) ? this.updatedColumns_[n2 - 1] : (this.isNull(n2) ? null : this.cursor_.getObject(n2));
        this.setWasNull(n2);
        return object;
    }

    public Object getObject(int n2, Map map) throws SQLException {
        try {
            this.closeOpenStreams();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "getObject", n2, map);
            }
            this.checkGetterPreconditions(n2, "getObject");
            Object object = null;
            object = this.wasNonNullSensitiveUpdate(n2) ? this.updatedColumns_[n2 - 1] : (this.isNull(n2) ? null : this.cursor_.getObject(n2));
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("0A000.S.1"), new Object[0]);
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    private boolean wasNonNullSensitiveUpdate(int n2) {
        return this.updatedColumns_ != null && this.updatedColumns_[n2 - 1] != null;
    }

    private boolean wasNullSensitiveUpdate(int n2) {
        return this.updatedColumns_ != null && this.updatedColumns_[n2 - 1] == null && this.columnUpdated_[n2 - 1];
    }

    private void setWasNull(int n2) {
        this.wasNull_ = this.wasNullSensitiveUpdate(n2) || this.isOnInsertRow_ && this.updatedColumns_[n2 - 1] == null ? 1 : (this.cursor_.isNull_ == null || this.cursor_.isNull_[n2 - 1] ? 1 : 2);
    }

    private boolean isNull(int n2) {
        if (this.wasNullSensitiveUpdate(n2)) {
            return true;
        }
        return this.cursor_.isUpdateDeleteHole_ || this.cursor_.isNull_[n2 - 1];
    }

    @Override
    public final boolean getBoolean(String string) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "getBoolean", string);
            }
            return this.getBoolean(this.findColumnX(string, "getBoolean"));
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public final byte getByte(String string) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "getByte", string);
            }
            return this.getByte(this.findColumnX(string, "getByte"));
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public final short getShort(String string) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "getShort", string);
            }
            return this.getShort(this.findColumnX(string, "getShort"));
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public final int getInt(String string) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "getInt", string);
            }
            return this.getInt(this.findColumnX(string, "getInt"));
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public final long getLong(String string) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "getLong", string);
            }
            return this.getLong(this.findColumnX(string, "getLong"));
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public final float getFloat(String string) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "getFloat", string);
            }
            return this.getFloat(this.findColumnX(string, "getFloat"));
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public final double getDouble(String string) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "getDouble", string);
            }
            return this.getDouble(this.findColumnX(string, "getDouble"));
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public final BigDecimal getBigDecimal(String string, int n2) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceDeprecatedEntry(this, "getBigDecimal", string, n2);
            }
            return this.getBigDecimal(this.findColumnX(string, "getBigDecimal"), n2);
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public final BigDecimal getBigDecimal(String string) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "getBigDecimal", string);
            }
            return this.getBigDecimal(this.findColumnX(string, "getBigDecimal"));
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public final Date getDate(String string) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "getDate", string);
            }
            return this.getDate(this.findColumnX(string, "getDate"));
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public final Date getDate(String string, Calendar calendar) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "getDate", string, calendar);
            }
            return this.getDate(this.findColumnX(string, "getDate"), calendar);
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public final Time getTime(String string) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "getTime", string);
            }
            return this.getTime(this.findColumnX(string, "getTime"));
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public final Time getTime(String string, Calendar calendar) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "getTime", string, calendar);
            }
            return this.getTime(this.findColumnX(string, "getTime"), calendar);
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public final Timestamp getTimestamp(String string) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "getTimestamp", string);
            }
            return this.getTimestamp(this.findColumnX(string, "getTimestamp"));
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public final Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "getTimestamp", string, calendar);
            }
            return this.getTimestamp(this.findColumnX(string, "getTimestamp"), calendar);
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public final String getString(String string) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "getString", string);
            }
            return this.getString(this.findColumnX(string, "getString"));
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public final byte[] getBytes(String string) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "getBytes", string);
            }
            return this.getBytes(this.findColumnX(string, "getBytes"));
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public final InputStream getBinaryStream(String string) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "getBinaryStream", string);
            }
            return this.getBinaryStream(this.findColumnX(string, "getBinaryStream"));
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public final InputStream getAsciiStream(String string) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "getAsciiStream", string);
            }
            return this.getAsciiStream(this.findColumnX(string, "getAsciiStream"));
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public final InputStream getUnicodeStream(String string) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceDeprecatedEntry(this, "getUnicodeStream", string);
            }
            return this.getUnicodeStream(this.findColumnX(string, "getUnicodeStream"));
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public final Reader getCharacterStream(String string) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "getCharacterStream", string);
            }
            return this.getCharacterStream(this.findColumnX(string, "getCharacterStream"));
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public final Blob getBlob(String string) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "getBlob", string);
            }
            return this.getBlob(this.findColumnX(string, "getBlob"));
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public final Clob getClob(String string) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "getClob", string);
            }
            return this.getClob(this.findColumnX(string, "getClob"));
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public final Array getArray(String string) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "getArray", string);
            }
            return this.getArray(this.findColumnX(string, "getArray"));
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public final Ref getRef(String string) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "getRef", string);
            }
            return this.getRef(this.findColumnX(string, "getRef"));
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public final Object getObject(String string) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "getObject", string);
            }
            return this.getObject(this.findColumnX(string, "getObject"));
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    public final Object getObject(String string, Map map) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "getObject", string, map);
            }
            return this.getObject(this.findColumnX(string, "getObject"), map);
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public final SQLWarning getWarnings() throws SQLException {
        try {
            this.checkForClosedResultSet("getWarnings");
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceExit((Object)this, "getWarnings", this.warnings_);
        }
        return this.warnings_ == null ? null : this.warnings_.getSQLWarning();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void clearWarnings() throws SQLException {
        ClientConnection clientConnection = this.connection_;
        synchronized (clientConnection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "clearWarnings", new Object[0]);
            }
            try {
                this.checkForClosedResultSet("clearWarnings");
            }
            catch (SqlException sqlException) {
                throw sqlException.getSQLException();
            }
            this.clearWarningsX();
        }
    }

    private void clearWarningsX() {
        this.warnings_ = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getCursorName() throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "getCursorName", new Object[0]);
                }
                this.checkForClosedResultSet("getCursorName");
                if (this.generatedSection_ != null) {
                    return "stored procedure generated cursor:" + this.generatedSection_.getServerCursorName();
                }
                if (this.statement_.cursorName_ == null) {
                    this.statement_.cursorName_ = this.statement_.getSection().getServerCursorName();
                }
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getCursorName", this.statement_.cursorName_);
                }
                return this.statement_.cursorName_;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "getMetaData", new Object[0]);
            }
            ColumnMetaData columnMetaData = this.getMetaDataX();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getMetaData", (Object)columnMetaData);
            }
            return columnMetaData;
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    ColumnMetaData getMetaDataX() throws SqlException {
        this.checkForClosedResultSet("getMetaData");
        return this.resultSetMetaData_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int findColumn(String string) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "findColumn", string);
                }
                int n2 = this.findColumnX(string, "findColumn");
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "findColumn", n2);
                }
                return n2;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    protected final int findColumnX(String string, String string2) throws SqlException {
        this.checkForClosedResultSet(string2);
        return this.resultSetMetaData_.findColumnX(string);
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "isBeforeFirst", new Object[0]);
            }
            this.checkForClosedResultSet("isBeforeFirst");
            this.checkThatResultSetTypeIsScrollable();
            boolean bl = this.isBeforeFirstX();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "isBeforeFirst", bl);
            }
            return bl;
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    private boolean isBeforeFirstX() throws SqlException {
        if (this.sensitivity_ == 3) {
            return this.isBeforeFirst_;
        }
        return this.currentRowInRowset_ == -1L && !this.resultSetContainsNoRows();
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "isAfterLast", new Object[0]);
            }
            this.checkForClosedResultSet("isAfterLast");
            this.checkThatResultSetTypeIsScrollable();
            boolean bl = this.isAfterLastX();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "isAfterLast", bl);
            }
            return bl;
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    private boolean isAfterLastX() throws SqlException {
        if (this.sensitivity_ == 3) {
            return this.isAfterLast_;
        }
        return this.resultSetContainsNoRows() ? false : this.firstRowInRowset_ == this.currentRowInRowset_ && this.currentRowInRowset_ == this.lastRowInRowset_ && this.lastRowInRowset_ == 0L && this.absolutePosition_ == (this.maxRows_ == 0L ? this.rowCount_ + 1L : this.maxRows_ + 1L);
    }

    @Override
    public boolean isFirst() throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "isFirst", new Object[0]);
            }
            this.checkForClosedResultSet("isFirst");
            this.checkThatResultSetTypeIsScrollable();
            boolean bl = this.isFirstX();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "isFirst", bl);
            }
            return bl;
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    private boolean isFirstX() {
        if (this.sensitivity_ == 3) {
            return this.isFirst_;
        }
        return this.firstRowInRowset_ == 1L && this.currentRowInRowset_ == 0L;
    }

    @Override
    public boolean isLast() throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "isLast", new Object[0]);
            }
            this.checkForClosedResultSet("isLast");
            this.checkThatResultSetTypeIsScrollable();
            boolean bl = this.isLastX();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "isLast", bl);
            }
            return bl;
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    private boolean isLastX() throws SqlException {
        if (this.sensitivity_ == 3) {
            return this.isLast_;
        }
        return this.resultSetContainsNoRows() ? false : this.firstRowInRowset_ + this.currentRowInRowset_ == this.rowCount_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beforeFirst() throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "beforeFirst", new Object[0]);
                }
                this.checkForClosedResultSet("beforeFirst");
                this.checkThatResultSetTypeIsScrollable();
                this.clearWarningsX();
                this.beforeFirstX();
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    private void beforeFirstX() throws SqlException {
        this.resetRowsetFlags();
        this.unuseStreamsAndLOBs();
        this.moveToCurrentRowX();
        if (this.sensitivity_ == 3 || !this.resultSetContainsNoRows() && !this.isServersCursorPositionBeforeFirst()) {
            this.moveToBeforeFirst();
        }
        this.isBeforeFirst_ = true;
        this.setRowsetBeforeFirstEvent();
        this.cursor_.resetDataBuffer();
        this.resetRowsetSqlca();
        this.isValidCursorPosition_ = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void afterLast() throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "afterLast", new Object[0]);
                }
                this.checkForClosedResultSet("afterLast");
                this.checkThatResultSetTypeIsScrollable();
                this.clearWarningsX();
                this.afterLastX();
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    private void afterLastX() throws SqlException {
        this.resetRowsetFlags();
        this.unuseStreamsAndLOBs();
        this.moveToCurrentRowX();
        if (this.sensitivity_ == 3 || !this.resultSetContainsNoRows() && !this.isServerCursorPositionAfterLast()) {
            this.moveToAfterLast();
        }
        this.isAfterLast_ = true;
        this.setRowsetAfterLastEvent();
        this.cursor_.resetDataBuffer();
        this.resetRowsetSqlca();
        this.isValidCursorPosition_ = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean first() throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "first", new Object[0]);
                }
                boolean bl = this.firstX();
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "first", bl);
                }
                return bl;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    private boolean firstX() throws SqlException {
        this.checkForClosedResultSet("first");
        this.checkThatResultSetTypeIsScrollable();
        this.clearWarningsX();
        this.moveToCurrentRowX();
        this.wasNull_ = 0;
        this.resetUpdatedColumns();
        this.resetRowsetFlags();
        this.unuseStreamsAndLOBs();
        if (this.rowIsInCurrentRowset(1L, 6)) {
            this.isValidCursorPosition_ = true;
            this.currentRowInRowset_ = 0L;
        } else {
            this.checkAndThrowReceivedQueryTerminatingException();
            this.isValidCursorPosition_ = this.getFirstRowset();
        }
        if (this.isValidCursorPosition_) {
            this.updateColumnInfoFromCache();
            this.isFirst_ = true;
            this.checkRowsetSqlca();
        }
        return this.isValidCursorPosition_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean last() throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "last", new Object[0]);
                }
                boolean bl = this.lastX();
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "last", bl);
                }
                return bl;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    private boolean lastX() throws SqlException {
        this.checkForClosedResultSet("last");
        this.checkThatResultSetTypeIsScrollable();
        this.clearWarningsX();
        this.moveToCurrentRowX();
        this.wasNull_ = 0;
        this.resetUpdatedColumns();
        this.resetRowsetFlags();
        this.unuseStreamsAndLOBs();
        if (this.rowCountIsUnknown()) {
            this.getRowCount();
        }
        long l2 = this.rowCount_;
        if (this.sensitivity_ != 3 && this.maxRows_ > 0L && this.rowCount_ > this.maxRows_) {
            l2 = this.maxRows_;
        }
        if (this.rowIsInCurrentRowset(l2, 7)) {
            this.isValidCursorPosition_ = true;
            this.currentRowInRowset_ = l2 - this.firstRowInRowset_;
        } else {
            this.checkAndThrowReceivedQueryTerminatingException();
            this.isValidCursorPosition_ = this.getLastRowset(l2);
        }
        if (this.isValidCursorPosition_) {
            this.updateColumnInfoFromCache();
            this.isLast_ = true;
            this.checkRowsetSqlca();
        }
        return this.isValidCursorPosition_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRow() throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "getRow", new Object[0]);
                }
                int n2 = this.getRowX();
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getRow", n2);
                }
                return n2;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    private int getRowX() throws SqlException {
        long l2;
        this.checkForClosedResultSet("getRow");
        this.checkThatResultSetIsNotDynamic();
        if (this.resultSetType_ == 1003) {
            l2 = this.cursor_.allRowsReceivedFromServer() && this.cursor_.currentRowPositionIsEqualToNextRowPosition() ? 0L : this.cursor_.rowsRead_;
        } else {
            if (this.rowCountIsUnknown()) {
                this.getRowCount();
            }
            l2 = this.rowCount_ == 0L || this.currentRowInRowset_ < 0L ? 0L : this.firstRowInRowset_ + this.currentRowInRowset_;
        }
        if (l2 > Integer.MAX_VALUE) {
            this.accumulateWarning(new SqlWarning(this.agent_.logWriter_, new ClientMessageId("01J13"), l2));
        }
        return (int)l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean absolute(int n2) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "absolute", n2);
                }
                boolean bl = this.absoluteX(n2);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "absolute", bl);
                }
                return bl;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    private boolean absoluteX(int n2) throws SqlException {
        this.checkForClosedResultSet("absolute");
        this.checkThatResultSetTypeIsScrollable();
        this.clearWarningsX();
        this.moveToCurrentRowX();
        this.wasNull_ = 0;
        this.resetUpdatedColumns();
        this.resetRowsetFlags();
        this.unuseStreamsAndLOBs();
        if (this.maxRows_ > 0L) {
            if (n2 > 0 && (long)n2 > this.maxRows_) {
                this.afterLastX();
                this.isValidCursorPosition_ = false;
                return this.isValidCursorPosition_;
            }
            if (n2 <= 0 && (long)Math.abs(n2) > this.maxRows_) {
                this.beforeFirstX();
                this.isValidCursorPosition_ = false;
                return this.isValidCursorPosition_;
            }
        }
        int n3 = 0;
        if (this.rowCountIsUnknown()) {
            this.getRowCount();
        }
        if (this.sensitivity_ == 3) {
            n3 = n2;
        } else {
            int n4 = n3 = n2 >= 0 ? n2 : (int)(this.rowCount_ + (long)n2 + 1L);
        }
        if (this.rowIsInCurrentRowset(n3, 2)) {
            this.isValidCursorPosition_ = true;
            this.currentRowInRowset_ = (long)n3 - this.firstRowInRowset_;
        } else {
            this.checkAndThrowReceivedQueryTerminatingException();
            this.isValidCursorPosition_ = this.getAbsoluteRowset(n3);
        }
        if (this.isValidCursorPosition_) {
            this.updateColumnInfoFromCache();
            if (n2 == 1) {
                this.isFirst_ = true;
            }
            if (n2 == -1) {
                this.isLast_ = true;
            }
            this.checkRowsetSqlca();
        }
        return this.isValidCursorPosition_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean relative(int n2) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "relative", n2);
                }
                boolean bl = this.relativeX(n2);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "relative", bl);
                }
                return bl;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    private boolean relativeX(int n2) throws SqlException {
        this.checkForClosedResultSet("relative");
        this.checkThatResultSetTypeIsScrollable();
        this.clearWarningsX();
        this.moveToCurrentRowX();
        this.wasNull_ = 0;
        this.resetUpdatedColumns();
        this.unuseStreamsAndLOBs();
        if (this.resultSetContainsNoRows()) {
            this.isValidCursorPosition_ = false;
            return this.isValidCursorPosition_;
        }
        if (n2 == 0) {
            this.isValidCursorPosition_ = this.resultSetConcurrency_ == 1008 && this.resultSetType_ == 1004 ? this.getAbsoluteRowset(this.absolutePosition_) : !this.isBeforeFirstX() && !this.isAfterLastX();
            return this.isValidCursorPosition_;
        }
        if (this.isBeforeFirstX()) {
            if (n2 > 0) {
                this.nextX();
                return this.relativeX(n2 - 1);
            }
            this.isValidCursorPosition_ = false;
            return this.isValidCursorPosition_;
        }
        if (this.isAfterLastX()) {
            if (n2 < 0) {
                this.previousX();
                return this.relativeX(n2 + 1);
            }
            this.isValidCursorPosition_ = false;
            return this.isValidCursorPosition_;
        }
        this.resetRowsetFlags();
        long l2 = this.firstRowInRowset_ + this.currentRowInRowset_;
        if (this.sensitivity_ != 3 && this.maxRows_ > 0L && n2 > 0 && l2 + (long)n2 > this.maxRows_) {
            this.afterLastX();
            this.isValidCursorPosition_ = false;
            return this.isValidCursorPosition_;
        }
        if (this.rowIsInCurrentRowset(l2 + (long)n2, 1)) {
            this.currentRowInRowset_ += (long)n2;
            this.isValidCursorPosition_ = true;
        } else {
            long l3;
            this.checkAndThrowReceivedQueryTerminatingException();
            long l4 = l3 = this.sensitivity_ == 3 ? this.currentRowInRowset_ + (long)n2 : l2 + (long)n2 - this.absolutePosition_;
            if (this.maxRows_ < Math.abs(l3) && this.maxRows_ != 0L) {
                if (l3 > 0L) {
                    this.afterLastX();
                } else {
                    this.beforeFirstX();
                }
                this.isValidCursorPosition_ = false;
                return this.isValidCursorPosition_;
            }
            this.isValidCursorPosition_ = this.getRelativeRowset(l3);
        }
        if (this.isValidCursorPosition_) {
            this.updateColumnInfoFromCache();
            this.checkRowsetSqlca();
        }
        return this.isValidCursorPosition_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean previous() throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "previous", new Object[0]);
                }
                boolean bl = this.previousX();
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "previous", bl);
                }
                return bl;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    private boolean previousX() throws SqlException {
        this.checkForClosedResultSet("previous");
        this.checkThatResultSetTypeIsScrollable();
        this.clearWarningsX();
        this.moveToCurrentRowX();
        this.wasNull_ = 0;
        this.resetUpdatedColumns();
        this.unuseStreamsAndLOBs();
        this.isBeforeFirst_ = false;
        this.isFirst_ = false;
        if (this.rowIsInCurrentRowset(this.firstRowInRowset_ + this.currentRowInRowset_ - 1L, 5)) {
            this.isValidCursorPosition_ = true;
            --this.currentRowInRowset_;
        } else {
            this.checkAndThrowReceivedQueryTerminatingException();
            this.isValidCursorPosition_ = this.getPreviousRowset();
        }
        if (this.isValidCursorPosition_) {
            this.updateColumnInfoFromCache();
            this.checkRowsetSqlca();
            if (this.isAfterLast_) {
                this.isLast_ = true;
            }
        } else {
            return this.isValidCursorPosition_;
        }
        this.isAfterLast_ = false;
        if (this.sensitivity_ != 3 && this.maxRows_ > 0L && this.firstRowInRowset_ + this.currentRowInRowset_ > this.maxRows_) {
            this.isValidCursorPosition_ = false;
        }
        return this.isValidCursorPosition_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFetchDirection(int n2) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "setFetchDirection", n2);
                }
                this.checkForClosedResultSet("setFetchDirection");
                this.checkThatResultSetTypeIsScrollable();
                switch (n2) {
                    case 1000: 
                    case 1001: 
                    case 1002: {
                        this.fetchDirection_ = n2;
                        break;
                    }
                    default: {
                        throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ064.S"), n2);
                    }
                }
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        try {
            this.checkForClosedResultSet("getFetchDirection");
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getFetchDirection", this.fetchDirection_);
            }
            return this.fetchDirection_;
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFetchSize(int n2) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "setFetchSize", n2);
                }
                this.checkForClosedResultSet("setFetchSize");
                if (n2 < 0) {
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ062.S"), n2).getSQLException();
                }
                this.setFetchSize_(n2);
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public int getFetchSize() throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getFetchSize", this.fetchSize_);
            }
            this.checkForClosedResultSet("getFetchSize");
            return this.suggestedFetchSize_;
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public int getType() throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getType", this.resultSetType_);
            }
            this.checkForClosedResultSet("getType");
            return this.resultSetType_;
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public int getConcurrency() throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getConcurrency", this.resultSetConcurrency_);
            }
            this.checkForClosedResultSet("getConcurrency");
            return this.resultSetConcurrency_;
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        try {
            this.checkForClosedResultSet("rowUpdated");
            this.checkPositionedOnPlainRow();
            boolean bl = this.cursor_.getIsRowUpdated();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "rowUpdated", bl);
            }
            return bl;
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public boolean rowInserted() throws SQLException {
        try {
            this.checkForClosedResultSet("rowInserted");
            this.checkPositionedOnPlainRow();
            boolean bl = false;
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "rowInserted", bl);
            }
            return bl;
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        try {
            boolean bl;
            this.checkForClosedResultSet("rowDeleted");
            this.checkPositionedOnPlainRow();
            boolean bl2 = bl = this.resultSetType_ == 1004 ? this.cursor_.getIsUpdateDeleteHole() : false;
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "rowDeleted", bl);
            }
            return bl;
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateNull(int n2) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "updateNull", n2);
                }
                this.checkUpdatePreconditions(n2, "updateNull");
                if (!this.resultSetMetaData_.nullable_[n2 - 1]) {
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("23502"), n2);
                }
                this.updateColumn(n2, null);
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateBoolean(int n2, boolean bl) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "updateBoolean", n2, bl);
                }
                this.checkUpdatePreconditions(n2, "updateBoolean");
                this.updateColumn(n2, this.agent_.crossConverters_.setObject(this.resultSetMetaData_.types_[n2 - 1], bl));
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateByte(int n2, byte by) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "updateByte", n2, by);
                }
                this.checkUpdatePreconditions(n2, "updateByte");
                this.updateColumn(n2, this.agent_.crossConverters_.setObject(this.resultSetMetaData_.types_[n2 - 1], by));
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateShort(int n2, short s2) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "updateShort", n2, s2);
                }
                this.checkUpdatePreconditions(n2, "updateShort");
                this.updateColumn(n2, this.agent_.crossConverters_.setObject(this.resultSetMetaData_.types_[n2 - 1], s2));
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateInt(int n2, int n3) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "updateInt", n2, n3);
                }
                this.checkUpdatePreconditions(n2, "updateInt");
                this.updateColumn(n2, this.agent_.crossConverters_.setObject(this.resultSetMetaData_.types_[n2 - 1], n3));
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateLong(int n2, long l2) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "updateLong", n2, l2);
                }
                this.checkUpdatePreconditions(n2, "updateLong");
                this.updateColumn(n2, this.agent_.crossConverters_.setObject(this.resultSetMetaData_.types_[n2 - 1], l2));
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateFloat(int n2, float f2) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "updateFloat", n2, Float.valueOf(f2));
                }
                this.checkUpdatePreconditions(n2, "updateFloat");
                this.updateColumn(n2, this.agent_.crossConverters_.setObject(this.resultSetMetaData_.types_[n2 - 1], f2));
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateDouble(int n2, double d2) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "updateDouble", n2, d2);
                }
                this.checkUpdatePreconditions(n2, "updateDouble");
                this.updateColumn(n2, this.agent_.crossConverters_.setObject(this.resultSetMetaData_.types_[n2 - 1], d2));
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateBigDecimal(int n2, BigDecimal bigDecimal) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "updateBigDecimal", n2, bigDecimal);
                }
                this.checkUpdatePreconditions(n2, "updateBigDecimal");
                this.updateColumn(n2, this.agent_.crossConverters_.setObject(this.resultSetMetaData_.types_[n2 - 1], bigDecimal));
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateDate(int n2, Date date) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "updateDate", n2, date);
                }
                this.checkUpdatePreconditions(n2, "updateDate");
                this.updateColumn(n2, this.agent_.crossConverters_.setObject(this.resultSetMetaData_.types_[n2 - 1], date));
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateTime(int n2, Time time) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "updateTime", n2, time);
                }
                this.checkUpdatePreconditions(n2, "updateTime");
                this.updateColumn(n2, this.agent_.crossConverters_.setObject(this.resultSetMetaData_.types_[n2 - 1], time));
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateTimestamp(int n2, Timestamp timestamp) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "updateTimestamp", n2, timestamp);
                }
                this.checkUpdatePreconditions(n2, "updateTimestamp");
                this.updateColumn(n2, this.agent_.crossConverters_.setObject(this.resultSetMetaData_.types_[n2 - 1], timestamp));
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateString(int n2, String string) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "updateString", n2, string);
                }
                this.checkUpdatePreconditions(n2, "updateString");
                this.updateColumn(n2, this.agent_.crossConverters_.setObject(this.resultSetMetaData_.types_[n2 - 1], string));
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateBytes(int n2, byte[] byArray) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "updateBytes", n2, byArray);
                }
                this.checkUpdatePreconditions(n2, "updateBytes");
                this.updateColumn(n2, this.agent_.crossConverters_.setObject(this.resultSetMetaData_.types_[n2 - 1], byArray));
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateBinaryStream(int n2, InputStream inputStream, int n3) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "", n2, inputStream, n3);
                }
                this.checkUpdatePreconditions(n2, "updateBinaryStream");
                this.updateColumn(n2, this.agent_.crossConverters_.setObjectFromBinaryStream(this.resultSetMetaData_.types_[n2 - 1], inputStream, n3));
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateAsciiStream(int n2, InputStream inputStream, int n3) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "updateAsciiStream", n2, inputStream, n3);
                }
                this.checkUpdatePreconditions(n2, "updateAsciiStream");
                this.updateColumn(n2, this.agent_.crossConverters_.setObjectFromCharacterStream(this.resultSetMetaData_.types_[n2 - 1], inputStream, Cursor.ISO_8859_1, n3));
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateCharacterStream(int n2, Reader reader, int n3) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "updateCharacterStream", n2, reader, n3);
                }
                this.checkUpdatePreconditions(n2, "updateCharacterStream");
                this.updateColumn(n2, this.agent_.crossConverters_.setObject(this.resultSetMetaData_.types_[n2 - 1], reader, n3));
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateObject(int n2, Object object, int n3) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "updateObject", n2, object, n3);
                }
                this.checkUpdatePreconditions(n2, "updateObject");
                this.updateColumn(n2, this.agent_.crossConverters_.setObject(this.resultSetMetaData_.types_[n2 - 1], object));
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateObject(int n2, Object object) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "updateObject", n2, object);
                }
                this.checkUpdatePreconditions(n2, "updateObject");
                this.updateColumn(n2, this.agent_.crossConverters_.setObject(this.resultSetMetaData_.types_[n2 - 1], object));
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public void updateNCharacterStream(int n2, Reader reader) throws SQLException {
        throw this.jdbc3MethodNotSupported();
    }

    @Override
    public void updateNClob(int n2, Reader reader) throws SQLException {
        throw this.jdbc3MethodNotSupported();
    }

    @Override
    public void updateNull(String string) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "updateNull", string);
            }
            this.updateNull(this.findColumnX(string, "updateNull"));
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public void updateBoolean(String string, boolean bl) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "updateBoolean", string, bl);
            }
            this.updateBoolean(this.findColumnX(string, "updateBoolean"), bl);
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public void updateByte(String string, byte by) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "updateByte", string, by);
            }
            this.updateByte(this.findColumnX(string, "updateByte"), by);
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public void updateShort(String string, short s2) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "updateShort", string, s2);
            }
            this.updateShort(this.findColumnX(string, "updateShort"), s2);
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public void updateInt(String string, int n2) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "updateInt", string, n2);
            }
            this.updateInt(this.findColumnX(string, "updateInt"), n2);
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public void updateLong(String string, long l2) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "updateLong", string, l2);
            }
            this.updateLong(this.findColumnX(string, "updateLong"), l2);
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public void updateFloat(String string, float f2) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "updateFloat", string, Float.valueOf(f2));
            }
            this.updateFloat(this.findColumnX(string, "updateFloat"), f2);
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public void updateDouble(String string, double d2) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "updateDouble", string, d2);
            }
            this.updateDouble(this.findColumnX(string, "updateDouble"), d2);
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "updateBigDecimal", string, bigDecimal);
            }
            this.updateBigDecimal(this.findColumnX(string, "updateBigDecimal"), bigDecimal);
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public void updateDate(String string, Date date) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "updateDate", string, date);
            }
            this.updateDate(this.findColumnX(string, "updateDate"), date);
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public void updateTime(String string, Time time) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "updateTime", string, time);
            }
            this.updateTime(this.findColumnX(string, "updateTime"), time);
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "updateTimestamp", string, timestamp);
            }
            this.updateTimestamp(this.findColumnX(string, "updateTimestamp"), timestamp);
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public void updateString(String string, String string2) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "updateString", string, string2);
            }
            this.updateString(this.findColumnX(string, "updateString"), string2);
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public void updateBytes(String string, byte[] byArray) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "updateBytes", string, byArray);
            }
            this.updateBytes(this.findColumnX(string, "updateBytes"), byArray);
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream, int n2) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "updateBinaryStream", string, inputStream, n2);
            }
            this.updateBinaryStream(this.findColumnX(string, "updateBinaryStream"), inputStream, n2);
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream, int n2) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "updateAsciiStream", string, inputStream, n2);
            }
            this.updateAsciiStream(this.findColumnX(string, "updateAsciiStream"), inputStream, n2);
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public void updateCharacterStream(String string, Reader reader, int n2) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "updateCharacterStream", string, reader, n2);
            }
            this.updateCharacterStream(this.findColumnX(string, "updateCharacterStream"), reader, n2);
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public void updateObject(String string, Object object, int n2) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "updateObject", string, object, n2);
            }
            this.updateObject(this.findColumnX(string, "updateObject"), object, n2);
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public void updateObject(String string, Object object) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "updateObject", string, object);
            }
            this.updateObject(this.findColumnX(string, "updateObject"), object);
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public void updateNCharacterStream(String string, Reader reader) throws SQLException {
        throw this.jdbc3MethodNotSupported();
    }

    @Override
    public void updateNClob(String string, Reader reader) throws SQLException {
        throw this.jdbc3MethodNotSupported();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertRow() throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "insertRow", new Object[0]);
                }
                this.insertRowX();
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    private void insertRowX() throws SqlException {
        this.checkForClosedResultSet("insertRow");
        this.checkForUpdatableResultSet("insertRow");
        if (this.isOnCurrentRow_) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ086.S"), new Object[0]);
        }
        if (!this.isValidCursorPosition_) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ121.S"), new Object[0]);
        }
        this.getPreparedStatementForInsert();
        int n2 = 0;
        for (int i2 = 0; i2 < this.updatedColumns_.length; ++i2) {
            if (this.resultSetMetaData_.sqlxUpdatable_[i2] != 1 || !this.columnUpdated_[i2]) continue;
            ++n2;
            if (this.updatedColumns_[i2] == null && (this.updatedColumns_[i2] != null || !this.columnUpdated_[i2])) continue;
            this.preparedStatementForInsert_.setInput(n2, this.updatedColumns_[i2]);
        }
        this.insert();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateRow() throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "updateRow", new Object[0]);
                }
                if (this.updateRowX() && this.getType() == 1003) {
                    this.isValidCursorPosition_ = false;
                }
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateRowX() throws SqlException {
        int n2;
        this.checkForClosedResultSet("updateRow");
        this.checkForUpdatableResultSet("updateRow");
        if (this.isOnInsertRow_) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("24000"), new Object[0]);
        }
        if (!this.isValidCursorPosition_) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ121.S"), new Object[0]);
        }
        if (this.updatedColumns_ == null) {
            return false;
        }
        boolean bl = false;
        for (n2 = 0; n2 < this.updatedColumns_.length; ++n2) {
            if (!this.columnUpdated_[n2]) continue;
            bl = true;
            break;
        }
        if (!bl) {
            return false;
        }
        this.getPreparedStatementForUpdate();
        n2 = 0;
        for (int i2 = 0; i2 < this.updatedColumns_.length; ++i2) {
            Object object;
            if (this.resultSetMetaData_.sqlxUpdatable_[i2] != 1 || !this.columnUpdated_[i2]) continue;
            ++n2;
            if (this.updatedColumns_[i2] != null || this.updatedColumns_[i2] == null && this.columnUpdated_[i2]) {
                this.preparedStatementForUpdate_.setInput(n2, this.updatedColumns_[i2]);
                continue;
            }
            try {
                object = this.getObject(i2 + 1);
            }
            catch (SQLException sQLException) {
                throw new SqlException(sQLException);
            }
            if (object == null) {
                this.preparedStatementForUpdate_.setInput(n2, null);
                continue;
            }
            this.preparedStatementForUpdate_.setInput(n2, this.agent_.crossConverters_.setObject(this.resultSetMetaData_.types_[i2], object));
        }
        try {
            if (this.isRowsetCursor_ || this.sensitivity_ == 3 || this.sensitivity_ == 2) {
                this.update();
            } else {
                this.positionToCurrentRowAndUpdate();
            }
        }
        finally {
            this.resetUpdatedColumns();
        }
        if (this.resultSetType_ == 1004 && this.preparedStatementForUpdate_.updateCount_ > 0L) {
            this.getAbsoluteRowset(this.absolutePosition_);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteRow() throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "deleteRow", new Object[0]);
                }
                this.deleteRowX();
                this.isValidCursorPosition_ = false;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    private void deleteRowX() throws SqlException {
        this.checkForClosedResultSet("deleteRow");
        this.checkForUpdatableResultSet("deleteRow");
        this.resetUpdatedColumns();
        if (this.isOnInsertRow_) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("24000"), new Object[0]);
        }
        if (this.preparedStatementForDelete_ == null) {
            this.getPreparedStatementForDelete();
        }
        if (this.isRowsetCursor_ || this.sensitivity_ == 3 || this.sensitivity_ == 2) {
            this.delete();
        } else {
            this.positionToCurrentRowAndDelete();
        }
        if (this.resultSetType_ == 1003) {
            this.cursor_.isUpdateDeleteHole_ = true;
        } else if (this.preparedStatementForDelete_.updateCount_ > 0L) {
            this.cursor_.isUpdateDeleteHoleCache_.set((int)this.currentRowInRowset_, Cursor.ROW_IS_NULL);
            this.cursor_.isUpdateDeleteHole_ = this.cursor_.isUpdateDeleteHoleCache_.get((int)this.currentRowInRowset_);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshRow() throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "refreshRow", new Object[0]);
                }
                this.refreshRowX();
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    private void refreshRowX() throws SqlException {
        this.checkForClosedResultSet("refreshRow");
        this.checkThatResultSetTypeIsScrollable();
        this.checkForUpdatableResultSet("refreshRow");
        if (this.isBeforeFirstX() || this.isAfterLastX() || this.isOnInsertRow_) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("24000"), new Object[0]);
        }
        if (this.resultSetType_ == 1005) {
            this.isValidCursorPosition_ = this.getRefreshRowset();
            try {
                this.cancelRowUpdates();
            }
            catch (SQLException sQLException) {
                throw new SqlException(sQLException);
            }
            this.unuseStreamsAndLOBs();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelRowUpdates() throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "cancelRowUpdates", new Object[0]);
                }
                this.checkForClosedResultSet("cancelRowUpdates");
                this.checkForUpdatableResultSet("cancelRowUpdates");
                if (this.isOnInsertRow_) {
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ086.S"), new Object[0]);
                }
                if (!this.isValidCursorPosition_) {
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ121.S"), new Object[0]);
                }
                this.resetUpdatedColumns();
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moveToInsertRow() throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "moveToInsertRow", new Object[0]);
                }
                this.checkForClosedResultSet("moveToInsertRow");
                this.checkForUpdatableResultSet("moveToInsertRow");
                this.resetUpdatedColumnsForInsert();
                this.isOnInsertRow_ = true;
                this.isOnCurrentRow_ = false;
                this.savedIsValidCursorPosition_ = this.isValidCursorPosition_;
                this.isValidCursorPosition_ = true;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moveToCurrentRow() throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "moveToCurrentRow", new Object[0]);
                }
                this.checkForClosedResultSet("moveToCurrentRow");
                this.checkForUpdatableResultSet("moveToCurrentRow");
                this.moveToCurrentRowX();
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    private void moveToCurrentRowX() throws SqlException {
        if (this.isOnInsertRow_) {
            this.resetUpdatedColumns();
            this.isOnInsertRow_ = false;
            this.isOnCurrentRow_ = true;
            if (this.currentRowInRowset_ > 0L) {
                this.updateColumnInfoFromCache();
            }
            this.isValidCursorPosition_ = this.savedIsValidCursorPosition_;
        }
        if (this.isValidCursorPosition_) {
            this.lobState.checkCurrentRow(this.cursor_);
        }
    }

    @Override
    public Statement getStatement() throws SQLException {
        try {
            this.checkForClosedResultSet("getStatement");
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceExit((Object)this, "getStatement", this.statement_);
        }
        if (this.statement_.getOwner() != null) {
            return this.statement_.getOwner();
        }
        return this.statement_;
    }

    @Override
    public URL getURL(int n2) throws SQLException {
        throw this.jdbc3MethodNotSupported();
    }

    @Override
    public URL getURL(String string) throws SQLException {
        throw this.jdbc3MethodNotSupported();
    }

    @Override
    public void updateRef(int n2, Ref ref) throws SQLException {
        throw this.jdbc3MethodNotSupported();
    }

    @Override
    public void updateRef(String string, Ref ref) throws SQLException {
        throw this.jdbc3MethodNotSupported();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateBlob(int n2, Blob blob) throws SQLException {
        ClientConnection clientConnection = this.connection_;
        synchronized (clientConnection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "updateBlob", n2, blob);
            }
            try {
                this.checkUpdatePreconditions(n2, "updateBlob");
                this.updateColumn(n2, this.agent_.crossConverters_.setObject(this.resultSetMetaData_.types_[n2 - 1], blob));
            }
            catch (SqlException sqlException) {
                throw sqlException.getSQLException();
            }
        }
    }

    @Override
    public void updateBlob(String string, Blob blob) throws SQLException {
        try {
            this.updateBlob(this.findColumnX(string, "updateBlob"), blob);
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateBlob(int n2, InputStream inputStream, long l2) throws SQLException {
        ClientConnection clientConnection = this.connection_;
        synchronized (clientConnection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "updateBlob", n2, inputStream, (int)l2);
            }
            try {
                this.checkUpdatePreconditions(n2, "updateBlob");
                this.updateColumn(n2, this.agent_.crossConverters_.setObject(this.resultSetMetaData_.types_[n2 - 1], new ClientBlob(this.agent_, inputStream, (int)l2)));
            }
            catch (SqlException sqlException) {
                throw sqlException.getSQLException();
            }
        }
    }

    @Override
    public void updateBlob(String string, InputStream inputStream, long l2) throws SQLException {
        try {
            this.updateBlob(this.findColumnX(string, "updateBlob"), inputStream, l2);
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public void updateArray(int n2, Array array) throws SQLException {
        throw this.jdbc3MethodNotSupported();
    }

    @Override
    public void updateArray(String string, Array array) throws SQLException {
        throw this.jdbc3MethodNotSupported();
    }

    boolean repositionScrollableResultSetBeforeJDBC1PositionedUpdateDelete() throws SqlException {
        boolean bl = false;
        long l2 = this.getRowUncast() - this.absolutePosition_;
        if (l2 != 0L) {
            this.writePositioningFetch_(this.generatedSection_ == null ? this.statement_.getSection() : this.generatedSection_, 1, l2);
            this.absolutePosition_ += l2;
            bl = true;
        }
        return bl;
    }

    private void flowPositioningFetch(int n2, int n3) throws DisconnectException {
        try {
            this.agent_.beginWriteChain(this.statement_);
            this.writePositioningFetch_(this.generatedSection_ == null ? this.statement_.getSection() : this.generatedSection_, n2, n3);
            this.agent_.flow(this.statement_);
            this.readPositioningFetch_();
            this.agent_.endReadChain();
        }
        catch (SqlException sqlException) {
            throw new DisconnectException(this.agent_, sqlException);
        }
    }

    private void positionToCurrentRowAndUpdate() throws SqlException {
        this.agent_.beginWriteChain(this.statement_);
        long l2 = this.getRowUncast() - this.absolutePosition_;
        if (this.resultSetType_ != 1003 && (l2 != 0L || l2 == 0L && this.cursorUnpositionedOnServer_)) {
            this.writePositioningFetch_(this.generatedSection_ == null ? this.statement_.getSection() : this.generatedSection_, 1, l2);
        }
        try {
            this.writeUpdateRow(false);
        }
        catch (SQLException sQLException) {
            throw new SqlException(sQLException);
        }
        this.agent_.flow(this.statement_);
        this.absolutePosition_ += l2;
        if (this.resultSetType_ != 1003 && (l2 != 0L || l2 == 0L && this.cursorUnpositionedOnServer_)) {
            this.readPositioningFetch_();
            this.cursorUnpositionedOnServer_ = false;
            this.listenToUnitOfWork();
        }
        this.readUpdateRow();
        this.agent_.endReadChain();
    }

    private void insert() throws SqlException {
        this.agent_.beginWriteChain(this.statement_);
        try {
            this.writeInsertRow(false);
        }
        catch (SQLException sQLException) {
            throw new SqlException(sQLException);
        }
        this.agent_.flow(this.statement_);
        this.readInsertRow();
        this.agent_.endReadChain();
    }

    private void update() throws SqlException {
        this.agent_.beginWriteChain(this.statement_);
        if (this.isRowsetCursor_) {
            try {
                this.preparedStatementForUpdate_.setInt(this.updatedColumns_.length + 1, (int)(this.currentRowInRowset_ + 1L));
            }
            catch (SQLException sQLException) {
                throw new SqlException(sQLException);
            }
        }
        boolean bl = this.connection_.willAutoCommitGenerateFlow();
        try {
            this.writeUpdateRow(bl);
        }
        catch (SQLException sQLException) {
            throw new SqlException(sQLException);
        }
        if (bl) {
            this.connection_.writeCommit();
        }
        this.agent_.flow(this.statement_);
        this.readUpdateRow();
        if (bl) {
            this.connection_.readCommit();
        }
        this.agent_.endReadChain();
    }

    private void positionToCurrentRowAndDelete() throws SqlException {
        this.agent_.beginWriteChain(this.statement_);
        long l2 = this.getRowUncast() - this.absolutePosition_;
        if (this.resultSetType_ != 1003 && (l2 != 0L || l2 == 0L && this.cursorUnpositionedOnServer_)) {
            this.writePositioningFetch_(this.generatedSection_ == null ? this.statement_.getSection() : this.generatedSection_, 1, l2);
        }
        try {
            this.writeDeleteRow();
        }
        catch (SQLException sQLException) {
            throw new SqlException(sQLException);
        }
        this.agent_.flow(this.statement_);
        this.absolutePosition_ += l2;
        if (this.resultSetType_ != 1003 && (l2 != 0L || l2 == 0L && this.cursorUnpositionedOnServer_)) {
            this.readPositioningFetch_();
            this.cursorUnpositionedOnServer_ = false;
            this.listenToUnitOfWork();
        }
        this.readDeleteRow();
        this.agent_.endReadChain();
    }

    private void delete() throws SqlException {
        try {
            this.agent_.beginWriteChain(this.statement_);
            if (this.isRowsetCursor_) {
                this.preparedStatementForDelete_.setInt(1, (int)(this.currentRowInRowset_ + 1L));
            }
            this.writeDeleteRow();
            if (this.connection_.autoCommit_) {
                this.connection_.writeAutoCommit();
            }
            this.agent_.flow(this.statement_);
            this.readDeleteRow();
            if (this.connection_.autoCommit_) {
                this.connection_.readAutoCommit();
            }
            this.agent_.endReadChain();
        }
        catch (SQLException sQLException) {
            throw new SqlException(sQLException);
        }
    }

    private void setRowsetAfterLastEvent() throws SqlException {
        this.firstRowInRowset_ = 0L;
        this.lastRowInRowset_ = 0L;
        this.absolutePosition_ = this.maxRows_ == 0L ? this.rowCount_ + 1L : this.maxRows_ + 1L;
        this.currentRowInRowset_ = 0L;
        this.rowsReceivedInCurrentRowset_ = 0;
    }

    private void setRowsetBeforeFirstEvent() throws SqlException {
        this.firstRowInRowset_ = 0L;
        this.lastRowInRowset_ = 0L;
        this.absolutePosition_ = 0L;
        this.currentRowInRowset_ = -1L;
        this.rowsReceivedInCurrentRowset_ = 0;
    }

    private void setRowsetNoRowsEvent() {
        this.rowCount_ = 0L;
        this.firstRowInRowset_ = 0L;
        this.lastRowInRowset_ = 0L;
        this.absolutePosition_ = 0L;
        this.currentRowInRowset_ = -1L;
        this.rowsReceivedInCurrentRowset_ = 0;
    }

    private boolean isServersCursorPositionBeforeFirst() throws SqlException {
        return this.isBeforeFirstX() && this.firstRowInRowset_ == 0L && this.lastRowInRowset_ == 0L && this.absolutePosition_ == 0L;
    }

    private boolean isServerCursorPositionAfterLast() {
        return this.absolutePosition_ == this.rowCount_ + 1L;
    }

    public void setValidCursorPosition(boolean bl) {
        this.isValidCursorPosition_ = bl;
    }

    private void moveToAfterLast() throws DisconnectException {
        this.flowPositioningFetch(3, 0);
    }

    private void moveToBeforeFirst() throws DisconnectException {
        this.flowPositioningFetch(4, 0);
    }

    private void writeInsertRow(boolean bl) throws SQLException {
        try {
            this.preparedStatementForInsert_.materialPreparedStatement_.writeExecute_(this.preparedStatementForInsert_.getSection(), this.preparedStatementForInsert_.parameterMetaData_, this.preparedStatementForInsert_.parameters_, this.preparedStatementForInsert_.parameterMetaData_ == null ? 0 : this.preparedStatementForInsert_.parameterMetaData_.getColumnCount(), false, bl);
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    private void writeUpdateRow(boolean bl) throws SQLException {
        try {
            this.preparedStatementForUpdate_.materialPreparedStatement_.writeExecute_(this.preparedStatementForUpdate_.getSection(), this.preparedStatementForUpdate_.parameterMetaData_, this.preparedStatementForUpdate_.parameters_, this.preparedStatementForUpdate_.parameterMetaData_.getColumnCount(), false, bl);
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    private void writeDeleteRow() throws SQLException {
        try {
            if (this.isRowsetCursor_) {
                this.preparedStatementForDelete_.materialPreparedStatement_.writeExecute_(this.preparedStatementForDelete_.getSection(), this.preparedStatementForDelete_.parameterMetaData_, this.preparedStatementForDelete_.parameters_, this.preparedStatementForDelete_.parameterMetaData_.getColumnCount(), false, false);
            } else {
                this.preparedStatementForDelete_.materialPreparedStatement_.writeExecute_(this.preparedStatementForDelete_.getSection(), null, null, 0, false, false);
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    private void readInsertRow() throws DisconnectException, SqlException {
        this.preparedStatementForInsert_.materialPreparedStatement_.readExecute_();
    }

    private void readUpdateRow() throws DisconnectException, SqlException {
        this.preparedStatementForUpdate_.materialPreparedStatement_.readExecute_();
        this.accumulateWarning(this.preparedStatementForUpdate_.getSqlWarnings());
    }

    private void readDeleteRow() throws DisconnectException, SqlException {
        this.preparedStatementForDelete_.materialPreparedStatement_.readExecute_();
        this.accumulateWarning(this.preparedStatementForDelete_.getSqlWarnings());
    }

    @Override
    public void listenToUnitOfWork() {
        if (!this.listenToUnitOfWork_) {
            this.listenToUnitOfWork_ = true;
            this.connection_.CommitAndRollbackListeners_.put(this, null);
        }
    }

    @Override
    public void completeLocalCommit(Iterator iterator) {
        this.cursorUnpositionedOnServer_ = true;
        this.lobState.discardState();
        this.markAutoCommitted();
        if (!this.cursorHold_) {
            this.markClosed();
            this.nullOutReferenceInStatement();
            iterator.remove();
            this.listenToUnitOfWork_ = false;
        }
    }

    @Override
    public void completeLocalRollback(Iterator iterator) {
        this.lobState.discardState();
        this.markAutoCommitted();
        this.markClosed();
        this.nullOutReferenceInStatement();
        iterator.remove();
        this.listenToUnitOfWork_ = false;
    }

    private void nullOutReferenceInStatement() {
        if (this.statement_.resultSet_ == this) {
            this.statement_.resultSet_ = null;
        }
        if (this.statement_.resultSetList_ != null) {
            for (int i2 = 0; i2 < this.statement_.resultSetList_.length; ++i2) {
                if (this.statement_.resultSetList_[i2] != this) continue;
                this.statement_.resultSetList_[i2] = null;
            }
        }
    }

    void markClosed() {
        this.markClosed(false);
    }

    void markClosed(boolean bl) {
        this.openOnClient_ = false;
        this.openOnServer_ = false;
        this.statement_.resetCursorNameAndRemoveFromWhereCurrentOfMappings();
        this.statement_.removeClientCursorNameFromCache();
        this.markPositionedUpdateDeletePreparedStatementsClosed();
        if (bl) {
            this.connection_.CommitAndRollbackListeners_.remove(this);
        }
        this.closeStatementOnCompletion();
    }

    public void markClosedOnServer() {
        this.openOnServer_ = false;
    }

    void markAutoCommitted() {
        this.autoCommitted_ = true;
    }

    @Override
    public void earlyCloseComplete(Sqlca sqlca) {
        this.markClosedOnServer();
        this.queryTerminatingSqlca_ = sqlca;
        this.cursor_.setAllRowsReceivedFromServer(true);
    }

    @Override
    public int completeSqlca(Sqlca sqlca) {
        if (sqlca == null) {
            return 0;
        }
        int n2 = sqlca.getSqlCode();
        if (n2 == 100 || n2 == 20237) {
            this.cursor_.setAllRowsReceivedFromServer(true);
        } else if (n2 < 0) {
            this.connection_.agent_.accumulateReadException(new SqlException(this.agent_.logWriter_, sqlca));
        } else if (n2 > 0) {
            this.accumulateWarning(new SqlWarning(this.agent_.logWriter_, sqlca));
        }
        return n2;
    }

    public void setRowCountEvent(long l2) throws DisconnectException {
        if (this.rowCount_ == -1L) {
            this.rowCount_ = l2;
        }
    }

    @Override
    public void accumulateWarning(SqlWarning sqlWarning) {
        if (this.warnings_ == null) {
            this.warnings_ = sqlWarning;
        } else {
            this.warnings_.setNextException(sqlWarning);
        }
    }

    boolean rowCountIsUnknown() {
        if (this.sensitivity_ == 3) {
            return false;
        }
        return this.rowCount_ == -1L;
    }

    private void updateColumn(int n2, Object object) {
        if (this.updatedColumns_ == null) {
            this.updatedColumns_ = new Object[this.resultSetMetaData_.columns_];
        }
        if (this.columnUpdated_ == null) {
            this.columnUpdated_ = new boolean[this.resultSetMetaData_.columns_];
        }
        this.updatedColumns_[n2 - 1] = object;
        this.columnUpdated_[n2 - 1] = true;
    }

    private String buildInsertString() throws SqlException {
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer("INSERT INTO ");
        StringBuffer stringBuffer2 = new StringBuffer("VALUES (");
        stringBuffer.append(this.getTableName());
        stringBuffer.append(" (");
        for (int i2 = 1; i2 <= this.resultSetMetaData_.columns_; ++i2) {
            if (bl) {
                stringBuffer.append(",");
                stringBuffer2.append(",");
            }
            try {
                stringBuffer.append(Utils.quoteSqlIdentifier(this.resultSetMetaData_.getColumnName(i2)));
            }
            catch (SQLException sQLException) {
                throw new SqlException(sQLException);
            }
            if (this.columnUpdated_[i2 - 1]) {
                stringBuffer2.append("?");
            } else {
                stringBuffer2.append("DEFAULT");
            }
            bl = true;
        }
        stringBuffer.append(") ");
        stringBuffer2.append(") ");
        stringBuffer.append(stringBuffer2.toString());
        return stringBuffer.toString();
    }

    private String buildUpdateString() throws SqlException {
        int n2 = 0;
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer(64);
        stringBuffer.append("UPDATE ").append(this.getTableName()).append(" SET ");
        for (int i2 = 1; i2 <= this.resultSetMetaData_.columns_; ++i2) {
            if (!this.columnUpdated_[i2 - 1]) continue;
            if (bl) {
                stringBuffer.append(",");
            }
            try {
                stringBuffer.append(Utils.quoteSqlIdentifier(this.resultSetMetaData_.getColumnName(i2))).append(" = ? ");
            }
            catch (SQLException sQLException) {
                throw new SqlException(sQLException);
            }
            ++n2;
            bl = true;
        }
        if (!bl) {
            return null;
        }
        stringBuffer.append(" WHERE CURRENT OF ").append(this.getServerCursorName());
        if (this.isRowsetCursor_) {
            stringBuffer.append(" FOR ROW ? OF ROWSET");
        }
        return stringBuffer.toString();
    }

    private String buildDeleteString() throws SqlException {
        String string = "DELETE FROM ";
        string = string + this.getTableName() + " WHERE CURRENT OF \"" + this.getServerCursorName() + "\"";
        if (this.isRowsetCursor_) {
            string = string + " FOR ROW ? OF ROWSET";
        }
        return string;
    }

    private String getTableName() throws SqlException {
        int n2;
        int n3;
        String string = "";
        try {
            n3 = this.resultSetMetaData_.getColumnCount();
        }
        catch (SQLException sQLException) {
            throw new SqlException(sQLException);
        }
        for (n2 = 0; n2 < n3 && this.resultSetMetaData_.sqlxBasename_[n2] == null; ++n2) {
        }
        if (n2 == n3) {
            n2 = 0;
        }
        if (this.resultSetMetaData_.sqlxSchema_[n2] != null && !this.resultSetMetaData_.sqlxSchema_[n2].equals("")) {
            string = string + Utils.quoteSqlIdentifier(this.resultSetMetaData_.sqlxSchema_[n2]) + ".";
        }
        if (this.resultSetMetaData_.sqlxBasename_[n2] != null) {
            string = string + Utils.quoteSqlIdentifier(this.resultSetMetaData_.sqlxBasename_[n2]);
        }
        return string;
    }

    private String getServerCursorName() throws SqlException {
        return this.statement_.getSection().getServerCursorName();
    }

    private void getPreparedStatementForInsert() throws SqlException {
        String string = this.buildInsertString();
        try {
            this.preparedStatementForInsert_ = (ClientPreparedStatement)this.statement_.connection_.prepareStatement(string);
        }
        catch (SQLException sQLException) {
            throw new SqlException(sQLException);
        }
    }

    private void getPreparedStatementForUpdate() throws SqlException {
        String string = this.buildUpdateString();
        if (string == null) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ122.S"), new Object[0]);
        }
        this.preparedStatementForUpdate_ = this.statement_.connection_.preparePositionedUpdateStatement(string, this.statement_.getSection().getPositionedUpdateSection());
    }

    private void getPreparedStatementForDelete() throws SqlException {
        String string = this.buildDeleteString();
        this.preparedStatementForDelete_ = this.statement_.connection_.preparePositionedUpdateStatement(string, this.statement_.getSection().getPositionedUpdateSection());
    }

    private final void resetUpdatedColumnsForInsert() {
        for (int i2 = 0; i2 < this.resultSetMetaData_.columns_; ++i2) {
            this.updateColumn(i2 + 1, null);
            this.columnUpdated_[i2] = false;
        }
    }

    private final void resetUpdatedColumns() {
        if (this.updatedColumns_ != null) {
            Arrays.fill(this.updatedColumns_, null);
        }
        if (this.columnUpdated_ != null) {
            Arrays.fill(this.columnUpdated_, false);
        }
    }

    private final long getRowUncast() {
        return this.firstRowInRowset_ + this.currentRowInRowset_;
    }

    private final void checkGetterPreconditions(int n2, String string) throws SqlException {
        this.checkForClosedResultSet(string);
        this.checkForValidColumnIndex(n2);
        this.checkForValidCursorPosition();
    }

    private final void checkUpdatePreconditions(int n2, String string) throws SqlException {
        this.checkForClosedResultSet(string);
        this.checkForValidColumnIndex(n2);
        this.checkForUpdatableResultSet(string);
        if (!this.isOnCurrentRow_ && !this.isOnInsertRow_) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ123.S"), new Object[0]);
        }
        if (this.resultSetMetaData_.sqlxUpdatable_ == null || this.resultSetMetaData_.sqlxUpdatable_[n2 - 1] != 1) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ124.S"), new Object[0]);
        }
        if (!this.isValidCursorPosition_) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ121.S"), new Object[0]);
        }
    }

    private void checkForValidColumnIndex(int n2) throws SqlException {
        if (n2 < 1 || n2 > this.resultSetMetaData_.columns_) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XCL14.S"), n2, this.resultSetMetaData_.columns_);
        }
    }

    protected final void checkForClosedResultSet(String string) throws SqlException {
        if (!this.openOnClient_) {
            this.agent_.checkForDeferredExceptions();
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XCL16.S"), string);
        }
        this.agent_.checkForDeferredExceptions();
    }

    private final void checkForUpdatableResultSet(String string) throws SqlException {
        if (this.resultSetConcurrency_ == 1007) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ083.U"), string);
        }
    }

    private final void checkForValidCursorPosition() throws SqlException {
        if (!this.isValidCursorPosition_) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ121.S"), new Object[0]);
        }
    }

    private final void checkPositionedOnPlainRow() throws SqlException {
        if (this.isOnInsertRow_ || !this.isValidCursorPosition_) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("24000"), new Object[0]);
        }
    }

    private final void checkThatResultSetTypeIsScrollable() throws SqlException {
        if (this.resultSetType_ == 1003) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ125.S"), new Object[0]);
        }
    }

    private final void checkThatResultSetIsNotDynamic() throws SqlException {
        if (this.sensitivity_ == 3) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ126.S"), new Object[0]);
        }
    }

    private boolean resultSetContainsNoRows() throws SqlException {
        if (this.rowCountIsUnknown()) {
            this.getRowCount();
        }
        return this.rowCount_ == 0L;
    }

    private boolean rowIsInCurrentRowset(long l2, int n2) throws SqlException {
        if (this.sensitivity_ == 3) {
            switch (n2) {
                case 0: {
                    if (this.isAfterLast_) {
                        return false;
                    }
                    return this.currentRowInRowset_ + 1L < (long)this.rowsReceivedInCurrentRowset_;
                }
                case 5: {
                    if (this.isBeforeFirst_) {
                        return false;
                    }
                    return this.currentRowInRowset_ - 1L >= 0L;
                }
                case 1: {
                    return l2 < (long)this.rowsReceivedInCurrentRowset_ && l2 >= 0L;
                }
                case 2: 
                case 6: 
                case 7: {
                    return false;
                }
            }
            return false;
        }
        if (this.resultSetMetaData_.hasLobColumns()) {
            return false;
        }
        return this.rowIsInCurrentRowset(l2);
    }

    private boolean rowIsInCurrentRowset(long l2) {
        if (this.firstRowInRowset_ == this.lastRowInRowset_ && this.firstRowInRowset_ == 0L) {
            return false;
        }
        return l2 >= this.firstRowInRowset_ && l2 <= this.lastRowInRowset_;
    }

    private void markPositionedUpdateDeletePreparedStatementsClosed() {
        if (this.preparedStatementForUpdate_ != null) {
            this.preparedStatementForUpdate_.markClosed();
            this.preparedStatementForUpdate_ = null;
        }
        if (this.preparedStatementForDelete_ != null) {
            this.preparedStatementForDelete_.markClosed();
            this.preparedStatementForDelete_ = null;
        }
    }

    private void updateColumnInfoFromCache() {
        this.cursor_.columnDataPosition_ = this.cursor_.columnDataPositionCache_.get((int)this.currentRowInRowset_);
        this.cursor_.columnDataComputedLength_ = this.cursor_.columnDataLengthCache_.get((int)this.currentRowInRowset_);
        this.cursor_.isNull_ = this.cursor_.columnDataIsNullCache_.get((int)this.currentRowInRowset_);
        this.cursor_.isUpdateDeleteHole_ = this.cursor_.isUpdateDeleteHoleCache_.get((int)this.currentRowInRowset_);
    }

    protected final void checkAndThrowReceivedQueryTerminatingException() throws SqlException {
        if (!this.openOnServer_) {
            SqlException sqlException = null;
            int n2 = Utils.getSqlcodeFromSqlca(this.queryTerminatingSqlca_);
            if (n2 < 0) {
                sqlException = new SqlException(this.agent_.logWriter_, this.queryTerminatingSqlca_);
            } else if (n2 > 0 && n2 != 100) {
                this.accumulateWarning(new SqlWarning(this.agent_.logWriter_, this.queryTerminatingSqlca_));
            }
            try {
                this.closeX();
            }
            catch (SqlException sqlException2) {
                sqlException.setNextException(sqlException2);
            }
            if (sqlException != null) {
                throw sqlException;
            }
        }
    }

    void parseScrollableRowset() throws SqlException {
        if (this.cursor_.dataBufferHasUnprocessedData() && this.scrollable_) {
            this.parseRowset_();
            this.adjustFirstRowset();
            if (this.cursor_.allRowsReceivedFromServer() && this.rowsReceivedInCurrentRowset_ == 0) {
                this.setRowsetNoRowsEvent();
            }
        }
    }

    public byte getRSReturnability() {
        return this.rsReturnability_;
    }

    public void setRSReturnability(byte by) {
        this.rsReturnability_ = by == 1 || by == 2 ? by : (byte)1;
    }

    protected void getRowCount() throws SqlException {
        this.checkAndThrowReceivedQueryTerminatingException();
        this.agent_.beginWriteChain(this.statement_);
        Section section = this.generatedSection_ == null ? this.statement_.getSection() : this.generatedSection_;
        this.writePositioningFetch_(section, 3, 0L);
        if (this.isRowsetCursor_ && this.sensitivity_ != 3 && this.firstRowInRowset_ != 0L) {
            this.writePositioningFetch_(section, 2, this.firstRowInRowset_);
        }
        this.agent_.flow(this.statement_);
        this.readPositioningFetch_();
        if (this.isRowsetCursor_ && this.sensitivity_ != 3 && this.firstRowInRowset_ != 0L) {
            this.readPositioningFetch_();
        }
        this.agent_.endReadChain();
        if (this.rowCount_ == -1L) {
            this.checkAndThrowReceivedQueryTerminatingException();
        }
        this.absolutePosition_ = this.isRowsetCursor_ && this.sensitivity_ != 3 && this.firstRowInRowset_ != 0L ? this.firstRowInRowset_ : (this.maxRows_ == 0L ? this.rowCount_ + 1L : this.maxRows_ + 1L);
    }

    private void flowGetRowset(int n2, long l2) throws SqlException {
        this.cursor_.clearLobData_();
        this.cursor_.resetDataBuffer();
        this.agent_.beginWriteChain(this.statement_);
        this.writeScrollableFetch_(this.generatedSection_ == null ? this.statement_.getSection() : this.generatedSection_, this.fetchSize_, n2, l2, true);
        this.rowsReceivedInCurrentRowset_ = 0;
        this.agent_.flow(this.statement_);
        this.readScrollableFetch_();
        this.agent_.endReadChain();
    }

    private boolean getNextRowset() throws SqlException {
        if (this.isRowsetCursor_ || this.sensitivity_ == 3) {
            int n2 = this.checkRowsetSqlca((int)this.currentRowInRowset_ + 2);
            if (n2 == 100) {
                this.isAfterLast_ = true;
                return false;
            }
            this.flowGetRowset(0, 0L);
        } else {
            if (this.resultSetContainsNoRows() || this.isAfterLastX()) {
                return false;
            }
            if (this.firstRowInRowset_ + this.currentRowInRowset_ == this.lastRowInRowset_ && this.cursor_.allRowsReceivedFromServer()) {
                this.isAfterLast_ = true;
                this.setRowsetAfterLastEvent();
                return false;
            }
            long l2 = 1L;
            int n3 = 1;
            if (this.absolutePosition_ < this.lastRowInRowset_) {
                l2 = this.lastRowInRowset_ - this.absolutePosition_ + 1L;
                this.absolutePosition_ = this.lastRowInRowset_;
            } else if (this.absolutePosition_ > this.lastRowInRowset_) {
                l2 = this.lastRowInRowset_ + 1L;
                n3 = 2;
            }
            this.flowGetRowset(n3, l2);
        }
        this.parseRowset_();
        if (this.rowsReceivedInCurrentRowset_ == 0 && this.cursor_.allRowsReceivedFromServer()) {
            this.isAfterLast_ = true;
            this.setRowsetAfterLastEvent();
            return false;
        }
        if (this.sensitivity_ != 3) {
            this.adjustNextRowset();
        }
        this.currentRowInRowset_ = 0L;
        return true;
    }

    private void adjustNextRowset() {
        this.firstRowInRowset_ = this.lastRowInRowset_ + 1L;
        this.lastRowInRowset_ += (long)this.rowsReceivedInCurrentRowset_;
        this.setAbsolutePositionBasedOnAllRowsReceived();
    }

    private boolean getPreviousRowset() throws SqlException {
        int n2 = 1;
        long l2 = 0L;
        boolean bl = false;
        if (this.isRowsetCursor_ || this.sensitivity_ == 3) {
            if (this.currentRowInRowset_ == 0L && this.rowsetSqlca_ != null && this.rowsetSqlca_[0] != null && this.rowsetSqlca_[0].getSqlCode() == 20237) {
                this.isBeforeFirst_ = true;
                this.setRowsetBeforeFirstEvent();
                return false;
            }
            this.flowGetRowset(5, 0L);
        } else {
            if (this.resultSetContainsNoRows() || this.isBeforeFirstX()) {
                return false;
            }
            l2 = this.firstRowInRowset_ - this.absolutePosition_ - (long)this.fetchSize_;
            bl = this.isAfterLastX();
            if (this.isFirstX()) {
                l2 = 0L;
                n2 = 2;
            } else if (bl) {
                l2 = -1 * this.fetchSize_;
            }
            if (l2 * -1L >= this.absolutePosition_) {
                l2 = 1L;
                n2 = 2;
            }
            if (this.maxRows_ > 0L && n2 == 1 && bl) {
                l2 += this.maxRows_ + 1L;
                n2 = 2;
            }
            this.flowGetRowset(n2, l2);
        }
        this.parseRowset_();
        if (this.rowsReceivedInCurrentRowset_ == 0 && this.cursor_.allRowsReceivedFromServer()) {
            this.isBeforeFirst_ = true;
            this.setRowsetBeforeFirstEvent();
            return false;
        }
        if (this.sensitivity_ != 3) {
            this.adjustPreviousRowset(n2, l2, bl);
        } else {
            this.currentRowInRowset_ = this.rowsReceivedInCurrentRowset_ - 1;
        }
        return true;
    }

    private void adjustPreviousRowset(int n2, long l2, boolean bl) {
        if (n2 == 2 && l2 == 1L) {
            this.currentRowInRowset_ = bl ? this.absolutePosition_ - 2L : this.firstRowInRowset_ - 2L;
            this.firstRowInRowset_ = 1L;
            this.lastRowInRowset_ = this.rowsReceivedInCurrentRowset_;
            this.absolutePosition_ = bl ? this.lastRowInRowset_ + 1L : this.lastRowInRowset_;
        } else {
            this.lastRowInRowset_ = this.maxRows_ == 0L ? (bl ? this.rowCount_ : this.firstRowInRowset_ - 1L) : (bl ? this.maxRows_ : this.firstRowInRowset_ - 1L);
            this.firstRowInRowset_ = this.lastRowInRowset_ - (long)this.rowsReceivedInCurrentRowset_ + 1L;
            this.absolutePosition_ = this.lastRowInRowset_;
            this.currentRowInRowset_ = this.lastRowInRowset_ - this.firstRowInRowset_;
        }
    }

    private boolean getAbsoluteRowset(long l2) throws SqlException {
        int n2 = 2;
        if (this.isRowsetCursor_ && l2 == 0L) {
            n2 = 4;
        } else if (this.sensitivity_ != 3 && l2 < 0L) {
            l2 = 0L;
        }
        this.flowGetRowset(n2, l2);
        this.parseRowset_();
        if (this.rowsReceivedInCurrentRowset_ == 0 && this.cursor_.allRowsReceivedFromServer() || n2 == 4) {
            if (l2 > 0L) {
                this.setRowsetAfterLastEvent();
                this.isAfterLast_ = true;
            } else {
                this.setRowsetBeforeFirstEvent();
                this.isBeforeFirst_ = true;
            }
            return false;
        }
        if (this.sensitivity_ != 3) {
            this.adjustAbsoluteRowset(l2);
        }
        this.currentRowInRowset_ = 0L;
        return true;
    }

    private void adjustAbsoluteRowset(long l2) {
        this.firstRowInRowset_ = l2;
        this.lastRowInRowset_ = this.firstRowInRowset_ + (long)this.rowsReceivedInCurrentRowset_ - 1L;
        this.setAbsolutePositionBasedOnAllRowsReceived();
    }

    private boolean getRelativeRowset(long l2) throws SqlException {
        if (l2 == 0L && (this.cursor_.allRowsReceivedFromServer() || this.absolutePosition_ > this.rowCount_)) {
            this.setRowsetAfterLastEvent();
            this.isAfterLast_ = true;
            return false;
        }
        this.flowGetRowset(1, l2);
        this.parseRowset_();
        if (this.rowsReceivedInCurrentRowset_ == 0 && this.cursor_.allRowsReceivedFromServer()) {
            if (l2 > 0L) {
                this.setRowsetAfterLastEvent();
                this.isAfterLast_ = true;
            } else {
                this.setRowsetBeforeFirstEvent();
                this.isBeforeFirst_ = true;
            }
            return false;
        }
        if (this.sensitivity_ != 3) {
            this.adjustRelativeRowset(l2);
        }
        this.currentRowInRowset_ = 0L;
        return true;
    }

    private void adjustRelativeRowset(long l2) {
        this.firstRowInRowset_ = this.absolutePosition_ + l2;
        this.lastRowInRowset_ = this.firstRowInRowset_ + (long)this.rowsReceivedInCurrentRowset_ - 1L;
        this.setAbsolutePositionBasedOnAllRowsReceived();
    }

    private boolean getFirstRowset() throws SqlException {
        this.flowGetRowset(2, 1L);
        this.parseRowset_();
        if (this.rowsReceivedInCurrentRowset_ == 0 && this.cursor_.allRowsReceivedFromServer()) {
            this.resetRowsetFlags();
            this.setRowsetNoRowsEvent();
            return false;
        }
        if (this.sensitivity_ != 3) {
            this.adjustFirstRowset();
        }
        this.currentRowInRowset_ = 0L;
        return true;
    }

    private void adjustFirstRowset() {
        this.firstRowInRowset_ = 1L;
        this.lastRowInRowset_ = this.rowsReceivedInCurrentRowset_;
        this.setAbsolutePositionBasedOnAllRowsReceived();
    }

    private boolean getLastRowset(long l2) throws SqlException {
        if (this.sensitivity_ != 3 && this.rowCount_ == 0L) {
            this.isAfterLast_ = false;
            this.isBeforeFirst_ = false;
            this.setRowsetNoRowsEvent();
            return false;
        }
        if (this.isRowsetCursor_ || this.sensitivity_ == 3) {
            this.flowGetRowset(7, 0L);
        } else {
            long l3 = this.maxRows_ == 0L ? ((long)this.fetchSize_ < l2 ? (long)(-1 * this.fetchSize_) : 1L) : ((long)this.fetchSize_ < l2 ? this.maxRows_ - (long)this.fetchSize_ + 1L : 1L);
            this.flowGetRowset(2, l3);
        }
        this.parseRowset_();
        if (this.rowsReceivedInCurrentRowset_ == 0 && this.cursor_.allRowsReceivedFromServer()) {
            this.isAfterLast_ = true;
            this.setRowsetAfterLastEvent();
            return false;
        }
        if (this.sensitivity_ != 3) {
            this.adjustLastRowset(l2);
        } else {
            this.currentRowInRowset_ = this.rowsReceivedInCurrentRowset_ - 1;
        }
        return true;
    }

    private void adjustLastRowset(long l2) {
        this.lastRowInRowset_ = l2;
        this.firstRowInRowset_ = this.lastRowInRowset_ - (long)this.rowsReceivedInCurrentRowset_ + 1L;
        if (this.firstRowInRowset_ <= 0L) {
            this.firstRowInRowset_ = 1L;
        }
        this.setAbsolutePositionBasedOnAllRowsReceived();
        this.currentRowInRowset_ = this.lastRowInRowset_ - this.firstRowInRowset_;
    }

    private boolean getRefreshRowset() throws SqlException {
        if (this.isRowsetCursor_) {
            this.flowGetRowset(8, 0L);
        } else {
            this.flowGetRowset(1, -1L * (this.absolutePosition_ - this.firstRowInRowset_));
        }
        this.parseRowset_();
        if (this.sensitivity_ != 3) {
            this.adjustRefreshRowset();
        }
        return true;
    }

    private void adjustRefreshRowset() {
        this.setAbsolutePositionBasedOnAllRowsReceived();
        this.updateColumnInfoFromCache();
    }

    private void setAbsolutePositionBasedOnAllRowsReceived() {
        this.absolutePosition_ = this.cursor_.allRowsReceivedFromServer() ? this.lastRowInRowset_ + 1L : this.lastRowInRowset_;
    }

    public abstract void writeFetch_(Section var1) throws SqlException;

    public abstract void readFetch_() throws SqlException;

    public abstract void writeScrollableFetch_(Section var1, int var2, int var3, long var4, boolean var6) throws SqlException;

    public abstract void readScrollableFetch_() throws SqlException;

    public abstract void writePositioningFetch_(Section var1, int var2, long var3) throws SqlException;

    public abstract void readPositioningFetch_() throws SqlException;

    public abstract void writeCursorClose_(Section var1) throws SqlException;

    public abstract void readCursorClose_() throws SqlException;

    protected abstract void parseRowset_() throws SqlException;

    public abstract void setFetchSize_(int var1);

    protected abstract void preClose_() throws SqlException;

    @Override
    public ConnectionCallbackInterface getConnectionCallbackInterface() {
        return this.connection_;
    }

    @Override
    public StatementCallbackInterface getStatementCallbackInterface() {
        return this.statement_;
    }

    public void expandRowsetSqlca() {
        if (this.isRowsetCursor_ && (this.rowsetSqlca_ == null || this.rowsetSqlca_.length < this.fetchSize_ + 2)) {
            this.rowsetSqlca_ = new Sqlca[this.fetchSize_ + 2];
        }
    }

    private final int checkRowsetSqlca() throws SqlException {
        return this.checkRowsetSqlca((int)this.currentRowInRowset_ + 1);
    }

    private final int checkRowsetSqlca(int n2) throws SqlException {
        int n3 = 0;
        if (!this.isRowsetCursor_ || this.rowsetSqlca_ == null || this.rowsetSqlca_[n2] == null) {
            return n3;
        }
        Sqlca sqlca = this.rowsetSqlca_[n2];
        if (sqlca != null) {
            n3 = sqlca.getSqlCode();
            if (n3 < 0) {
                throw new SqlException(this.agent_.logWriter_, sqlca);
            }
            if (n3 > 0 && n3 != 100 && n3 != 20237) {
                this.accumulateWarning(new SqlWarning(this.agent_.logWriter_, sqlca));
            }
        }
        return n3;
    }

    private void resetRowsetFlags() {
        this.isBeforeFirst_ = false;
        this.isAfterLast_ = false;
        this.isFirst_ = false;
        this.isLast_ = false;
    }

    private void resetRowsetSqlca() {
        if (this.rowsetSqlca_ != null) {
            Arrays.fill(this.rowsetSqlca_, null);
        }
    }

    private CloseFilterInputStream createCloseFilterInputStream(InputStream inputStream) throws SqlException {
        if (inputStream == null) {
            return null;
        }
        if (this.currentStream == inputStream) {
            return this.currentStream;
        }
        this.closeOpenStreams();
        this.currentStream = new CloseFilterInputStream(inputStream);
        return this.currentStream;
    }

    private void closeOpenStreams() throws SqlException {
        if (this.currentStream != null) {
            try {
                this.currentStream.close();
            }
            catch (IOException iOException) {
                throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ001.U"), iOException, "java.io.IOException", iOException.getMessage());
            }
            this.currentStream = null;
        }
        if (this.currentReader != null) {
            try {
                this.currentReader.close();
            }
            catch (IOException iOException) {
                throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ001.U"), iOException, "java.io.IOException", iOException.getMessage());
            }
            this.currentReader = null;
        }
    }

    private void useStreamOrLOB(int n2) throws SqlException {
        this.checkLOBMultiCall(n2);
        this.columnUsedFlags_[n2 - 1] = true;
    }

    private void checkLOBMultiCall(int n2) throws SqlException {
        if (this.columnUsedFlags_ == null) {
            this.columnUsedFlags_ = new boolean[this.resultSetMetaData_.columns_];
        }
        if (this.columnUsedFlags_[n2 - 1]) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XCL18.S"), new Object[0]);
        }
    }

    private void unuseStreamsAndLOBs() {
        if (this.columnUsedFlags_ != null) {
            Arrays.fill(this.columnUsedFlags_, false);
        }
    }

    private SQLException jdbc3MethodNotSupported() {
        return new SqlException(this.agent_.logWriter_, new ClientMessageId("0A000.S.1"), new Object[0]).getSQLException();
    }

    @Override
    public final int getHoldability() throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "getHoldability", new Object[0]);
        }
        try {
            this.checkForClosedResultSet("getHoldability");
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceExit((Object)this, "getHoldability", this.resultSetHoldability_);
        }
        return this.resultSetHoldability_;
    }

    @Override
    public final boolean isClosed() throws SQLException {
        boolean bl;
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "isClosed", new Object[0]);
        }
        boolean bl2 = bl = !this.openOnClient_;
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceExit((Object)this, "isClosed", bl);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateAsciiStream(int n2, InputStream inputStream) throws SQLException {
        ClientConnection clientConnection = this.connection_;
        synchronized (clientConnection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "updateAsciiStream", n2, inputStream);
            }
            try {
                this.checkUpdatePreconditions(n2, "updateAsciiStream");
                this.updateColumn(n2, this.agent_.crossConverters_.setObjectFromCharacterStream(this.resultSetMetaData_.types_[n2 - 1], inputStream, Cursor.ISO_8859_1, Integer.MIN_VALUE));
            }
            catch (SqlException sqlException) {
                throw sqlException.getSQLException();
            }
        }
    }

    @Override
    public void updateAsciiStream(int n2, InputStream inputStream, long l2) throws SQLException {
        if (l2 > Integer.MAX_VALUE) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("22003.S.4"), l2, Integer.MAX_VALUE).getSQLException();
        }
        this.updateAsciiStream(n2, inputStream, (int)l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateBinaryStream(int n2, InputStream inputStream) throws SQLException {
        ClientConnection clientConnection = this.connection_;
        synchronized (clientConnection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "updateBinaryStream", n2, inputStream);
            }
            try {
                this.checkUpdatePreconditions(n2, "updateBinaryStream");
                this.updateColumn(n2, this.agent_.crossConverters_.setObjectFromBinaryStream(this.resultSetMetaData_.types_[n2 - 1], inputStream, Integer.MIN_VALUE));
            }
            catch (SqlException sqlException) {
                throw sqlException.getSQLException();
            }
        }
    }

    @Override
    public void updateBinaryStream(int n2, InputStream inputStream, long l2) throws SQLException {
        if (l2 > Integer.MAX_VALUE) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("22003.S.4"), l2, Integer.MAX_VALUE).getSQLException();
        }
        this.updateBinaryStream(n2, inputStream, (int)l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateBlob(int n2, InputStream inputStream) throws SQLException {
        ClientConnection clientConnection = this.connection_;
        synchronized (clientConnection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "updateBlob", n2, inputStream);
            }
            try {
                this.checkUpdatePreconditions(n2, "updateBlob");
                this.updateColumn(n2, this.agent_.crossConverters_.setObject(this.resultSetMetaData_.types_[n2 - 1], new ClientBlob(this.agent_, inputStream)));
            }
            catch (SqlException sqlException) {
                throw sqlException.getSQLException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateCharacterStream(int n2, Reader reader) throws SQLException {
        ClientConnection clientConnection = this.connection_;
        synchronized (clientConnection) {
            try {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "updateCharacterStream", n2, reader);
                }
                this.checkUpdatePreconditions(n2, "updateCharacterStream");
                this.updateColumn(n2, this.agent_.crossConverters_.setObject(this.resultSetMetaData_.types_[n2 - 1], reader, Integer.MIN_VALUE));
            }
            catch (SqlException sqlException) {
                throw sqlException.getSQLException();
            }
        }
    }

    @Override
    public void updateCharacterStream(int n2, Reader reader, long l2) throws SQLException {
        if (l2 > Integer.MAX_VALUE) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("22003.S.4"), l2, Integer.MAX_VALUE).getSQLException();
        }
        this.updateCharacterStream(n2, reader, (int)l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateClob(int n2, Reader reader) throws SQLException {
        ClientConnection clientConnection = this.connection_;
        synchronized (clientConnection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "updateClob", n2, reader);
            }
            try {
                this.checkUpdatePreconditions(n2, "updateClob");
                this.updateColumn(n2, this.agent_.crossConverters_.setObject(this.resultSetMetaData_.types_[n2 - 1], new ClientClob(this.agent_, reader)));
            }
            catch (SqlException sqlException) {
                throw sqlException.getSQLException();
            }
        }
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream) throws SQLException {
        try {
            this.updateAsciiStream(this.findColumnX(string, "updateAsciiStream"), inputStream);
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream, long l2) throws SQLException {
        try {
            this.updateAsciiStream(this.findColumnX(string, "updateAsciiStream"), inputStream, l2);
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream) throws SQLException {
        try {
            this.updateBinaryStream(this.findColumnX(string, "updateBinaryStream"), inputStream);
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream, long l2) throws SQLException {
        try {
            this.updateBinaryStream(this.findColumnX(string, "updateBinaryStream"), inputStream, l2);
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public void updateBlob(String string, InputStream inputStream) throws SQLException {
        try {
            this.updateBlob(this.findColumnX(string, "updateBlob"), inputStream);
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public void updateCharacterStream(String string, Reader reader) throws SQLException {
        try {
            this.updateCharacterStream(this.findColumnX(string, "updateCharacterStream"), reader);
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public void updateCharacterStream(String string, Reader reader, long l2) throws SQLException {
        try {
            this.updateCharacterStream(this.findColumnX(string, "updateCharacterStream"), reader, l2);
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public void updateClob(String string, Reader reader) throws SQLException {
        try {
            this.updateClob(this.findColumnX(string, "updateClob"), reader);
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateClob(int n2, Reader reader, long l2) throws SQLException {
        ClientConnection clientConnection = this.connection_;
        synchronized (clientConnection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "updateClob", n2, reader, (int)l2);
            }
            try {
                this.checkUpdatePreconditions(n2, "updateClob");
                this.updateColumn(n2, this.agent_.crossConverters_.setObject(this.resultSetMetaData_.types_[n2 - 1], new ClientClob(this.agent_, reader, (int)l2)));
            }
            catch (SqlException sqlException) {
                throw sqlException.getSQLException();
            }
        }
    }

    @Override
    public void updateClob(String string, Reader reader, long l2) throws SQLException {
        try {
            this.updateClob(this.findColumnX(string, "updateClob"), reader);
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateClob(int n2, Clob clob) throws SQLException {
        ClientConnection clientConnection = this.connection_;
        synchronized (clientConnection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "updateClob", n2, clob);
            }
            try {
                this.checkUpdatePreconditions(n2, "updateClob");
                this.updateColumn(n2, this.agent_.crossConverters_.setObject(this.resultSetMetaData_.types_[n2 - 1], clob));
            }
            catch (SqlException sqlException) {
                throw sqlException.getSQLException();
            }
        }
    }

    @Override
    public void updateClob(String string, Clob clob) throws SQLException {
        try {
            this.updateClob(this.findColumnX(string, "updateClob"), clob);
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    public final void markLOBAsPublished(int n2) {
        this.lobState.markAsPublished(n2);
    }

    final void createLOBColumnTracker() {
        if (this.connection_.supportsSessionDataCaching() && this.resultSetMetaData_.hasLobColumns()) {
            int n2 = this.resultSetMetaData_.columns_;
            int n3 = 0;
            int[] nArray = new int[n2];
            boolean[] blArray = new boolean[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                int n4 = this.resultSetMetaData_.types_[i2];
                if (n4 != 2004 && n4 != 2005) continue;
                nArray[n3] = i2 + 1;
                blArray[n3++] = n4 == 2004;
            }
            int[] nArray2 = new int[n3];
            boolean[] blArray2 = new boolean[n3];
            System.arraycopy(nArray, 0, nArray2, 0, n3);
            System.arraycopy(blArray, 0, blArray2, 0, n3);
            this.lobState = new LOBStateTracker(nArray2, blArray2, true);
        } else {
            this.lobState = LOBStateTracker.NO_OP_TRACKER;
        }
    }

    @Override
    public Reader getNCharacterStream(int n2) throws SQLException {
        throw SQLExceptionFactory.notImplemented("getNCharacterStream(int)");
    }

    @Override
    public Reader getNCharacterStream(String string) throws SQLException {
        throw SQLExceptionFactory.notImplemented("getNCharacterStream(String)");
    }

    @Override
    public String getNString(int n2) throws SQLException {
        throw SQLExceptionFactory.notImplemented("getNString(int)");
    }

    @Override
    public String getNString(String string) throws SQLException {
        throw SQLExceptionFactory.notImplemented("getNString(String)");
    }

    @Override
    public RowId getRowId(int n2) throws SQLException {
        throw SQLExceptionFactory.notImplemented("getRowId (int)");
    }

    @Override
    public RowId getRowId(String string) throws SQLException {
        throw SQLExceptionFactory.notImplemented("getRowId (String)");
    }

    @Override
    public void updateRowId(int n2, RowId rowId) throws SQLException {
        throw SQLExceptionFactory.notImplemented("updateRowId (int, RowId)");
    }

    @Override
    public void updateRowId(String string, RowId rowId) throws SQLException {
        throw SQLExceptionFactory.notImplemented("updateRowId (String, RowId)");
    }

    @Override
    public void updateNString(int n2, String string) throws SQLException {
        throw SQLExceptionFactory.notImplemented("updateNString (int, String)");
    }

    @Override
    public void updateNString(String string, String string2) throws SQLException {
        throw SQLExceptionFactory.notImplemented("updateNString (String, String)");
    }

    @Override
    public void updateNCharacterStream(int n2, Reader reader, long l2) throws SQLException {
        throw SQLExceptionFactory.notImplemented("updateNCharacterStream(int,Reader,long)");
    }

    @Override
    public void updateNCharacterStream(String string, Reader reader, long l2) throws SQLException {
        throw SQLExceptionFactory.notImplemented("updateNCharacterStream(String,Reader,long)");
    }

    @Override
    public void updateNClob(int n2, NClob nClob) throws SQLException {
        throw SQLExceptionFactory.notImplemented("updateNClob (int, NClob)");
    }

    @Override
    public void updateNClob(String string, NClob nClob) throws SQLException {
        throw SQLExceptionFactory.notImplemented("updateNClob (String, NClob)");
    }

    @Override
    public NClob getNClob(int n2) throws SQLException {
        throw SQLExceptionFactory.notImplemented("getNClob (int)");
    }

    @Override
    public NClob getNClob(String string) throws SQLException {
        throw SQLExceptionFactory.notImplemented("getNClob (String)");
    }

    @Override
    public SQLXML getSQLXML(int n2) throws SQLException {
        throw SQLExceptionFactory.notImplemented("getSQLXML (int)");
    }

    @Override
    public SQLXML getSQLXML(String string) throws SQLException {
        throw SQLExceptionFactory.notImplemented("getSQLXML (String)");
    }

    @Override
    public void updateSQLXML(int n2, SQLXML sQLXML) throws SQLException {
        throw SQLExceptionFactory.notImplemented("updateSQLXML (int, SQLXML)");
    }

    @Override
    public void updateSQLXML(String string, SQLXML sQLXML) throws SQLException {
        throw SQLExceptionFactory.notImplemented("updateSQLXML (String, SQLXML)");
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        try {
            this.checkForClosedResultSet("isWrapperFor");
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
        return clazz.isInstance(this);
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        try {
            this.checkForClosedResultSet("unwrap");
            return clazz.cast(this);
        }
        catch (ClassCastException classCastException) {
            throw new SqlException(null, new ClientMessageId("XJ128.S"), clazz).getSQLException();
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public void updateNClob(int n2, Reader reader, long l2) throws SQLException {
        throw SQLExceptionFactory.notImplemented("updateNClob(int,Reader,long)");
    }

    public void updateNClob(String string, InputStream inputStream, long l2) throws SQLException {
        throw SQLExceptionFactory.notImplemented("updateNClob(String,InputStream,long)");
    }

    @Override
    public void updateNClob(String string, Reader reader, long l2) throws SQLException {
        throw SQLExceptionFactory.notImplemented("updateNClob(String,Reader,long)");
    }

    @Override
    public <T> T getObject(int n2, Class<T> clazz) throws SQLException {
        try {
            this.checkForClosedResultSet("getObject");
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "getObject", n2);
        }
        if (clazz == null) {
            throw this.mismatchException("NULL", n2);
        }
        Object object = String.class.equals(clazz) ? this.getString(n2) : (BigDecimal.class.equals(clazz) ? this.getBigDecimal(n2) : (Boolean.class.equals(clazz) ? Boolean.valueOf(this.getBoolean(n2)) : (Byte.class.equals(clazz) ? Byte.valueOf(this.getByte(n2)) : (Short.class.equals(clazz) ? Short.valueOf(this.getShort(n2)) : (Integer.class.equals(clazz) ? Integer.valueOf(this.getInt(n2)) : (Long.class.equals(clazz) ? Long.valueOf(this.getLong(n2)) : (Float.class.equals(clazz) ? Float.valueOf(this.getFloat(n2)) : (Double.class.equals(clazz) ? Double.valueOf(this.getDouble(n2)) : (Date.class.equals(clazz) ? this.getDate(n2) : (Time.class.equals(clazz) ? this.getTime(n2) : (Timestamp.class.equals(clazz) ? this.getTimestamp(n2) : (Blob.class.equals(clazz) ? this.getBlob(n2) : (Clob.class.equals(clazz) ? this.getClob(n2) : (clazz.isArray() && clazz.getComponentType().equals(Byte.TYPE) ? (Object)this.getBytes(n2) : this.getObject(n2)))))))))))))));
        if (this.wasNull()) {
            object = null;
        }
        if (object == null || clazz.isInstance(object)) {
            return clazz.cast(object);
        }
        throw this.mismatchException(clazz.getName(), n2);
    }

    private SQLException mismatchException(String string, int n2) throws SQLException {
        String string2 = this.getMetaData().getColumnTypeName(n2);
        ClientMessageId clientMessageId = new ClientMessageId("22005");
        SqlException sqlException = new SqlException(this.agent_.logWriter_, clientMessageId, string, string2);
        return sqlException.getSQLException();
    }

    @Override
    public <T> T getObject(String string, Class<T> clazz) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "getObject", string);
            }
            return this.getObject(this.findColumnX(string, "getObject"), clazz);
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }
}

