/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Hashtable;
import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.LogWriter;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.client.am.Utils;

public class ColumnMetaData
implements ResultSetMetaData {
    public int columns_;
    public boolean[] nullable_;
    public short sqldHold_;
    public short sqldReturn_;
    public short sqldScroll_;
    public short sqldSensitive_;
    public short sqldFcode_;
    public short sqldKeytype_;
    public String sqldRdbnam_;
    public String sqldSchema_;
    public int[] sqlPrecision_;
    public int[] sqlScale_;
    public long[] sqlLength_;
    public int[] sqlType_;
    public int[] sqlCcsid_;
    public String[] sqlName_;
    public String[] sqlLabel_;
    public short[] sqlUnnamed_;
    public String[] sqlComment_;
    public String[] sqlUDTname_;
    public String[] sqlUDTclassName_;
    public short[] sqlxKeymem_;
    public short[] sqlxGenerated_;
    public short[] sqlxParmmode_;
    public String[] sqlxCorname_;
    public String[] sqlxName_;
    public String[] sqlxBasename_;
    public int[] sqlxUpdatable_;
    public String[] sqlxSchema_;
    public String[] sqlxRdbnam_;
    public transient int[][] protocolTypesCache_ = null;
    public transient int[] types_;
    public transient int[] clientParamtertype_;
    private transient LogWriter logWriter_;
    transient int resultSetConcurrency_;
    private transient Hashtable<String, Integer> columnNameToIndexCache_;
    private transient boolean statementClosed_ = false;

    void markClosed() {
        this.statementClosed_ = true;
        this.nullDataForGC();
    }

    private void checkForClosedStatement() throws SqlException {
        if (this.statementClosed_) {
            throw new SqlException(this.logWriter_, new ClientMessageId("XCL31.S"), new Object[0]);
        }
    }

    public ColumnMetaData(LogWriter logWriter) {
        this.logWriter_ = logWriter;
    }

    public ColumnMetaData(LogWriter logWriter, int n2) {
        this.logWriter_ = logWriter;
        this.initializeCache(n2);
    }

    public void initializeCache(int n2) {
        this.columns_ = n2;
        this.nullable_ = new boolean[n2];
        this.types_ = new int[n2];
        this.clientParamtertype_ = new int[n2];
        this.sqlPrecision_ = new int[n2];
        this.sqlScale_ = new int[n2];
        this.sqlLength_ = new long[n2];
        this.sqlType_ = new int[n2];
        this.sqlCcsid_ = new int[n2];
        this.sqlName_ = new String[n2];
        this.sqlxParmmode_ = new short[n2];
        this.sqlUDTname_ = new String[n2];
        this.sqlUDTclassName_ = new String[n2];
    }

    @Override
    public int getColumnCount() throws SQLException {
        try {
            this.checkForClosedStatement();
            return this.columns_;
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public boolean isAutoIncrement(int n2) throws SQLException {
        try {
            this.checkForClosedStatement();
            this.checkForValidColumnIndex(n2);
            return this.sqlxGenerated_[n2 - 1] == 2;
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public boolean isCaseSensitive(int n2) throws SQLException {
        try {
            this.checkForClosedStatement();
            this.checkForValidColumnIndex(n2);
            int n3 = this.types_[n2 - 1];
            return n3 == 1 || n3 == 12 || n3 == -1 || n3 == 2005;
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public boolean isSearchable(int n2) throws SQLException {
        try {
            this.checkForClosedStatement();
            this.checkForValidColumnIndex(n2);
            return true;
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public boolean isCurrency(int n2) throws SQLException {
        try {
            this.checkForClosedStatement();
            this.checkForValidColumnIndex(n2);
            return false;
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public int isNullable(int n2) throws SQLException {
        try {
            this.checkForClosedStatement();
            this.checkForValidColumnIndex(n2);
            if (this.nullable_[n2 - 1]) {
                return 1;
            }
            return 0;
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public boolean isSigned(int n2) throws SQLException {
        try {
            this.checkForClosedStatement();
            this.checkForValidColumnIndex(n2);
            int n3 = this.types_[n2 - 1];
            return n3 == 5 || n3 == 4 || n3 == -5 || n3 == 6 || n3 == 7 || n3 == 8 || n3 == 2 || n3 == 3;
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public int getColumnDisplaySize(int n2) throws SQLException {
        try {
            this.checkForClosedStatement();
            this.checkForValidColumnIndex(n2);
            int n3 = this.types_[n2 - 1];
            switch (n3) {
                case 16: {
                    return 5;
                }
                case 4: {
                    return 11;
                }
                case 5: {
                    return 6;
                }
                case -5: {
                    return 20;
                }
                case 7: {
                    return 15;
                }
                case 6: 
                case 8: {
                    return 24;
                }
                case 2: 
                case 3: {
                    int n4 = this.getScale(n2);
                    int n5 = this.getPrecision(n2);
                    return n4 == 0 ? n5 + 1 : (n4 == n5 ? n5 + 3 : n5 + 2);
                }
                case -1: 
                case 1: 
                case 12: 
                case 2005: {
                    return (int)this.sqlLength_[n2 - 1];
                }
                case 91: {
                    return 10;
                }
                case 92: {
                    return 8;
                }
                case 93: {
                    return 29;
                }
                case 2000: {
                    return 15;
                }
                case -4: 
                case -3: 
                case -2: 
                case 2004: {
                    int n6 = (int)(2L * this.sqlLength_[n2 - 1]);
                    if (n6 < 0) {
                        n6 = Integer.MAX_VALUE;
                    }
                    return n6;
                }
            }
            throw new SqlException(this.logWriter_, new ClientMessageId("XJ021.S"), new Object[0]);
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public String getColumnLabel(int n2) throws SQLException {
        try {
            this.checkForClosedStatement();
            this.checkForValidColumnIndex(n2);
            if (this.sqlLabel_ != null && this.sqlLabel_[n2 - 1] != null) {
                return this.sqlLabel_[n2 - 1];
            }
            if (this.sqlName_ == null || this.sqlName_[n2 - 1] == null) {
                this.assignColumnName(n2);
            }
            return this.sqlName_[n2 - 1];
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public String getColumnName(int n2) throws SQLException {
        try {
            this.checkForClosedStatement();
            this.checkForValidColumnIndex(n2);
            if (this.sqlName_ == null || this.sqlName_[n2 - 1] == null) {
                this.assignColumnName(n2);
            }
            return this.sqlName_[n2 - 1];
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public String getSchemaName(int n2) throws SQLException {
        try {
            this.checkForClosedStatement();
            this.checkForValidColumnIndex(n2);
            if (this.sqlxSchema_ == null || this.sqlxSchema_[n2 - 1] == null) {
                return "";
            }
            return this.sqlxSchema_[n2 - 1];
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public int getPrecision(int n2) throws SQLException {
        try {
            this.checkForClosedStatement();
            this.checkForValidColumnIndex(n2);
            int n3 = this.types_[n2 - 1];
            switch (n3) {
                case 16: {
                    return 1;
                }
                case 2: 
                case 3: {
                    return this.sqlPrecision_[n2 - 1];
                }
                case 5: {
                    return 5;
                }
                case 4: {
                    return 10;
                }
                case -5: {
                    return 19;
                }
                case 6: {
                    return 15;
                }
                case 7: {
                    return 7;
                }
                case 8: {
                    return 15;
                }
                case -4: 
                case -3: 
                case -2: 
                case -1: 
                case 1: 
                case 12: 
                case 2004: 
                case 2005: {
                    return (int)this.sqlLength_[n2 - 1];
                }
                case 91: {
                    return 10;
                }
                case 92: {
                    return 8;
                }
                case 93: {
                    return 29;
                }
                case 2000: {
                    return 0;
                }
            }
            throw new SqlException(this.logWriter_, new ClientMessageId("XJ021.S"), new Object[0]);
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public int getScale(int n2) throws SQLException {
        try {
            this.checkForClosedStatement();
            this.checkForValidColumnIndex(n2);
            return this.sqlScale_[n2 - 1];
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public String getTableName(int n2) throws SQLException {
        try {
            this.checkForClosedStatement();
            this.checkForValidColumnIndex(n2);
            if (this.sqlxBasename_ == null || this.sqlxBasename_[n2 - 1] == null) {
                return "";
            }
            return this.sqlxBasename_[n2 - 1];
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public String getCatalogName(int n2) throws SQLException {
        try {
            this.checkForClosedStatement();
            this.checkForValidColumnIndex(n2);
            return "";
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public int getColumnType(int n2) throws SQLException {
        try {
            this.checkForClosedStatement();
            this.checkForValidColumnIndex(n2);
            return this.types_[n2 - 1];
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public String getColumnTypeName(int n2) throws SQLException {
        try {
            this.checkForClosedStatement();
            this.checkForValidColumnIndex(n2);
            int n3 = this.types_[n2 - 1];
            int n4 = this.sqlType_[n2 - 1];
            switch (n4) {
                case 2436: 
                case 2437: {
                    return "BOOLEAN";
                }
                case 384: 
                case 385: {
                    return "DATE";
                }
                case 388: 
                case 389: {
                    return "TIME";
                }
                case 392: 
                case 393: {
                    return "TIMESTAMP";
                }
                case 404: 
                case 405: {
                    return "BLOB";
                }
                case 408: 
                case 409: {
                    return "CLOB";
                }
                case 448: 
                case 449: {
                    if (n3 == -3) {
                        return "VARCHAR FOR BIT DATA";
                    }
                    return "VARCHAR";
                }
                case 452: 
                case 453: {
                    if (n3 == -2) {
                        return "CHAR FOR BIT DATA";
                    }
                    return "CHAR";
                }
                case 456: 
                case 457: {
                    if (n3 == -4) {
                        return "LONG VARCHAR FOR BIT DATA";
                    }
                    return "LONG VARCHAR";
                }
                case 460: 
                case 461: {
                    return "SBCS";
                }
                case 480: 
                case 481: {
                    if (n3 == 8) {
                        return "DOUBLE";
                    }
                    if (n3 == 7) {
                        return "REAL";
                    }
                }
                case 484: 
                case 485: {
                    return "DECIMAL";
                }
                case 492: 
                case 493: {
                    return "BIGINT";
                }
                case 496: 
                case 497: {
                    return "INTEGER";
                }
                case 500: 
                case 501: {
                    return "SMALLINT";
                }
                case 504: 
                case 505: {
                    return "NUMERIC";
                }
                case 2000: 
                case 2001: {
                    return this.sqlUDTname_[n2 - 1];
                }
            }
            throw new SqlException(this.logWriter_, new ClientMessageId("XJ021.S"), new Object[0]);
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public boolean isReadOnly(int n2) throws SQLException {
        try {
            this.checkForClosedStatement();
            this.checkForValidColumnIndex(n2);
            if (this.sqlxUpdatable_ == null) {
                return this.resultSetConcurrency_ == 1007;
            }
            return this.sqlxUpdatable_[n2 - 1] == 0;
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public boolean isWritable(int n2) throws SQLException {
        try {
            this.checkForClosedStatement();
            this.checkForValidColumnIndex(n2);
            if (this.sqlxUpdatable_ == null) {
                return this.resultSetConcurrency_ == 1008;
            }
            return this.sqlxUpdatable_[n2 - 1] == 1;
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public boolean isDefinitelyWritable(int n2) throws SQLException {
        try {
            this.checkForClosedStatement();
            this.checkForValidColumnIndex(n2);
            if (this.sqlxUpdatable_ == null) {
                return false;
            }
            return this.sqlxUpdatable_[n2 - 1] == 1;
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public String getColumnClassName(int n2) throws SQLException {
        try {
            this.checkForClosedStatement();
            this.checkForValidColumnIndex(n2);
            int n3 = this.types_[n2 - 1];
            switch (n3) {
                case 16: {
                    return "java.lang.Boolean";
                }
                case -7: {
                    return "java.lang.Boolean";
                }
                case -6: {
                    return "java.lang.Integer";
                }
                case 5: {
                    return "java.lang.Integer";
                }
                case 4: {
                    return "java.lang.Integer";
                }
                case -5: {
                    return "java.lang.Long";
                }
                case 6: {
                    return "java.lang.Double";
                }
                case 7: {
                    return "java.lang.Float";
                }
                case 8: {
                    return "java.lang.Double";
                }
                case 2: 
                case 3: {
                    return "java.math.BigDecimal";
                }
                case -1: 
                case 1: 
                case 12: {
                    return "java.lang.String";
                }
                case 91: {
                    return "java.sql.Date";
                }
                case 92: {
                    return "java.sql.Time";
                }
                case 93: {
                    return "java.sql.Timestamp";
                }
                case -4: 
                case -3: 
                case -2: {
                    return "byte[]";
                }
                case 2002: {
                    return "java.sql.Struct";
                }
                case 2003: {
                    return "java.sql.Array";
                }
                case 2004: {
                    return "java.sql.Blob";
                }
                case 2005: {
                    return "java.sql.Clob";
                }
                case 2006: {
                    return "java.sql.Ref";
                }
                case 2000: {
                    return this.sqlUDTclassName_[n2 - 1];
                }
            }
            throw new SqlException(this.logWriter_, new ClientMessageId("XJ021.S"), new Object[0]);
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    void checkForValidColumnIndex(int n2) throws SqlException {
        if (n2 < 1 || n2 > this.columns_) {
            throw new SqlException(this.logWriter_, new ClientMessageId("XCL14.S"), n2, this.columns_);
        }
    }

    public void setLogWriter(LogWriter logWriter) {
        this.logWriter_ = logWriter;
    }

    private void nullDataForGC() {
        this.columns_ = 0;
        this.nullable_ = null;
        this.types_ = null;
        this.sqldRdbnam_ = null;
        this.sqldSchema_ = null;
        this.sqlPrecision_ = null;
        this.sqlScale_ = null;
        this.sqlLength_ = null;
        this.sqlType_ = null;
        this.sqlCcsid_ = null;
        this.sqlName_ = null;
        this.sqlLabel_ = null;
        this.sqlUnnamed_ = null;
        this.sqlComment_ = null;
        this.sqlUDTname_ = null;
        this.sqlUDTclassName_ = null;
        this.sqlxKeymem_ = null;
        this.sqlxGenerated_ = null;
        this.sqlxParmmode_ = null;
        this.sqlxCorname_ = null;
        this.sqlxName_ = null;
        this.sqlxBasename_ = null;
        this.sqlxUpdatable_ = null;
        this.sqlxSchema_ = null;
        this.sqlxRdbnam_ = null;
        this.clientParamtertype_ = null;
        this.types_ = null;
    }

    boolean hasLobColumns() {
        for (int i2 = 0; i2 < this.columns_; ++i2) {
            switch (Utils.getNonNullableSqlType(this.sqlType_[i2])) {
                case 404: 
                case 408: {
                    return true;
                }
            }
        }
        return false;
    }

    int findColumnX(String string) throws SqlException {
        if (this.columnNameToIndexCache_ == null) {
            this.columnNameToIndexCache_ = new Hashtable();
        } else {
            Integer n2 = this.columnNameToIndexCache_.get(string);
            if (n2 != null) {
                return n2;
            }
        }
        for (int i2 = 0; i2 < this.columns_; ++i2) {
            if (this.sqlName_ == null || this.sqlName_[i2] == null || !this.sqlName_[i2].equalsIgnoreCase(string)) continue;
            this.columnNameToIndexCache_.put(string, i2 + 1);
            return i2 + 1;
        }
        throw new SqlException(this.logWriter_, new ClientMessageId("XIE08.S"), string);
    }

    private void assignColumnName(int n2) {
        if (this.columnNameToIndexCache_ == null) {
            this.columnNameToIndexCache_ = new Hashtable();
        }
        String string = Integer.toString(n2);
        this.columnNameToIndexCache_.put(string, n2);
        this.sqlName_[n2 - 1] = string;
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return clazz.isInstance(this);
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        try {
            return clazz.cast(this);
        }
        catch (ClassCastException classCastException) {
            throw new SqlException(null, new ClientMessageId("XJ128.S"), clazz).getSQLException();
        }
    }
}

