/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.derby.client.am.Agent;
import org.apache.derby.client.am.ByteArrayCombinerStream;
import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.client.am.UnitOfWorkListener;
import org.apache.derby.client.net.NetConnection;

public abstract class Lob
implements UnitOfWorkListener {
    static final int STRING = 2;
    static final int ASCII_STREAM = 4;
    static final int UNICODE_STREAM = 8;
    static final int CHARACTER_STREAM = 16;
    static final int BINARY_STREAM = 32;
    static final int BINARY_STRING = 64;
    static final int LOCATOR = 128;
    public static final int INVALID_LOCATOR = -1;
    protected Agent agent_;
    protected int dataType_ = 0;
    protected int locator_ = -1;
    private long sqlLength_;
    private boolean lengthObtained_;
    protected boolean isValid_ = true;
    private final boolean willBeLayerBStreamed_;
    private long updateCount;
    private int transactionID_;
    private static final ClientMessageId LOB_OBJECT_LENGTH_UNKNOWN_YET = new ClientMessageId("XJ216.S");

    protected Lob(Agent agent, boolean bl) {
        this.agent_ = agent;
        this.lengthObtained_ = false;
        this.willBeLayerBStreamed_ = bl;
        this.transactionID_ = this.agent_.connection_.getTransactionID();
    }

    long sqlLength() throws SqlException {
        if (this.lengthObtained_) {
            return this.sqlLength_;
        }
        if (this.isLocator()) {
            this.sqlLength_ = this.getLocatorLength();
            this.lengthObtained_ = true;
        } else {
            if (this.willBeLayerBStreamed()) {
                throw new SqlException(this.agent_.logWriter_, LOB_OBJECT_LENGTH_UNKNOWN_YET, new Object[0]);
            }
            this.materializeStream();
        }
        return this.sqlLength_;
    }

    void setSqlLength(long l2) {
        this.sqlLength_ = l2;
        this.lengthObtained_ = true;
    }

    long getLocatorLength() throws SqlException {
        return -1L;
    }

    @Override
    public void listenToUnitOfWork() {
        this.agent_.connection_.CommitAndRollbackListeners_.put(this, null);
    }

    @Override
    public void completeLocalCommit(Iterator iterator) {
        iterator.remove();
    }

    @Override
    public void completeLocalRollback(Iterator iterator) {
        iterator.remove();
    }

    public Agent getAgent() {
        return this.agent_;
    }

    void checkForClosedConnection() throws SqlException {
        if (this.agent_.connection_.isClosedX()) {
            this.agent_.checkForDeferredExceptions();
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("08003.C.2"), new Object[0]);
        }
        this.agent_.checkForDeferredExceptions();
    }

    protected abstract void materializeStream() throws SqlException;

    protected InputStream materializeStream(InputStream inputStream, String string) throws SqlException {
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        byte[] byArray = new byte[32768];
        int n2 = 0;
        int n3 = 0;
        try {
            do {
                if ((n3 = inputStream.read(byArray, 0, byArray.length)) == byArray.length) {
                    arrayList.add(byArray);
                    int n4 = n2 + 32768;
                    byArray = n4 < 0 || n4 == Integer.MAX_VALUE ? new byte[Integer.MAX_VALUE - n2] : new byte[32768];
                }
                if (n3 <= 0) continue;
                n2 += n3;
            } while (n3 == 32768);
            if (inputStream.read() != -1) {
                throw new SqlException(null, new ClientMessageId("22003"), string);
            }
            if (n3 > 0) {
                arrayList.add(byArray);
            }
            byArray = null;
            this.sqlLength_ = n2;
            this.lengthObtained_ = true;
            return new ByteArrayCombinerStream(arrayList, n2);
        }
        catch (IOException iOException) {
            throw new SqlException(null, new ClientMessageId("XCL30.S"), iOException, string);
        }
    }

    public abstract long length() throws SQLException;

    protected static boolean isLayerBStreamingPossible(Agent agent) {
        NetConnection netConnection = (NetConnection)agent.connection_;
        int n2 = netConnection.getSecurityMechanism();
        return netConnection.serverSupportsLayerBStreaming() && n2 != 12 && n2 != 13;
    }

    public boolean willBeLayerBStreamed() {
        return this.willBeLayerBStreamed_;
    }

    public boolean isLocator() {
        return (this.dataType_ & 0x80) == 128;
    }

    public int getLocator() {
        return this.locator_;
    }

    protected void checkPosAndLength(long l2, long l3) throws SQLException {
        if (l2 <= 0L) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ070.S"), l2).getSQLException();
        }
        if (l3 < 0L) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ071.S"), l3).getSQLException();
        }
        if (l3 > this.length() - (l2 - 1L)) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ087.S"), l2, l3).getSQLException();
        }
    }

    protected synchronized void incrementUpdateCount() {
        ++this.updateCount;
    }

    long getUpdateCount() {
        return this.updateCount;
    }

    void checkForLocatorValidity() throws SqlException {
        this.sqlLength();
    }

    protected void checkValidity() throws SQLException {
        try {
            this.agent_.connection_.checkForClosedConnection();
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
        if (!this.isValid_ || this.isLocator() && this.transactionID_ != this.agent_.connection_.getTransactionID()) {
            throw new SqlException(null, new ClientMessageId("XJ215.S"), new Object[0]).getSQLException();
        }
    }
}

