/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.ClientPreparedStatement;
import org.apache.derby.client.am.ClientStatement;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.client.am.StatementCacheInteractor;
import org.apache.derby.client.am.stmtcache.JDBCStatementCache;
import org.apache.derby.client.am.stmtcache.StatementKey;

abstract class LogicalStatementEntity
implements Statement {
    private final boolean hasCallableStmt;
    private PreparedStatement physicalPs;
    private CallableStatement physicalCs;
    private StatementCacheInteractor owner;
    private final StatementKey stmtKey;
    private final JDBCStatementCache cache;

    protected LogicalStatementEntity(PreparedStatement preparedStatement, StatementKey statementKey, StatementCacheInteractor statementCacheInteractor) {
        if (statementCacheInteractor.getCache() == null) {
            throw new IllegalArgumentException("statement cache reference cannot be <null>");
        }
        this.stmtKey = statementKey;
        this.cache = statementCacheInteractor.getCache();
        this.owner = statementCacheInteractor;
        this.physicalPs = preparedStatement;
        if (preparedStatement instanceof CallableStatement) {
            this.hasCallableStmt = true;
            this.physicalCs = (CallableStatement)preparedStatement;
        } else {
            this.hasCallableStmt = false;
            this.physicalCs = null;
        }
        ((ClientPreparedStatement)preparedStatement).setOwner(this);
    }

    synchronized PreparedStatement getPhysPs() throws SQLException {
        if (this.physicalPs == null) {
            throw new SqlException(null, new ClientMessageId("XJ012.S"), "PreparedStatement").getSQLException();
        }
        return this.physicalPs;
    }

    synchronized CallableStatement getPhysCs() throws SQLException {
        if (this.physicalCs == null) {
            throw new SqlException(null, new ClientMessageId("XJ012.S"), "CallableStatement").getSQLException();
        }
        return this.physicalCs;
    }

    private synchronized Statement getPhysStmt() throws SQLException {
        if (this.hasCallableStmt) {
            return this.getPhysCs();
        }
        return this.getPhysPs();
    }

    @Override
    public synchronized void close() throws SQLException {
        if (this.physicalPs != null) {
            ClientPreparedStatement clientPreparedStatement = (ClientPreparedStatement)this.physicalPs;
            this.physicalPs = null;
            this.physicalCs = null;
            this.owner.markClosed(this);
            this.owner = null;
            clientPreparedStatement.setOwner(null);
            if (!clientPreparedStatement.openOnClient_) {
                return;
            }
            if (!clientPreparedStatement.isPoolable) {
                clientPreparedStatement.close();
                return;
            }
            try {
                clientPreparedStatement.resetForReuse();
            }
            catch (SqlException sqlException) {
                throw sqlException.getSQLException();
            }
            if (!this.cache.cacheStatement(this.stmtKey, clientPreparedStatement)) {
                clientPreparedStatement.close();
            }
        }
    }

    synchronized boolean isLogicalEntityClosed() {
        return this.physicalPs == null;
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        this.getPhysStmt();
        return clazz.isInstance(this);
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        if (((ClientStatement)this.getPhysStmt()).isClosed()) {
            throw new SqlException(null, new ClientMessageId("XJ012.S"), this.hasCallableStmt ? "CallableStatement" : "PreparedStatement").getSQLException();
        }
        try {
            return clazz.cast(this);
        }
        catch (ClassCastException classCastException) {
            throw new SqlException(null, new ClientMessageId("XJ128.S"), clazz).getSQLException();
        }
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        ((ClientStatement)this.getPhysStmt()).closeOnCompletion();
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return ((ClientStatement)this.getPhysStmt()).isCloseOnCompletion();
    }

    @Override
    public long[] executeLargeBatch() throws SQLException {
        return ((ClientStatement)this.getPhysStmt()).executeLargeBatch();
    }

    @Override
    public long executeLargeUpdate(String string) throws SQLException {
        return ((ClientStatement)this.getPhysStmt()).executeLargeUpdate(string);
    }

    @Override
    public long executeLargeUpdate(String string, int n2) throws SQLException {
        return ((ClientStatement)this.getPhysStmt()).executeLargeUpdate(string, n2);
    }

    @Override
    public long executeLargeUpdate(String string, int[] nArray) throws SQLException {
        return ((ClientStatement)this.getPhysStmt()).executeLargeUpdate(string, nArray);
    }

    @Override
    public long executeLargeUpdate(String string, String[] stringArray) throws SQLException {
        return ((ClientStatement)this.getPhysStmt()).executeLargeUpdate(string, stringArray);
    }

    @Override
    public long getLargeUpdateCount() throws SQLException {
        return ((ClientStatement)this.getPhysStmt()).getLargeUpdateCount();
    }

    @Override
    public long getLargeMaxRows() throws SQLException {
        return ((ClientStatement)this.getPhysStmt()).getLargeMaxRows();
    }

    @Override
    public void setLargeMaxRows(long l2) throws SQLException {
        ((ClientStatement)this.getPhysStmt()).setLargeMaxRows(l2);
    }
}

