/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.derby.client.am.ClientConnection;
import org.apache.derby.client.am.Lob;
import org.apache.derby.client.am.SqlException;

abstract class UpdateSensitiveLOBLocatorInputStream
extends InputStream {
    private BufferedInputStream is = null;
    protected ClientConnection con = null;
    private Lob lob = null;
    private long updateCount;
    protected long currentPos;
    protected long length;

    protected UpdateSensitiveLOBLocatorInputStream(ClientConnection clientConnection, Lob lob, InputStream inputStream) throws SqlException {
        lob.checkForLocatorValidity();
        this.is = new BufferedInputStream(inputStream);
        this.currentPos = 1L;
        this.con = clientConnection;
        this.lob = lob;
        this.updateCount = lob.getUpdateCount();
        this.length = -1L;
    }

    protected UpdateSensitiveLOBLocatorInputStream(ClientConnection clientConnection, Lob lob, InputStream inputStream, long l2, long l3) throws SqlException {
        this(clientConnection, lob, inputStream);
        this.currentPos = l2;
        this.length = l3;
    }

    @Override
    public int read() throws IOException {
        this.identifyAndReplaceObseleteStream();
        int n2 = this.is.read();
        if (n2 == -1) {
            return n2;
        }
        ++this.currentPos;
        return n2;
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        this.identifyAndReplaceObseleteStream();
        int n4 = this.is.read(byArray, n2, n3);
        if (n4 == -1) {
            return n4;
        }
        this.currentPos += (long)n4;
        return n4;
    }

    @Override
    public void close() throws IOException {
        if (this.is != null) {
            this.is.close();
        }
    }

    private void identifyAndReplaceObseleteStream() throws IOException {
        long l2 = this.lob.getUpdateCount();
        if (this.updateCount != l2) {
            try {
                this.is = new BufferedInputStream(this.reCreateStream());
            }
            catch (SqlException sqlException) {
                IOException iOException = new IOException();
                iOException.initCause(sqlException);
                throw iOException;
            }
            this.updateCount = l2;
        }
    }

    protected abstract InputStream reCreateStream() throws SqlException;
}

