/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import org.apache.derby.client.am.Agent;
import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.ClientStatement;
import org.apache.derby.client.am.DisconnectException;
import org.apache.derby.client.am.LogWriter;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.client.am.Utils;
import org.apache.derby.client.net.CcsidManager;
import org.apache.derby.client.net.CodePoint;
import org.apache.derby.client.net.ConnectionReply;
import org.apache.derby.client.net.ConnectionRequestInterface;
import org.apache.derby.client.net.EbcdicCcsidManager;
import org.apache.derby.client.net.NetConnection;
import org.apache.derby.client.net.NetConnectionReply;
import org.apache.derby.client.net.NetConnectionRequest;
import org.apache.derby.client.net.NetPackageReply;
import org.apache.derby.client.net.NetPackageRequest;
import org.apache.derby.client.net.NetResultSetReply;
import org.apache.derby.client.net.NetResultSetRequest;
import org.apache.derby.client.net.NetStatementReply;
import org.apache.derby.client.net.NetStatementRequest;
import org.apache.derby.client.net.NetXAConnectionReply;
import org.apache.derby.client.net.NetXAConnectionRequest;
import org.apache.derby.client.net.OpenSocketAction;
import org.apache.derby.client.net.Reply;
import org.apache.derby.client.net.Request;
import org.apache.derby.client.net.ResultSetReply;
import org.apache.derby.client.net.ResultSetRequestInterface;
import org.apache.derby.client.net.StatementReply;
import org.apache.derby.client.net.StatementRequestInterface;
import org.apache.derby.client.net.Typdef;
import org.apache.derby.client.net.Utf8CcsidManager;

public class NetAgent
extends Agent {
    ConnectionRequestInterface connectionRequest_;
    StatementRequestInterface statementRequest_;
    ResultSetRequestInterface resultSetRequest_;
    ConnectionReply connectionReply_;
    private ConnectionReply packageReply_;
    StatementReply statementReply_;
    ResultSetReply resultSetReply_;
    NetConnection netConnection_;
    private Request request_;
    NetConnectionRequest netConnectionRequest_;
    private NetPackageRequest netPackageRequest_;
    private NetStatementRequest netStatementRequest_;
    private NetResultSetRequest netResultSetRequest_;
    private Reply reply_;
    NetConnectionReply netConnectionReply_;
    private NetPackageReply netPackageReply_;
    private NetStatementReply netStatementReply_;
    private NetResultSetReply netResultSetReply_;
    Socket socket_;
    private InputStream rawSocketInputStream_;
    private OutputStream rawSocketOutputStream_;
    String server_;
    int port_;
    private int clientSSLMode_;
    private EbcdicCcsidManager ebcdicCcsidManager_;
    private Utf8CcsidManager utf8CcsidManager_;
    private CcsidManager currentCcsidManager_;
    Typdef typdef_;
    Typdef targetTypdef_;
    Typdef originalTargetTypdef_;
    private int svrcod_;
    int orignalTargetSqlam_;
    int targetSqlam_;
    SqlException exceptionOpeningSocket_;
    SqlException exceptionConvertingRdbnam;
    private boolean writeChainIsDirty_;

    public NetAgent(NetConnection netConnection, LogWriter logWriter) throws SqlException {
        super(netConnection, logWriter);
        this.targetSqlam_ = this.orignalTargetSqlam_ = 7;
        this.exceptionOpeningSocket_ = null;
        this.exceptionConvertingRdbnam = null;
        this.writeChainIsDirty_ = false;
        this.netConnection_ = netConnection;
    }

    NetAgent(NetConnection netConnection, LogWriter logWriter, int n2, String string, int n3, int n4) throws SqlException {
        super(netConnection, logWriter);
        this.targetSqlam_ = this.orignalTargetSqlam_ = 7;
        this.exceptionOpeningSocket_ = null;
        this.exceptionConvertingRdbnam = null;
        this.writeChainIsDirty_ = false;
        this.server_ = string;
        this.port_ = n3;
        this.netConnection_ = netConnection;
        this.clientSSLMode_ = n4;
        if (this.server_ == null) {
            throw new DisconnectException((Agent)this, new ClientMessageId("08001.C.1"), "serverName");
        }
        try {
            this.socket_ = AccessController.doPrivileged(new OpenSocketAction(string, n3, this.clientSSLMode_));
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw new DisconnectException((Agent)this, new ClientMessageId("08001.C.2"), (Throwable)privilegedActionException.getException(), privilegedActionException.getException().getClass().getName(), string, n3, privilegedActionException.getException().getMessage());
        }
        try {
            if (this.exceptionOpeningSocket_ == null) {
                this.socket_.setTcpNoDelay(true);
                this.socket_.setKeepAlive(true);
                this.socket_.setSoTimeout(n2 * 1000);
            }
        }
        catch (SocketException socketException) {
            try {
                this.socket_.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.exceptionOpeningSocket_ = new DisconnectException((Agent)this, new ClientMessageId("08001.C.3"), (Throwable)socketException, socketException.getMessage());
        }
        try {
            if (this.exceptionOpeningSocket_ == null) {
                this.rawSocketOutputStream_ = this.socket_.getOutputStream();
                this.rawSocketInputStream_ = this.socket_.getInputStream();
            }
        }
        catch (IOException iOException) {
            try {
                this.socket_.close();
            }
            catch (IOException iOException2) {
                // empty catch block
            }
            this.exceptionOpeningSocket_ = new DisconnectException((Agent)this, new ClientMessageId("08001.C.4"), (Throwable)iOException, iOException.getMessage());
        }
        this.ebcdicCcsidManager_ = new EbcdicCcsidManager();
        this.utf8CcsidManager_ = new Utf8CcsidManager();
        this.currentCcsidManager_ = this.ebcdicCcsidManager_;
        if (this.netConnection_.isXAConnection()) {
            NetXAConnectionReply netXAConnectionReply = new NetXAConnectionReply(this, this.netConnection_.commBufferSize_);
            this.netResultSetReply_ = netXAConnectionReply;
            this.netStatementReply_ = this.netResultSetReply_;
            this.netPackageReply_ = this.netStatementReply_;
            this.netConnectionReply_ = this.netPackageReply_;
            this.reply_ = this.netConnectionReply_;
            this.resultSetReply_ = new ResultSetReply(this, this.netResultSetReply_, this.netStatementReply_, this.netConnectionReply_);
            this.statementReply_ = this.resultSetReply_;
            this.connectionReply_ = this.packageReply_ = this.statementReply_;
            NetXAConnectionRequest netXAConnectionRequest = new NetXAConnectionRequest(this, this.netConnection_.commBufferSize_);
            this.netResultSetRequest_ = netXAConnectionRequest;
            this.netStatementRequest_ = this.netResultSetRequest_;
            this.netPackageRequest_ = this.netStatementRequest_;
            this.netConnectionRequest_ = this.netPackageRequest_;
            this.request_ = this.netConnectionRequest_;
            this.resultSetRequest_ = this.netResultSetRequest_;
            this.statementRequest_ = this.netStatementRequest_;
            this.connectionRequest_ = this.netConnectionRequest_;
        } else {
            this.netResultSetReply_ = new NetResultSetReply(this, this.netConnection_.commBufferSize_);
            this.netStatementReply_ = this.netResultSetReply_;
            this.netPackageReply_ = this.netStatementReply_;
            this.netConnectionReply_ = this.netPackageReply_;
            this.reply_ = this.netConnectionReply_;
            this.resultSetReply_ = new ResultSetReply(this, this.netResultSetReply_, this.netStatementReply_, this.netConnectionReply_);
            this.statementReply_ = this.resultSetReply_;
            this.connectionReply_ = this.packageReply_ = this.statementReply_;
            this.netResultSetRequest_ = new NetResultSetRequest(this, this.netConnection_.commBufferSize_);
            this.netStatementRequest_ = this.netResultSetRequest_;
            this.netPackageRequest_ = this.netStatementRequest_;
            this.netConnectionRequest_ = this.netPackageRequest_;
            this.request_ = this.netConnectionRequest_;
            this.resultSetRequest_ = this.netResultSetRequest_;
            this.statementRequest_ = this.netStatementRequest_;
            this.connectionRequest_ = this.netConnectionRequest_;
        }
    }

    @Override
    protected void resetAgent_(LogWriter logWriter, int n2, String string, int n3) throws SqlException {
        this.exceptionConvertingRdbnam = null;
        this.targetTypdef_ = this.originalTargetTypdef_;
        this.svrcod_ = 0;
        try {
            this.socket_.setSoTimeout(n2 * 1000);
        }
        catch (SocketException socketException) {
            try {
                this.socket_.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new SqlException(this.logWriter_, new ClientMessageId("08006.C.2"), socketException, socketException.getMessage());
        }
    }

    void setSvrcod(int n2) {
        if (n2 > this.svrcod_) {
            this.svrcod_ = n2;
        }
    }

    void clearSvrcod() {
        this.svrcod_ = CodePoint.SVRCOD_INFO;
    }

    private int getSvrcod() {
        return this.svrcod_;
    }

    @Override
    public void flush_() throws DisconnectException {
        this.sendRequest();
        this.reply_.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close_() throws SqlException {
        SqlException sqlException;
        SqlException sqlException2 = null;
        if (this.rawSocketInputStream_ != null) {
            try {
                this.rawSocketInputStream_.close();
            }
            catch (IOException iOException) {
                sqlException2 = new SqlException(this.logWriter_, new ClientMessageId("08006.C.3"), iOException, iOException.getMessage());
            }
            finally {
                this.rawSocketInputStream_ = null;
            }
        }
        if (this.rawSocketOutputStream_ != null) {
            try {
                this.rawSocketOutputStream_.close();
            }
            catch (IOException iOException) {
                sqlException = new SqlException(this.logWriter_, new ClientMessageId("08006.C.3"), iOException, iOException.getMessage());
                sqlException2 = Utils.accumulateSQLException(sqlException, sqlException2);
            }
            finally {
                this.rawSocketOutputStream_ = null;
            }
        }
        if (this.socket_ != null) {
            try {
                this.socket_.close();
            }
            catch (IOException iOException) {
                sqlException = new SqlException(this.logWriter_, new ClientMessageId("08006.C.3"), iOException, iOException.getMessage());
                sqlException2 = Utils.accumulateSQLException(sqlException, sqlException2);
            }
            finally {
                this.socket_ = null;
            }
        }
        if (sqlException2 != null) {
            throw sqlException2;
        }
    }

    protected void setTimeout(int n2) {
        try {
            this.socket_.setSoTimeout(n2 * 1000);
        }
        catch (SocketException socketException) {
            // empty catch block
        }
    }

    protected int getTimeout() {
        int n2 = 0;
        try {
            n2 = this.socket_.getSoTimeout();
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        return n2 /= 1000;
    }

    private void sendRequest() throws DisconnectException {
        try {
            this.request_.flush(this.rawSocketOutputStream_);
        }
        catch (IOException iOException) {
            this.throwCommunicationsFailure(iOException);
        }
    }

    public InputStream getInputStream() {
        return this.rawSocketInputStream_;
    }

    public CcsidManager getCurrentCcsidManager() {
        return this.currentCcsidManager_;
    }

    public OutputStream getOutputStream() {
        return this.rawSocketOutputStream_;
    }

    void setInputStream(InputStream inputStream) {
        this.rawSocketInputStream_ = inputStream;
    }

    void setOutputStream(OutputStream outputStream) {
        this.rawSocketOutputStream_ = outputStream;
    }

    void throwCommunicationsFailure(Throwable throwable) throws DisconnectException {
        this.accumulateChainBreakingReadExceptionAndThrow(new DisconnectException((Agent)this, new ClientMessageId("08006.C.3"), throwable, throwable.getMessage()));
    }

    @Override
    protected void markChainBreakingException_() {
        this.setSvrcod(CodePoint.SVRCOD_ERROR);
    }

    @Override
    public void checkForChainBreakingException_() throws SqlException {
        int n2 = this.getSvrcod();
        this.clearSvrcod();
        if (n2 > CodePoint.SVRCOD_WARNING) {
            super.checkForExceptions();
        }
    }

    private void writeDeferredResetConnection() throws SqlException {
        if (!this.netConnection_.resetConnectionAtFirstSql_) {
            return;
        }
        try {
            this.netConnection_.writeDeferredReset();
        }
        catch (SqlException sqlException) {
            DisconnectException disconnectException = new DisconnectException((Agent)this, new ClientMessageId("08006.C.4"), new Object[0]);
            disconnectException.setNextException(sqlException);
            throw disconnectException;
        }
    }

    void markWriteChainAsDirty() {
        this.writeChainIsDirty_ = true;
    }

    private void verifyWriteChainIsClean() throws DisconnectException {
        if (this.writeChainIsDirty_) {
            throw new DisconnectException((Agent)this, new ClientMessageId("XN022.C"), new Object[0]);
        }
    }

    @Override
    public void beginWriteChainOutsideUOW() throws SqlException {
        this.verifyWriteChainIsClean();
        this.request_.initialize();
        this.writeDeferredResetConnection();
    }

    @Override
    public void beginWriteChain(ClientStatement clientStatement) throws SqlException {
        this.verifyWriteChainIsClean();
        this.request_.initialize();
        this.writeDeferredResetConnection();
        super.beginWriteChain(clientStatement);
    }

    @Override
    protected void endWriteChain() {
    }

    private void readDeferredResetConnection() throws SqlException {
        if (!this.netConnection_.resetConnectionAtFirstSql_) {
            return;
        }
        try {
            this.netConnection_.readDeferredReset();
            this.checkForExceptions();
        }
        catch (SqlException sqlException) {
            DisconnectException disconnectException = new DisconnectException((Agent)this, new ClientMessageId("08006.C.4"), new Object[0]);
            disconnectException.setNextException(sqlException);
            throw disconnectException;
        }
    }

    @Override
    protected void beginReadChain(ClientStatement clientStatement) throws SqlException {
        this.writeChainIsDirty_ = false;
        this.readDeferredResetConnection();
        super.beginReadChain(clientStatement);
    }

    @Override
    protected void beginReadChainOutsideUOW() throws SqlException {
        this.writeChainIsDirty_ = false;
        this.readDeferredResetConnection();
        super.beginReadChainOutsideUOW();
    }

    void switchToUtf8CcsidMgr() {
        this.currentCcsidManager_ = this.utf8CcsidManager_;
    }

    void switchToEbcdicMgr() {
        this.currentCcsidManager_ = this.ebcdicCcsidManager_;
    }
}

