/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.net;

import org.apache.derby.client.am.ClientResultSet;
import org.apache.derby.client.am.Cursor;
import org.apache.derby.client.am.DisconnectException;
import org.apache.derby.client.am.Section;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.client.net.NetAgent;
import org.apache.derby.client.net.NetConnection;
import org.apache.derby.client.net.NetCursor;
import org.apache.derby.client.net.NetStatement;

class NetResultSet
extends ClientResultSet {
    private final NetConnection netConnection_;
    private final NetStatement netStatement_;
    final NetCursor netCursor_;
    private final NetAgent netAgent_;
    private boolean isFixedRowProtocol = false;
    boolean firstOutovrBuilt_ = false;

    NetResultSet(NetAgent netAgent, NetStatement netStatement, Cursor cursor, int n2, int n3, int n4, int n5, int n6, long l2, int n7, int n8, int n9) {
        super(netAgent, netStatement.statement_, cursor, n7, n8, n9);
        this.netAgent_ = netAgent;
        this.netCursor_ = (NetCursor)this.cursor_;
        this.netStatement_ = netStatement;
        this.netConnection_ = netStatement.netConnection_;
        this.netCursor_.netResultSet_ = this;
        boolean bl = this.cursorHold_ = n3 != 240;
        if (n4 == 241) {
            this.scrollable_ = true;
        }
        if (n2 == 9240) {
            this.isFixedRowProtocol = true;
            this.fetchSize_ = 1;
        } else {
            this.fetchSize_ = this.suggestedFetchSize_;
        }
        switch (n5) {
            case 0: {
                this.sensitivity_ = 0;
                break;
            }
            case 1: {
                this.sensitivity_ = 1;
                break;
            }
            case 2: {
                this.sensitivity_ = 2;
                break;
            }
        }
        if (n6 == 241) {
            this.isRowsetCursor_ = true;
        }
        this.queryInstanceIdentifier_ = l2;
    }

    @Override
    protected void parseRowset_() throws SqlException {
        int n2 = 0;
        while (this.netCursor_.calculateColumnOffsetsForRow_(n2, true)) {
            ++this.rowsReceivedInCurrentRowset_;
            ++n2;
        }
        while (this.rowsReceivedInCurrentRowset_ != this.fetchSize_ && !this.netCursor_.allRowsReceivedFromServer() && !this.isRowsetCursor_ && this.sensitivity_ != 3 && this.sensitivity_ != 2) {
            this.flowFetchToCompleteRowset();
            while (this.netCursor_.calculateColumnOffsetsForRow_(n2, true)) {
                ++this.rowsReceivedInCurrentRowset_;
                ++n2;
            }
        }
        this.checkAndThrowReceivedQueryTerminatingException();
    }

    @Override
    public void setFetchSize_(int n2) {
        int n3 = this.suggestedFetchSize_ = n2 == 0 ? 64 : n2;
        if (!this.isFixedRowProtocol) {
            this.fetchSize_ = this.suggestedFetchSize_;
        }
    }

    void flowFetchToCompleteRowset() throws DisconnectException {
        try {
            this.agent_.beginWriteChain(this.statement_);
            this.writeScrollableFetch_(this.generatedSection_ == null ? this.statement_.getSection() : this.generatedSection_, this.fetchSize_ - this.rowsReceivedInCurrentRowset_, 1, 1L, false);
            this.agent_.flow(this.statement_);
            this.readScrollableFetch_();
            this.agent_.endReadChain();
        }
        catch (SqlException sqlException) {
            throw new DisconnectException(this.agent_, sqlException);
        }
    }

    @Override
    public void writeFetch_(Section section) throws SqlException {
        if (this.resultSetType_ == 1003 && this.fetchSize_ != 0 && this.rowsYetToBeReceivedForRowset_ > 0) {
            this.netAgent_.resultSetRequest_.writeFetch(this, section, this.rowsYetToBeReceivedForRowset_);
        } else {
            this.netAgent_.resultSetRequest_.writeFetch(this, section, this.fetchSize_);
        }
    }

    @Override
    public void readFetch_() throws SqlException {
        this.netAgent_.resultSetReply_.readFetch(this);
    }

    @Override
    public void writeScrollableFetch_(Section section, int n2, int n3, long l2, boolean bl) throws SqlException {
        this.netAgent_.resultSetRequest_.writeScrollableFetch(this, section, n2, n3, l2, bl);
    }

    @Override
    public void readScrollableFetch_() throws SqlException {
        this.netAgent_.resultSetReply_.readScrollableFetch(this);
    }

    @Override
    public void writePositioningFetch_(Section section, int n2, long l2) throws SqlException {
        this.netAgent_.resultSetRequest_.writePositioningFetch(this, section, n2, l2);
    }

    @Override
    public void readPositioningFetch_() throws SqlException {
        this.netAgent_.resultSetReply_.readPositioningFetch(this);
    }

    @Override
    public void writeCursorClose_(Section section) throws SqlException {
        this.netAgent_.resultSetRequest_.writeCursorClose(this, section);
    }

    @Override
    public void readCursorClose_() throws SqlException {
        this.netAgent_.resultSetReply_.readCursorClose(this);
    }

    @Override
    protected void preClose_() throws SqlException {
        if (this.netCursor_.getQryclsimpEnabled()) {
            this.netCursor_.scanDataBufferForEndOfData();
        }
    }

    void flowFetch() throws DisconnectException, SqlException {
        this.agent_.beginWriteChain(this.statement_);
        this.writeFetch_(this.generatedSection_ == null ? this.statement_.getSection() : this.generatedSection_);
        this.agent_.flow(this.statement_);
        this.readFetch_();
        this.agent_.endReadChain();
    }
}

