/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.net;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import org.apache.derby.client.am.Agent;
import org.apache.derby.client.am.ClientBlob;
import org.apache.derby.client.am.ClientClob;
import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.ClientResultSet;
import org.apache.derby.client.am.ColumnMetaData;
import org.apache.derby.client.am.DateTime;
import org.apache.derby.client.am.DateTimeValue;
import org.apache.derby.client.am.Lob;
import org.apache.derby.client.am.Section;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.client.am.Utils;
import org.apache.derby.client.net.FdocaConstants;
import org.apache.derby.client.net.NetAgent;
import org.apache.derby.client.net.NetPackageRequest;
import org.apache.derby.client.net.NetPreparedStatement;
import org.apache.derby.client.net.NetStatement;
import org.apache.derby.client.net.StatementRequestInterface;
import org.apache.derby.client.net.Typdef;

class NetStatementRequest
extends NetPackageRequest
implements StatementRequestInterface {
    private ArrayList<Integer> extdtaPositions_ = null;
    private final HashMap<Integer, Object> promototedParameters_ = new HashMap();

    NetStatementRequest(NetAgent netAgent, int n2) {
        super(netAgent, n2);
    }

    @Override
    public void writeExecuteImmediate(NetStatement netStatement, String string, Section section) throws SqlException {
        this.buildEXCSQLIMM(section, false, 0L);
        this.buildSQLSTTcommandData(string);
    }

    @Override
    public void writePrepareDescribeOutput(NetStatement netStatement, String string, Section section) throws SqlException {
        this.buildPRPSQLSTT(section, string, true, true, 4);
        if (netStatement.statement_.cursorAttributesToSendOnPrepare_ != null) {
            this.buildSQLATTRcommandData(netStatement.statement_.cursorAttributesToSendOnPrepare_);
        }
        this.buildSQLSTTcommandData(string);
    }

    @Override
    public void writePrepare(NetStatement netStatement, String string, Section section) throws SqlException {
        this.buildPRPSQLSTT(section, string, false, false, 0);
        if (netStatement.statement_.cursorAttributesToSendOnPrepare_ != null) {
            this.buildSQLATTRcommandData(netStatement.statement_.cursorAttributesToSendOnPrepare_);
        }
        this.buildSQLSTTcommandData(string);
    }

    @Override
    public void writeExecute(NetPreparedStatement netPreparedStatement, Section section, ColumnMetaData columnMetaData, Object[] objectArray, int n2, boolean bl, boolean bl2) throws SqlException {
        this.buildEXCSQLSTT(section, true, bl, false, null, false, false, 0, false, 0, false, 0, false, 0);
        if (n2 > 0) {
            if (this.extdtaPositions_ != null && !this.extdtaPositions_.isEmpty()) {
                this.extdtaPositions_.clear();
            }
            boolean bl3 = this.buildSQLDTAcommandData(n2, columnMetaData, objectArray);
            this.buildEXTDTA(columnMetaData, objectArray, bl2);
        }
    }

    @Override
    public void writeOpenQuery(NetPreparedStatement netPreparedStatement, Section section, int n2, int n3, int n4, ColumnMetaData columnMetaData, Object[] objectArray) throws SqlException {
        boolean bl = this.checkSendQryrowset(n2, n3);
        n2 = this.checkFetchsize(n2, n3);
        this.buildOPNQRY(section, bl, n2);
        netPreparedStatement.qryrowsetSentOnOpnqry_ = bl;
        if (n4 > 0) {
            if (this.extdtaPositions_ != null && !this.extdtaPositions_.isEmpty()) {
                this.extdtaPositions_.clear();
            }
            boolean bl2 = this.buildSQLDTAcommandData(n4, columnMetaData, objectArray);
            this.buildEXTDTA(columnMetaData, objectArray, false);
        }
    }

    @Override
    public void writeOpenQuery(NetStatement netStatement, Section section, int n2, int n3) throws SqlException {
        boolean bl = this.checkSendQryrowset(n2, n3);
        n2 = this.checkFetchsize(n2, n3);
        this.buildOPNQRY(section, bl, n2);
        netStatement.qryrowsetSentOnOpnqry_ = bl;
    }

    @Override
    public void writeDescribeInput(NetPreparedStatement netPreparedStatement, Section section) throws SqlException {
        int n2 = 5;
        this.buildDSCSQLSTT(section, true, n2);
    }

    @Override
    public void writeDescribeOutput(NetPreparedStatement netPreparedStatement, Section section) throws SqlException {
        this.buildDSCSQLSTT(section, true, 4);
    }

    @Override
    public void writeExecuteCall(NetStatement netStatement, boolean bl, String string, Section section, int n2, boolean bl2, int n3, ColumnMetaData columnMetaData, Object[] objectArray) throws SqlException {
        boolean bl3 = true;
        n2 = n2 == 0 ? 64 : n2;
        boolean bl4 = string != null;
        int n4 = columnMetaData != null ? columnMetaData.columns_ : 0;
        bl = n4 > 0;
        this.buildEXCSQLSTT(section, true, bl, bl4, string, true, !bl2, 65535, true, -1, true, this.calculateResultSetFlags(), bl3, n2);
        if (n4 > 0) {
            if (this.extdtaPositions_ != null && !this.extdtaPositions_.isEmpty()) {
                this.extdtaPositions_.clear();
            }
            boolean bl5 = this.buildSQLDTAcommandData(n4, columnMetaData, objectArray);
            this.buildEXTDTA(columnMetaData, objectArray, false);
        }
        netStatement.qryrowsetSentOnOpnqry_ = bl3;
    }

    private void buildOPNQRY(Section section, boolean bl, int n2) throws SqlException {
        this.createCommand();
        this.markLengthBytes(8204);
        this.buildPKGNAMCSN(section);
        this.buildQRYBLKSZ();
        if (bl) {
            this.buildMAXBLKEXT(-1);
            this.buildQRYROWSET(n2);
        }
        if (this.netAgent_.netConnection_.serverSupportsQryclsimp()) {
            this.buildQRYCLSIMP();
        }
        this.updateLengthBytes();
    }

    private void buildEXCSQLIMM(Section section, boolean bl, long l2) throws SqlException {
        this.createCommand();
        this.markLengthBytes(8202);
        this.buildPKGNAMCSN(section);
        this.buildRDBCMTOK();
        if (bl) {
            this.buildQRYINSID(l2);
        }
        this.updateLengthBytes();
    }

    private void buildPRPSQLSTT(Section section, String string, boolean bl, boolean bl2, int n2) throws SqlException {
        this.createCommand();
        this.markLengthBytes(8205);
        this.buildPKGNAMCSN(section);
        if (bl) {
            this.buildRTNSQLDA();
        }
        if (bl2) {
            this.buildTYPSQLDA(n2);
        }
        this.updateLengthBytes();
    }

    private void buildEXCSQLSET(Section section) throws SqlException {
        this.createCommand();
        this.markLengthBytes(8212);
        this.buildPKGNAMCSN(section);
        this.updateLengthBytes();
    }

    private void buildEXCSQLSTT(Section section, boolean bl, boolean bl2, boolean bl3, String string, boolean bl4, boolean bl5, int n2, boolean bl6, int n3, boolean bl7, int n4, boolean bl8, int n5) throws SqlException {
        this.createCommand();
        this.markLengthBytes(8203);
        this.buildPKGNAMCSN(section);
        this.buildRDBCMTOK();
        if (bl) {
            this.buildOUTEXP(bl2);
        }
        if (bl4) {
            this.buildQRYBLKSZ();
        }
        if (bl8 && bl6) {
            this.buildMAXBLKEXT(n3);
        }
        if (bl5) {
            this.buildMAXRSLCNT(n2);
        }
        if (bl7) {
            this.buildRSLSETFLG(n4);
        }
        if (bl8) {
            this.buildQRYROWSET(n5);
        }
        if (bl3) {
            this.buildPRCNAM(string);
        }
        this.updateLengthBytes();
    }

    private void buildDSCSQLSTT(Section section, boolean bl, int n2) throws SqlException {
        this.createCommand();
        this.markLengthBytes(8200);
        this.buildPKGNAMCSN(section);
        if (bl) {
            this.buildTYPSQLDA(n2);
        }
        this.updateLengthBytes();
    }

    private boolean buildSQLDTAcommandData(int n2, ColumnMetaData columnMetaData, Object[] objectArray) throws SqlException {
        this.createEncryptedCommandData();
        int n3 = this.buffer.position();
        this.markLengthBytes(9234);
        int[][] nArray = this.allocateLidAndLengthsArray(columnMetaData);
        Hashtable hashtable = null;
        ArrayList arrayList = null;
        hashtable = this.computeProtocolTypesAndLengths(objectArray, columnMetaData, nArray, hashtable);
        boolean bl = false;
        this.buildFDODSC(n2, nArray, bl, hashtable, arrayList);
        this.buildFDODTA(n2, nArray, objectArray);
        this.updateLengthBytes();
        if (this.netAgent_.netConnection_.getSecurityMechanism() == 12 || this.netAgent_.netConnection_.getSecurityMechanism() == 13) {
            this.encryptDataStream(n3);
        }
        return bl;
    }

    private void buildFDODSC(int n2, int[][] nArray, boolean bl, Hashtable hashtable, ArrayList arrayList) throws SqlException {
        this.markLengthBytes(16);
        this.buildSQLDTA(n2, nArray, bl, hashtable, arrayList);
        this.updateLengthBytes();
    }

    private void buildSQLDTA(int n2, int[][] nArray, boolean bl, Hashtable hashtable, ArrayList arrayList) throws SqlException {
        if (bl) {
            this.buildMddOverrides(arrayList);
            this.writeBytes(FdocaConstants.MDD_SQLDTAGRP_TOSEND);
        }
        this.buildSQLDTAGRP(n2, nArray, bl, hashtable);
        if (bl) {
            this.writeBytes(FdocaConstants.MDD_SQLDTA_TOSEND);
        }
        this.writeBytes(FdocaConstants.SQLDTA_RLO_TOSEND);
    }

    private void buildSQLDTAGRP(int n2, int[][] nArray, boolean bl, Hashtable hashtable) throws SqlException {
        int n3 = 0;
        int n4 = 0;
        n3 = this.calculateColumnsInSQLDTAGRPtriplet(n2);
        this.buildTripletHeader(3 * n3 + 3, 118, 208);
        while (true) {
            this.writeLidAndLengths(nArray, n3, n4, bl, hashtable);
            if ((n2 -= n3) == 0) break;
            n4 += n3;
            n3 = this.calculateColumnsInSQLDTAGRPtriplet(n2);
            this.buildTripletHeader(3 * n3 + 3, 127, 0);
        }
    }

    protected void buildOUTOVR(ClientResultSet clientResultSet, ColumnMetaData columnMetaData) throws SqlException {
        this.createCommandData();
        this.markLengthBytes(9237);
        int[][] nArray = this.calculateOUTOVRLidAndLengthOverrides(clientResultSet, columnMetaData);
        this.buildSQLDTARD(columnMetaData.columns_, nArray);
        this.updateLengthBytes();
    }

    private int[][] calculateOUTOVRLidAndLengthOverrides(ClientResultSet clientResultSet, ColumnMetaData columnMetaData) {
        int n2 = columnMetaData.columns_;
        int[][] nArray = new int[n2][2];
        block4: for (int i2 = 0; i2 < n2; ++i2) {
            switch (columnMetaData.types_[i2]) {
                case 2004: {
                    nArray[i2][0] = columnMetaData.nullable_[i2] ? 25 : 24;
                    nArray[i2][1] = 4;
                    continue block4;
                }
                case 2005: {
                    nArray[i2][0] = columnMetaData.nullable_[i2] ? 27 : 26;
                    nArray[i2][1] = 4;
                }
            }
        }
        return nArray;
    }

    private void buildSQLDTARD(int n2, int[][] nArray) throws SqlException {
        this.buildSQLCADTA(n2, nArray);
        this.writeBytes(FdocaConstants.SQLDTARD_RLO_TOSEND);
    }

    private void buildSQLCADTA(int n2, int[][] nArray) throws SqlException {
        this.buildSQLDTAGRP(n2, nArray, false, null);
        this.writeBytes(FdocaConstants.SQLCADTA_RLO_TOSEND);
    }

    private void buildFDODTA(int n2, int[][] nArray, Object[] objectArray) throws SqlException {
        try {
            Object object = null;
            this.markLengthBytes(5242);
            this.write1Byte(0);
            block27: for (int i2 = 0; i2 < n2; ++i2) {
                if (objectArray[i2] == null) {
                    if (nArray[i2][0] % 2 != 1) continue;
                    this.write1Byte(255);
                    continue;
                }
                if (nArray[i2][0] % 2 == 1) {
                    this.write1Byte(0);
                }
                switch (nArray[i2][0] | 1) {
                    case 63: 
                    case 65: {
                        object = this.retrievePromotedParameterIfExists(i2);
                        if (object == null) {
                            this.writeSingleorMixedCcsidLDString((String)objectArray[i2], this.netAgent_.typdef_.getCcsidMbcEncoding());
                            continue block27;
                        }
                        this.setFDODTALob(this.netAgent_.netConnection_.getSecurityMechanism(), (ClientClob)object, nArray, i2);
                        continue block27;
                    }
                    case 51: 
                    case 53: {
                        object = this.retrievePromotedParameterIfExists(i2);
                        if (object == null) continue block27;
                        this.setFDODTALob(this.netAgent_.netConnection_.getSecurityMechanism(), (ClientClob)object, nArray, i2);
                        continue block27;
                    }
                    case 191: {
                        this.writeBoolean((Boolean)objectArray[i2]);
                        continue block27;
                    }
                    case 3: {
                        this.writeIntFdocaData((Integer)objectArray[i2]);
                        continue block27;
                    }
                    case 5: {
                        this.writeShortFdocaData((Short)objectArray[i2]);
                        continue block27;
                    }
                    case 13: {
                        this.writeFloat(((Float)objectArray[i2]).floatValue());
                        continue block27;
                    }
                    case 11: {
                        this.writeDouble((Double)objectArray[i2]);
                        continue block27;
                    }
                    case 15: {
                        this.writeBigDecimal((BigDecimal)objectArray[i2], nArray[i2][1] >> 8 & 0xFF, nArray[i2][1] & 0xFF);
                        continue block27;
                    }
                    case 33: {
                        DateTimeValue dateTimeValue = objectArray[i2] instanceof Date ? new DateTimeValue((Date)objectArray[i2]) : (DateTimeValue)objectArray[i2];
                        this.writeDate(dateTimeValue);
                        continue block27;
                    }
                    case 35: {
                        DateTimeValue dateTimeValue = objectArray[i2] instanceof Time ? new DateTimeValue((Time)objectArray[i2]) : (DateTimeValue)objectArray[i2];
                        this.writeTime(dateTimeValue);
                        continue block27;
                    }
                    case 37: {
                        DateTimeValue dateTimeValue = objectArray[i2] instanceof Timestamp ? new DateTimeValue((Timestamp)objectArray[i2]) : (DateTimeValue)objectArray[i2];
                        this.writeTimestamp(dateTimeValue);
                        continue block27;
                    }
                    case 23: {
                        this.writeLongFdocaData((Long)objectArray[i2]);
                        continue block27;
                    }
                    case 41: 
                    case 43: {
                        object = this.retrievePromotedParameterIfExists(i2);
                        if (object == null) {
                            this.writeLDBytes((byte[])objectArray[i2]);
                            continue block27;
                        }
                        this.setFDODTALob(this.netAgent_.netConnection_.getSecurityMechanism(), (ClientClob)object, nArray, i2);
                        continue block27;
                    }
                    case 81: {
                        this.writeUDT(objectArray[i2]);
                        continue block27;
                    }
                    case 203: 
                    case 205: {
                        long l2;
                        Object object2;
                        object = this.retrievePromotedParameterIfExists(i2);
                        if (object == null) {
                            try {
                                object2 = (Clob)objectArray[i2];
                                if (object2 instanceof ClientClob && ((ClientClob)object2).willBeLayerBStreamed()) {
                                    this.setFDODTALobLengthUnknown(i2);
                                    continue block27;
                                }
                                l2 = object2.length();
                                this.setFDODTALobLength(nArray, i2, l2);
                                continue block27;
                            }
                            catch (SQLException sQLException) {
                                throw new SqlException(this.netAgent_.logWriter_, new ClientMessageId("XN009.S"), sQLException, new Object[0]);
                            }
                        }
                        this.setFDODTALob(this.netAgent_.netConnection_.getSecurityMechanism(), (ClientClob)object, nArray, i2);
                        continue block27;
                    }
                    case 201: {
                        long l2;
                        Object object2;
                        object = this.retrievePromotedParameterIfExists(i2);
                        if (object == null) {
                            try {
                                object2 = (Blob)objectArray[i2];
                                if (object2 instanceof ClientBlob && ((ClientBlob)object2).willBeLayerBStreamed()) {
                                    this.setFDODTALobLengthUnknown(i2);
                                    continue block27;
                                }
                                l2 = object2.length();
                                this.setFDODTALobLength(nArray, i2, l2);
                                continue block27;
                            }
                            catch (SQLException sQLException) {
                                throw new SqlException(this.netAgent_.logWriter_, new ClientMessageId("XN009.S"), sQLException, new Object[0]);
                            }
                        }
                        this.setFDODTALob(this.netAgent_.netConnection_.getSecurityMechanism(), (ClientBlob)object, nArray, i2);
                        continue block27;
                    }
                    case 207: {
                        Object object2;
                        object = this.retrievePromotedParameterIfExists(i2);
                        if (object == null) {
                            object2 = (ClientClob)objectArray[i2];
                            if (((ClientClob)object2).isString()) {
                                this.setFDODTALobLength(nArray, i2, ((ClientClob)object2).getUTF8Length());
                                continue block27;
                            }
                            if (!((Lob)object2).willBeLayerBStreamed()) {
                                this.setFDODTALobLength(nArray, i2, ((ClientClob)object2).length());
                                continue block27;
                            }
                            this.setFDODTALobLengthUnknown(i2);
                            continue block27;
                        }
                        this.setFDODTALob(this.netAgent_.netConnection_.getSecurityMechanism(), (ClientClob)object, nArray, i2);
                        continue block27;
                    }
                    case 25: {
                        this.writeIntFdocaData(((ClientBlob)objectArray[i2]).getLocator());
                        continue block27;
                    }
                    case 27: {
                        this.writeIntFdocaData(((ClientClob)objectArray[i2]).getLocator());
                        continue block27;
                    }
                    default: {
                        throw new SqlException(this.netAgent_.logWriter_, new ClientMessageId("22005.S.4"), nArray[i2][0], n2, i2);
                    }
                }
            }
            this.updateLengthBytes();
        }
        catch (SQLException sQLException) {
            throw new SqlException(sQLException);
        }
    }

    private void buildEXTDTA(ColumnMetaData columnMetaData, Object[] objectArray, boolean bl) throws SqlException {
        try {
            if (this.extdtaPositions_ != null) {
                for (int i2 = 0; i2 < this.extdtaPositions_.size(); ++i2) {
                    boolean bl2;
                    ClientBlob clientBlob;
                    Lob lob;
                    int n2;
                    boolean bl3;
                    boolean bl4;
                    int n3 = this.extdtaPositions_.get(i2);
                    if (i2 != this.extdtaPositions_.size() - 1) {
                        bl4 = true;
                        bl3 = true;
                    } else {
                        bl4 = bl;
                        bl3 = false;
                    }
                    boolean bl5 = false;
                    if (columnMetaData.nullable_[n3]) {
                        bl5 = true;
                    }
                    if ((n2 = columnMetaData.clientParamtertype_[n3]) == 0) {
                        n2 = columnMetaData.types_[n3];
                    }
                    if (n2 == 2004 || n2 == -2 || n2 == -3 || n2 == -4) {
                        lob = (ClientBlob)this.retrievePromotedParameterIfExists(n3);
                        clientBlob = lob == null ? (Blob)objectArray[n3] : lob;
                        boolean bl6 = bl2 = !(clientBlob instanceof ClientBlob);
                        if (bl2) {
                            try {
                                this.writeScalarStream(bl4, bl3, 5228, (long)((int)clientBlob.length()), clientBlob.getBinaryStream(), bl5, n3 + 1);
                                continue;
                            }
                            catch (SQLException sQLException) {
                                throw new SqlException(this.netAgent_.logWriter_, new ClientMessageId("XN009.S"), sQLException, new Object[0]);
                            }
                        }
                        if (clientBlob.isBinaryStream()) {
                            if (clientBlob.willBeLayerBStreamed()) {
                                this.writeScalarStream(bl4, bl3, 5228, clientBlob.getBinaryStream(), bl5, n3 + 1);
                                continue;
                            }
                            this.writeScalarStream(bl4, bl3, 5228, (long)((int)clientBlob.length()), clientBlob.getBinaryStream(), bl5, n3 + 1);
                            continue;
                        }
                        this.writeScalarStream(bl4, bl3, 5228, (long)((int)clientBlob.length()), clientBlob.getBinaryStream(), bl5, n3 + 1);
                        continue;
                    }
                    if (n2 != 2005 && n2 != 1 && n2 != 12 && n2 != -1) continue;
                    lob = (ClientClob)this.retrievePromotedParameterIfExists(n3);
                    clientBlob = lob == null ? (Clob)objectArray[n3] : lob;
                    boolean bl7 = bl2 = !(clientBlob instanceof ClientClob);
                    if (bl2) {
                        try {
                            this.writeScalarStream(bl4, bl3, 5228, (int)clientBlob.length(), clientBlob.getCharacterStream(), bl5, n3 + 1);
                            continue;
                        }
                        catch (SQLException sQLException) {
                            throw new SqlException(this.netAgent_.logWriter_, new ClientMessageId("XN009.S"), sQLException, new Object[0]);
                        }
                    }
                    if (((ClientClob)((Object)clientBlob)).isCharacterStream()) {
                        if (((ClientClob)((Object)clientBlob)).willBeLayerBStreamed()) {
                            this.writeScalarStream(bl4, bl3, 5228, ((ClientClob)((Object)clientBlob)).getCharacterStream(), bl5, n3 + 1);
                            continue;
                        }
                        this.writeScalarStream(bl4, bl3, 5228, (int)((ClientClob)((Object)clientBlob)).length(), ((ClientClob)((Object)clientBlob)).getCharacterStream(), bl5, n3 + 1);
                        continue;
                    }
                    if (((ClientClob)((Object)clientBlob)).isAsciiStream()) {
                        if (((ClientClob)((Object)clientBlob)).willBeLayerBStreamed()) {
                            this.writeScalarStream(bl4, bl3, 5228, ((ClientClob)((Object)clientBlob)).getAsciiStream(), bl5, n3 + 1);
                            continue;
                        }
                        this.writeScalarStream(bl4, bl3, 5228, (long)((int)((ClientClob)((Object)clientBlob)).length()), ((ClientClob)((Object)clientBlob)).getAsciiStream(), bl5, n3 + 1);
                        continue;
                    }
                    if (((ClientClob)((Object)clientBlob)).isUnicodeStream()) {
                        if (((ClientClob)((Object)clientBlob)).willBeLayerBStreamed()) {
                            this.writeScalarStream(bl4, bl3, 5228, ((ClientClob)((Object)clientBlob)).getUnicodeStream(), bl5, n3 + 1);
                            continue;
                        }
                        this.writeScalarStream(bl4, bl3, 5228, (long)((int)((ClientClob)((Object)clientBlob)).length()), ((ClientClob)((Object)clientBlob)).getUnicodeStream(), bl5, n3 + 1);
                        continue;
                    }
                    this.writeScalarStream(bl4, bl3, 5228, (long)((ClientClob)((Object)clientBlob)).getUTF8Length(), new ByteArrayInputStream(((ClientClob)((Object)clientBlob)).getUtf8String()), bl5, n3 + 1);
                }
            }
        }
        catch (SQLException sQLException) {
            throw new SqlException(sQLException);
        }
    }

    private Object retrievePromotedParameterIfExists(int n2) {
        if (this.promototedParameters_.isEmpty()) {
            return null;
        }
        return this.promototedParameters_.get(n2);
    }

    private int calculateColumnsInSQLDTAGRPtriplet(int n2) {
        if (n2 > 84) {
            return 84;
        }
        return n2;
    }

    private Hashtable computeProtocolTypesAndLengths(Object[] objectArray, ColumnMetaData columnMetaData, int[][] nArray, Hashtable hashtable) throws SqlException {
        try {
            int n2 = columnMetaData.columns_;
            String string = null;
            if (!this.promototedParameters_.isEmpty()) {
                this.promototedParameters_.clear();
            }
            for (int i2 = 0; i2 < n2; ++i2) {
                int n3 = columnMetaData.clientParamtertype_[i2];
                if (n3 == 0) {
                    n3 = columnMetaData.types_[i2];
                }
                if (n3 == 0) {
                    throw new SqlException(this.netAgent_.logWriter_, new ClientMessageId("22005.S.5"), i2);
                }
                switch (n3) {
                    case 1: 
                    case 12: {
                        string = (String)objectArray[i2];
                        if (string == null || string.length() <= 10922) {
                            nArray[i2][0] = 63;
                            nArray[i2][1] = Short.MAX_VALUE;
                            break;
                        }
                        Object object = string.getBytes(Typdef.UTF8ENCODING);
                        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream((byte[])object);
                        ClientClob clientClob = new ClientClob((Agent)this.netAgent_, byteArrayInputStream, Typdef.UTF8ENCODING, ((Object)object).length);
                        this.promototedParameters_.put(i2, clientClob);
                        nArray[i2][0] = 207;
                        if (clientClob.willBeLayerBStreamed()) {
                            nArray[i2][1] = 32770;
                            break;
                        }
                        nArray[i2][1] = this.buildPlaceholderLength(clientClob.length());
                        break;
                    }
                    case 4: {
                        nArray[i2][0] = 3;
                        nArray[i2][1] = 4;
                        break;
                    }
                    case -7: 
                    case 16: {
                        if (this.netAgent_.netConnection_.databaseMetaData_.serverSupportsBooleanParameterTransport()) {
                            nArray[i2][0] = 191;
                            nArray[i2][1] = 1;
                            break;
                        }
                        nArray[i2][0] = 5;
                        nArray[i2][1] = 2;
                        if (!(objectArray[i2] instanceof Boolean)) break;
                        Object object = (Boolean)objectArray[i2];
                        objectArray[i2] = ((Boolean)object).booleanValue() ? (short)1 : 0;
                        break;
                    }
                    case -6: 
                    case 5: {
                        nArray[i2][0] = 5;
                        nArray[i2][1] = 2;
                        break;
                    }
                    case 7: {
                        nArray[i2][0] = 13;
                        nArray[i2][1] = 4;
                        break;
                    }
                    case 6: 
                    case 8: {
                        nArray[i2][0] = 11;
                        nArray[i2][1] = 8;
                        break;
                    }
                    case 2: 
                    case 3: {
                        int n4;
                        int n5;
                        Object object = (BigDecimal)objectArray[i2];
                        if (object == null) {
                            n5 = 0;
                            n4 = 1;
                        } else {
                            if (((BigDecimal)object).scale() < 0) {
                                objectArray[i2] = object = ((BigDecimal)object).setScale(0);
                            }
                            n5 = ((BigDecimal)object).scale();
                            n4 = Utils.computeBigDecimalPrecision((BigDecimal)object);
                        }
                        nArray[i2][0] = 15;
                        nArray[i2][1] = (n4 << 8) + (n5 << 0);
                        break;
                    }
                    case 91: {
                        nArray[i2][0] = 33;
                        nArray[i2][1] = 10;
                        break;
                    }
                    case 92: {
                        nArray[i2][0] = 35;
                        nArray[i2][1] = 8;
                        break;
                    }
                    case 93: {
                        nArray[i2][0] = 37;
                        nArray[i2][1] = DateTime.getTimestampLength(this.netAgent_.netConnection_.serverSupportsTimestampNanoseconds());
                        break;
                    }
                    case -5: {
                        nArray[i2][0] = 23;
                        nArray[i2][1] = 8;
                        break;
                    }
                    case -1: {
                        string = (String)objectArray[i2];
                        if (string == null || string.length() <= 10922) {
                            nArray[i2][0] = 65;
                            nArray[i2][1] = Short.MAX_VALUE;
                            break;
                        }
                        byte[] byArray = string.getBytes(Typdef.UTF8ENCODING);
                        Object object = new ByteArrayInputStream(byArray);
                        Clob clob = new ClientClob((Agent)this.netAgent_, (InputStream)object, Typdef.UTF8ENCODING, byArray.length);
                        this.promototedParameters_.put(i2, clob);
                        nArray[i2][0] = 207;
                        nArray[i2][1] = this.buildPlaceholderLength(((ClientClob)clob).length());
                        break;
                    }
                    case -3: 
                    case -2: {
                        byte[] byArray = (byte[])objectArray[i2];
                        if (byArray == null) {
                            nArray[i2][0] = 41;
                            nArray[i2][1] = Short.MAX_VALUE;
                            break;
                        }
                        if (byArray.length <= Short.MAX_VALUE) {
                            nArray[i2][0] = 41;
                            nArray[i2][1] = Short.MAX_VALUE;
                            break;
                        }
                        Object object = new ClientBlob(byArray, this.netAgent_, 0);
                        this.promototedParameters_.put(i2, object);
                        nArray[i2][0] = 201;
                        nArray[i2][1] = this.buildPlaceholderLength(byArray.length);
                        break;
                    }
                    case -4: {
                        byte[] byArray = (byte[])objectArray[i2];
                        if (byArray == null) {
                            nArray[i2][0] = 43;
                            nArray[i2][1] = Short.MAX_VALUE;
                            break;
                        }
                        if (byArray.length <= Short.MAX_VALUE) {
                            nArray[i2][0] = 43;
                            nArray[i2][1] = Short.MAX_VALUE;
                            break;
                        }
                        Object object = new ClientBlob(byArray, this.netAgent_, 0);
                        this.promototedParameters_.put(i2, object);
                        nArray[i2][0] = 201;
                        nArray[i2][1] = this.buildPlaceholderLength(byArray.length);
                        break;
                    }
                    case 2000: {
                        nArray[i2][0] = 81;
                        nArray[i2][1] = Short.MAX_VALUE;
                        break;
                    }
                    case 2004: {
                        Object object = (Blob)objectArray[i2];
                        if (object == null) {
                            nArray[i2][0] = 201;
                            nArray[i2][1] = this.buildPlaceholderLength(columnMetaData.sqlLength_[i2]);
                            break;
                        }
                        if (object instanceof ClientBlob && ((ClientBlob)object).isLocator()) {
                            nArray[i2][0] = 25;
                            nArray[i2][1] = 4;
                            break;
                        }
                        nArray[i2][0] = 201;
                        try {
                            if (object instanceof ClientBlob && ((ClientBlob)object).willBeLayerBStreamed()) {
                                nArray[i2][1] = 32770;
                                break;
                            }
                            nArray[i2][1] = this.buildPlaceholderLength(object.length());
                            break;
                        }
                        catch (SQLException sQLException) {
                            throw new SqlException(this.netAgent_.logWriter_, new ClientMessageId("XN009.S"), sQLException, new Object[0]);
                        }
                    }
                    case 2005: {
                        Clob clob = (Clob)objectArray[i2];
                        boolean bl = !(clob instanceof ClientClob);
                        long l2 = 0L;
                        boolean bl2 = false;
                        if (clob == null) {
                            l2 = columnMetaData.sqlLength_[i2];
                        } else if (clob instanceof ClientClob && ((ClientClob)clob).isLocator()) {
                            nArray[i2][0] = 27;
                            nArray[i2][1] = 4;
                        } else if (bl) {
                            try {
                                l2 = clob.length();
                            }
                            catch (SQLException sQLException) {
                                throw new SqlException(this.netAgent_.logWriter_, new ClientMessageId("XN009.S"), sQLException, new Object[0]);
                            }
                        } else if (((ClientClob)clob).willBeLayerBStreamed()) {
                            bl2 = true;
                        } else {
                            l2 = ((ClientClob)clob).length();
                        }
                        if (clob == null) {
                            nArray[i2][0] = 207;
                            nArray[i2][1] = this.buildPlaceholderLength(l2);
                            break;
                        }
                        if (bl) {
                            nArray[i2][0] = 205;
                            nArray[i2][1] = this.buildPlaceholderLength(l2);
                            break;
                        }
                        if (((ClientClob)clob).isCharacterStream()) {
                            nArray[i2][0] = 205;
                            if (bl2) {
                                nArray[i2][1] = 32770;
                                break;
                            }
                            nArray[i2][1] = this.buildPlaceholderLength(l2);
                            break;
                        }
                        if (((ClientClob)clob).isUnicodeStream()) {
                            nArray[i2][0] = 207;
                            if (bl2) {
                                nArray[i2][1] = 32770;
                                break;
                            }
                            nArray[i2][1] = this.buildPlaceholderLength(l2);
                            break;
                        }
                        if (((ClientClob)clob).isAsciiStream()) {
                            nArray[i2][0] = 203;
                            if (bl2) {
                                nArray[i2][1] = 32770;
                                break;
                            }
                            nArray[i2][1] = this.buildPlaceholderLength(l2);
                            break;
                        }
                        if (!((ClientClob)clob).isString()) break;
                        nArray[i2][0] = 207;
                        if (bl2) {
                            nArray[i2][1] = 32770;
                            break;
                        }
                        nArray[i2][1] = this.buildPlaceholderLength(l2);
                        break;
                    }
                    default: {
                        throw new SqlException(this.netAgent_.logWriter_, new ClientMessageId("22005.S.6"), n3);
                    }
                }
                if (columnMetaData.nullable_[i2]) continue;
                int[] nArray2 = nArray[i2];
                nArray2[0] = nArray2[0] - 1;
            }
            return hashtable;
        }
        catch (SQLException sQLException) {
            throw new SqlException(sQLException);
        }
    }

    private int buildPlaceholderLength(long l2) {
        if (l2 < 32767L) {
            return 32770;
        }
        if (l2 < Integer.MAX_VALUE) {
            return 32772;
        }
        if (l2 < 0x7FFFFFFFFFFFL) {
            return 32774;
        }
        return 32776;
    }

    private void buildOUTEXP(boolean bl) throws SqlException {
        if (bl) {
            this.writeScalar1Byte(8465, -15);
        }
    }

    void buildMAXBLKEXT(int n2) throws SqlException {
        if (n2 != 0) {
            this.writeScalar2Bytes(8513, n2);
        }
    }

    void buildQRYROWSET(int n2) throws SqlException {
        this.writeScalar4Bytes(8534, n2);
    }

    private void buildPRCNAM(String string) throws SqlException {
        if (string == null) {
            throw new SqlException(this.netAgent_.logWriter_, new ClientMessageId("XN010.S"), new Object[0]);
        }
        int n2 = string.length();
        if (n2 == 0 || n2 > 255) {
            throw new SqlException(this.netAgent_.logWriter_, new ClientMessageId("XN011.S"), n2, 255);
        }
        this.writeScalarString(8504, string);
    }

    void buildQRYBLKSZ() throws SqlException {
        this.writeScalar4Bytes(8468, 32767L);
    }

    private void buildMAXRSLCNT(int n2) throws SqlException {
        if (n2 == 0) {
            return;
        }
        this.writeScalar2Bytes(8512, n2);
    }

    private void buildRDBCMTOK() throws SqlException {
        this.writeScalar1Byte(8453, -15);
    }

    private void buildRSLSETFLG(int n2) throws SqlException {
        this.writeScalar1Byte(8514, n2);
    }

    void buildQRYINSID(long l2) throws SqlException {
        this.markLengthBytes(8539);
        this.writeLong(l2);
        this.updateLengthBytes();
    }

    private void buildRTNSQLDA() throws SqlException {
        this.writeScalar1Byte(8470, -15);
    }

    private void buildTYPSQLDA(int n2) throws SqlException {
        if (n2 != 0) {
            this.writeScalar1Byte(8518, n2);
        }
    }

    private void buildQRYCLSIMP() {
        this.writeScalar1Byte(8541, 1);
    }

    private void setFDODTALobLength(int[][] nArray, int n2, long l2) throws SqlException {
        if (nArray[n2][1] == 32770) {
            this.writeShort((short)l2);
        } else if (nArray[n2][1] == 32772) {
            this.writeInt((int)l2);
        } else if (nArray[n2][1] == 32774) {
            this.writeLong6Bytes(l2);
        } else if (nArray[n2][1] == 32776) {
            this.writeLong(l2);
        }
        if (l2 != 0L) {
            if (this.extdtaPositions_ == null) {
                this.extdtaPositions_ = new ArrayList();
            }
            this.extdtaPositions_.add(n2);
        }
    }

    private void setFDODTALobLengthUnknown(int n2) throws SqlException {
        int n3 = 1;
        short s2 = (short)(n3 << 15);
        n3 = s2;
        this.writeShort(s2);
        if (this.extdtaPositions_ == null) {
            this.extdtaPositions_ = new ArrayList();
        }
        this.extdtaPositions_.add(n2);
    }

    private boolean checkSendQryrowset(int n2, int n3) {
        boolean bl = false;
        if (n3 != 1003) {
            bl = true;
        }
        return bl;
    }

    private int checkFetchsize(int n2, int n3) {
        if (n3 != 1003 && n2 == 0) {
            n2 = 64;
        }
        return n2;
    }

    private int calculateResultSetFlags() {
        return 4;
    }

    @Override
    public void writeSetSpecialRegister(Section section, ArrayList arrayList) throws SqlException {
        this.buildEXCSQLSET(section);
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            this.buildSQLSTTcommandData((String)arrayList.get(i2));
        }
    }

    private int[][] allocateLidAndLengthsArray(ColumnMetaData columnMetaData) {
        int n2 = columnMetaData.columns_;
        int[][] nArray = columnMetaData.protocolTypesCache_;
        if (nArray == null || nArray.length != n2) {
            columnMetaData.protocolTypesCache_ = nArray = new int[n2][2];
        }
        return nArray;
    }

    private void buildMddOverrides(ArrayList arrayList) throws SqlException {
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            byte[] byArray = (byte[])arrayList.get(i2);
            this.writeBytes(byArray);
        }
    }

    private void setFDODTALob(int n2, Lob lob, int[][] nArray, int n3) throws SqlException, SQLException {
        if (lob.willBeLayerBStreamed()) {
            this.setFDODTALobLengthUnknown(n3);
        } else {
            this.setFDODTALobLength(nArray, n3, lob.length());
        }
    }
}

