/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.db;

import java.sql.SQLException;
import org.apache.derby.iapi.error.PublicAPI;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.security.Securable;
import org.apache.derby.iapi.security.SecurityUtil;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.sql.conn.ConnectionUtil;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptorList;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptorList;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.ExecutionFactory;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.GenericScanController;
import org.apache.derby.iapi.store.access.RowUtil;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.DataValueFactory;
import org.apache.derby.iapi.types.RowLocation;

public class ConsistencyChecker {
    private ConsistencyChecker() {
    }

    public static boolean checkTable(String string, String string2) throws SQLException {
        long l2 = -1L;
        RowLocation rowLocation = null;
        RowLocation rowLocation2 = null;
        GenericScanController genericScanController = null;
        int n2 = 0;
        ConglomerateController conglomerateController = null;
        ConglomerateController conglomerateController2 = null;
        LanguageConnectionContext languageConnectionContext = ConnectionUtil.getCurrentLCC();
        TransactionController transactionController = languageConnectionContext.getTransactionExecute();
        try {
            DataValueDescriptor[] dataValueDescriptorArray;
            ConstraintDescriptor constraintDescriptor;
            SecurityUtil.authorize(Securable.CHECK_TABLE);
            DataDictionary dataDictionary = languageConnectionContext.getDataDictionary();
            DataValueFactory dataValueFactory = languageConnectionContext.getDataValueFactory();
            ExecutionFactory executionFactory = languageConnectionContext.getLanguageConnectionFactory().getExecutionFactory();
            SchemaDescriptor schemaDescriptor = dataDictionary.getSchemaDescriptor(string, transactionController, true);
            TableDescriptor tableDescriptor = dataDictionary.getTableDescriptor(string2, schemaDescriptor, transactionController);
            if (tableDescriptor == null) {
                throw StandardException.newException("42X05", string + "." + string2);
            }
            if (tableDescriptor.getTableType() == 2) {
                boolean bl = true;
                return bl;
            }
            conglomerateController = transactionController.openConglomerate(tableDescriptor.getHeapConglomerateId(), false, 0, 7, 5);
            conglomerateController.checkConsistency();
            ConglomerateDescriptor conglomerateDescriptor = tableDescriptor.getConglomerateDescriptor(tableDescriptor.getHeapConglomerateId());
            ExecRow execRow = executionFactory.getValueRow(tableDescriptor.getNumberOfColumns());
            ColumnDescriptorList columnDescriptorList = tableDescriptor.getColumnDescriptorList();
            int n3 = columnDescriptorList.size();
            for (int i2 = 0; i2 < n3; ++i2) {
                ColumnDescriptor columnDescriptor = columnDescriptorList.elementAt(i2);
                execRow.setColumn(columnDescriptor.getPosition(), columnDescriptor.getType().getNull());
            }
            ConglomerateDescriptor[] conglomerateDescriptorArray = tableDescriptor.getConglomerateDescriptors();
            for (int i3 = 0; i3 < conglomerateDescriptorArray.length; ++i3) {
                DataValueDescriptor[] dataValueDescriptorArray2;
                int n4;
                ConglomerateDescriptor conglomerateDescriptor2 = conglomerateDescriptorArray[i3];
                if (!conglomerateDescriptor2.isIndex()) continue;
                conglomerateController2 = transactionController.openConglomerate(conglomerateDescriptor2.getConglomerateNumber(), false, 0, 7, 5);
                conglomerateController2.checkConsistency();
                conglomerateController2.close();
                conglomerateController2 = null;
                if (conglomerateDescriptor2.isConstraint() && (constraintDescriptor = dataDictionary.getConstraintDescriptor(tableDescriptor, conglomerateDescriptor2.getUUID())) == null) {
                    throw StandardException.newException("42X94", "CONSTRAINT for INDEX", conglomerateDescriptor2.getConglomerateName());
                }
                if (l2 < 0L) {
                    genericScanController = transactionController.openScan(conglomerateDescriptor.getConglomerateNumber(), false, 0, 7, 5, RowUtil.EMPTY_ROW_BITSET, null, 0, null, null, 0);
                    rowLocation = genericScanController.newRowLocationTemplate();
                    rowLocation2 = genericScanController.newRowLocationTemplate();
                    l2 = 0L;
                    while (genericScanController.next()) {
                        ++l2;
                    }
                    genericScanController.close();
                    genericScanController = null;
                }
                int[] nArray = conglomerateDescriptor2.getIndexDescriptor().baseColumnPositions();
                n2 = nArray.length;
                FormatableBitSet formatableBitSet = new FormatableBitSet();
                for (n4 = 0; n4 < n2; ++n4) {
                    formatableBitSet.grow(nArray[n4]);
                    formatableBitSet.set(nArray[n4] - 1);
                }
                ExecRow execRow2 = executionFactory.getValueRow(n2 + 1);
                for (n4 = 0; n4 < n2; ++n4) {
                    dataValueDescriptorArray2 = tableDescriptor.getColumnDescriptor(nArray[n4]);
                    execRow2.setColumn(n4 + 1, dataValueDescriptorArray2.getType().getNull());
                }
                execRow2.setColumn(n2 + 1, rowLocation);
                genericScanController = transactionController.openScan(conglomerateDescriptor2.getConglomerateNumber(), false, 0, 7, 5, null, null, 0, null, null, 0);
                dataValueDescriptorArray = new DataValueDescriptor[n2];
                dataValueDescriptorArray2 = execRow.getRowArray();
                for (int i4 = 0; i4 < n2; ++i4) {
                    dataValueDescriptorArray[i4] = dataValueDescriptorArray2[nArray[i4] - 1];
                }
                long l3 = 0L;
                while (genericScanController.fetchNext(execRow2.getRowArray())) {
                    RowLocation rowLocation3 = (RowLocation)execRow2.getColumn(n2 + 1);
                    boolean bl = conglomerateController.fetch(rowLocation3, dataValueDescriptorArray2, formatableBitSet);
                    if (!bl) {
                        String string3 = conglomerateDescriptor2.getConglomerateName();
                        throw StandardException.newException("X0X62.S", string + "." + string2, string3, rowLocation3.toString(), execRow2.toString());
                    }
                    for (int i5 = 0; i5 < n2; ++i5) {
                        DataValueDescriptor dataValueDescriptor;
                        DataValueDescriptor dataValueDescriptor2 = execRow2.getColumn(i5 + 1);
                        if (dataValueDescriptor2.compare(dataValueDescriptor = dataValueDescriptorArray[i5]) == 0) continue;
                        ColumnDescriptor columnDescriptor = tableDescriptor.getColumnDescriptor(nArray[i5]);
                        throw StandardException.newException("X0X61.S", conglomerateDescriptor2.getConglomerateName(), tableDescriptor.getSchemaName(), tableDescriptor.getName(), rowLocation3.toString(), columnDescriptor.getColumnName(), dataValueDescriptor2.toString(), dataValueDescriptor.toString(), execRow2.toString());
                    }
                    ++l3;
                }
                genericScanController.close();
                genericScanController = null;
                if (l3 == l2) continue;
                throw StandardException.newException("X0Y55.S", conglomerateDescriptor2.getConglomerateName(), tableDescriptor.getSchemaName(), tableDescriptor.getName(), Long.toString(l3), Long.toString(l2));
            }
            ConstraintDescriptorList constraintDescriptorList = dataDictionary.getConstraintDescriptors(tableDescriptor);
            for (int i6 = 0; i6 < constraintDescriptorList.size(); ++i6) {
                constraintDescriptor = constraintDescriptorList.elementAt(i6);
                if (!constraintDescriptor.hasBackingIndex() || (dataValueDescriptorArray = tableDescriptor.getConglomerateDescriptor(constraintDescriptor.getConglomerateId())) != null) continue;
                throw StandardException.newException("42X94", "INDEX for CONSTRAINT", constraintDescriptor.getConstraintName());
            }
        }
        catch (StandardException standardException) {
            throw PublicAPI.wrapStandardException(standardException);
        }
        finally {
            try {
                if (conglomerateController != null) {
                    conglomerateController.close();
                    conglomerateController = null;
                }
                if (conglomerateController2 != null) {
                    conglomerateController2.close();
                    conglomerateController2 = null;
                }
                if (genericScanController != null) {
                    genericScanController.close();
                    genericScanController = null;
                }
            }
            catch (StandardException standardException) {
                throw PublicAPI.wrapStandardException(standardException);
            }
        }
        return true;
    }
}

