/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.services.classfile;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.derby.iapi.services.classfile.AttributeEntry;
import org.apache.derby.iapi.services.classfile.Attributes;
import org.apache.derby.iapi.services.classfile.CONSTANT_Double_info;
import org.apache.derby.iapi.services.classfile.CONSTANT_Float_info;
import org.apache.derby.iapi.services.classfile.CONSTANT_Index_info;
import org.apache.derby.iapi.services.classfile.CONSTANT_Integer_info;
import org.apache.derby.iapi.services.classfile.CONSTANT_Long_info;
import org.apache.derby.iapi.services.classfile.CONSTANT_Utf8_info;
import org.apache.derby.iapi.services.classfile.ClassFormatOutput;
import org.apache.derby.iapi.services.classfile.ClassMember;
import org.apache.derby.iapi.services.classfile.ConstantPoolEntry;
import org.apache.derby.iapi.services.classfile.MemberTable;
import org.apache.derby.iapi.util.ByteArray;

public class ClassHolder {
    protected int minor_version = 3;
    protected int major_version = 45;
    protected int access_flags;
    protected int this_class;
    protected int super_class;
    protected int[] interfaces;
    protected MemberTable field_info;
    protected MemberTable method_info;
    protected Attributes attribute_info;
    protected Hashtable<Object, ConstantPoolEntry> cptHashTable;
    protected Vector<ConstantPoolEntry> cptEntries;
    private int cptEstimatedSize;
    private final CONSTANT_Index_info searchIndex = new CONSTANT_Index_info(0, 0, 0);

    protected ClassHolder(int n2) {
        this.cptEntries = new Vector(n2);
        this.cptHashTable = new Hashtable(n2, 0.75f);
        this.cptEntries.setSize(1);
    }

    public ClassHolder(String string, String string2, int n2) {
        this(100);
        this.access_flags = n2 | 0x20;
        this.this_class = this.addClassReference(string);
        this.super_class = this.addClassReference(string2);
        this.method_info = new MemberTable(0);
    }

    private void put(ClassFormatOutput classFormatOutput) throws IOException {
        classFormatOutput.putU4(-889275714);
        classFormatOutput.putU2(this.minor_version);
        classFormatOutput.putU2(this.major_version);
        classFormatOutput.putU2("constant_pool", this.cptEntries.size());
        this.cptPut(classFormatOutput);
        classFormatOutput.putU2(this.access_flags);
        classFormatOutput.putU2(this.this_class);
        classFormatOutput.putU2(this.super_class);
        if (this.interfaces != null) {
            int n2 = this.interfaces.length;
            classFormatOutput.putU2(n2);
            for (int i2 = 0; i2 < n2; ++i2) {
                classFormatOutput.putU2(this.interfaces[i2]);
            }
        } else {
            classFormatOutput.putU2(0);
        }
        if (this.field_info != null) {
            classFormatOutput.putU2(this.field_info.size());
            this.field_info.put(classFormatOutput);
        } else {
            classFormatOutput.putU2(0);
        }
        if (this.method_info != null) {
            classFormatOutput.putU2(this.method_info.size());
            this.method_info.put(classFormatOutput);
        } else {
            classFormatOutput.putU2(0);
        }
        if (this.attribute_info != null) {
            classFormatOutput.putU2(this.attribute_info.size());
            this.attribute_info.put(classFormatOutput);
        } else {
            classFormatOutput.putU2(0);
        }
    }

    public ByteArray getFileFormat() throws IOException {
        int n2 = 24;
        n2 += this.cptEstimatedSize;
        if (this.interfaces != null) {
            n2 += this.interfaces.length * 2;
        }
        if (this.field_info != null) {
            n2 += this.field_info.classFileSize();
        }
        if (this.method_info != null) {
            n2 += this.method_info.classFileSize();
        }
        if (this.attribute_info != null) {
            n2 += this.attribute_info.classFileSize();
        }
        ClassFormatOutput classFormatOutput = new ClassFormatOutput(n2 + 200);
        this.put(classFormatOutput);
        return new ByteArray(classFormatOutput.getData(), 0, classFormatOutput.size());
    }

    public int getModifier() {
        return this.access_flags;
    }

    public String getName() {
        return this.className(this.this_class).replace('/', '.');
    }

    public ClassMember addMember(String string, String string2, int n2) {
        MemberTable memberTable;
        CONSTANT_Utf8_info cONSTANT_Utf8_info = this.addUtf8Entry(string);
        int n3 = cONSTANT_Utf8_info.getIndex();
        int n4 = this.addUtf8Entry(string2).getIndex();
        ClassMember classMember = new ClassMember(this, n2, n3, n4);
        if (string2.startsWith("(")) {
            memberTable = this.method_info;
            if (memberTable == null) {
                memberTable = this.method_info = new MemberTable(0);
            }
        } else {
            memberTable = this.field_info;
            if (memberTable == null) {
                memberTable = this.field_info = new MemberTable(0);
            }
        }
        memberTable.addEntry(classMember);
        return classMember;
    }

    public int addFieldReference(String string, String string2, String string3) {
        return this.addReference(9, string, string2, string3);
    }

    public int addFieldReference(ClassMember classMember) {
        return this.addReference(9, classMember);
    }

    public int addMethodReference(String string, String string2, String string3, boolean bl) {
        int n2 = bl ? 11 : 10;
        return this.addReference(n2, string, string2, string3);
    }

    private int addReference(int n2, String string, String string2, String string3) {
        int n3 = this.addClassReference(string);
        int n4 = this.addNameAndType(string2, string3);
        return this.addIndexReference(n2, n3, n4);
    }

    private int addReference(int n2, ClassMember classMember) {
        int n3 = this.addIndexReference(12, classMember.name_index, classMember.descriptor_index);
        return this.addIndexReference(n2, this.this_class, n3);
    }

    public int addConstant(String string) {
        return this.addString(string);
    }

    public int addUtf8(String string) {
        return this.addUtf8Entry(string).getIndex();
    }

    public int addConstant(int n2) {
        return this.addDirectEntry(new CONSTANT_Integer_info(n2));
    }

    public int addConstant(float f2) {
        return this.addDirectEntry(new CONSTANT_Float_info(f2));
    }

    public int addConstant(long l2) {
        return this.addDirectEntry(new CONSTANT_Long_info(l2));
    }

    public int addConstant(double d2) {
        return this.addDirectEntry(new CONSTANT_Double_info(d2));
    }

    public int getConstantPoolIndex() {
        return this.this_class;
    }

    public void addAttribute(String string, ClassFormatOutput classFormatOutput) {
        if (this.attribute_info == null) {
            this.attribute_info = new Attributes(1);
        }
        CONSTANT_Utf8_info cONSTANT_Utf8_info = this.addUtf8Entry(string);
        int n2 = cONSTANT_Utf8_info.getIndex();
        this.attribute_info.addEntry(new AttributeEntry(n2, classFormatOutput));
    }

    public String getSuperClassName() {
        if (this.super_class == 0) {
            return null;
        }
        return this.className(this.super_class).replace('/', '.');
    }

    protected int addEntry(Object object, ConstantPoolEntry constantPoolEntry) {
        constantPoolEntry.setIndex(this.cptEntries.size());
        if (object != null) {
            this.cptHashTable.put(object, constantPoolEntry);
        }
        this.cptEntries.add(constantPoolEntry);
        this.cptEstimatedSize += constantPoolEntry.classFileSize();
        if (constantPoolEntry.doubleSlot()) {
            this.cptEntries.add(null);
            return 2;
        }
        return 1;
    }

    private int addDirectEntry(ConstantPoolEntry constantPoolEntry) {
        ConstantPoolEntry constantPoolEntry2 = this.findMatchingEntry(constantPoolEntry);
        if (constantPoolEntry2 != null) {
            constantPoolEntry = constantPoolEntry2;
        } else {
            this.addEntry(constantPoolEntry.getKey(), constantPoolEntry);
        }
        return constantPoolEntry.getIndex();
    }

    private int addIndexReference(int n2, int n3, int n4) {
        this.searchIndex.set(n2, n3, n4);
        ConstantPoolEntry constantPoolEntry = this.findMatchingEntry(this.searchIndex);
        if (constantPoolEntry == null) {
            constantPoolEntry = new CONSTANT_Index_info(n2, n3, n4);
            this.addEntry(constantPoolEntry.getKey(), constantPoolEntry);
        }
        return constantPoolEntry.getIndex();
    }

    public int addClassReference(String string) {
        if (ClassHolder.isExternalClassName(string)) {
            string = ClassHolder.convertToInternalClassName(string);
        }
        int n2 = this.addUtf8Entry(string).getIndex();
        return this.addIndexReference(7, n2, 0);
    }

    private int addNameAndType(String string, String string2) {
        int n2 = this.addUtf8Entry(string).getIndex();
        int n3 = this.addUtf8Entry(string2).getIndex();
        return this.addIndexReference(12, n2, n3);
    }

    private CONSTANT_Utf8_info addUtf8Entry(String string) {
        CONSTANT_Utf8_info cONSTANT_Utf8_info = (CONSTANT_Utf8_info)this.findMatchingEntry(string);
        if (cONSTANT_Utf8_info == null) {
            cONSTANT_Utf8_info = new CONSTANT_Utf8_info(string);
            this.addEntry(string, cONSTANT_Utf8_info);
        }
        return cONSTANT_Utf8_info;
    }

    private CONSTANT_Utf8_info addExtraUtf8(String string) {
        CONSTANT_Utf8_info cONSTANT_Utf8_info = new CONSTANT_Utf8_info(string);
        this.addEntry(null, cONSTANT_Utf8_info);
        return cONSTANT_Utf8_info;
    }

    private int addString(String string) {
        CONSTANT_Utf8_info cONSTANT_Utf8_info = this.addUtf8Entry(string);
        int n2 = cONSTANT_Utf8_info.setAsString();
        if (n2 == 0) {
            n2 = this.addExtraUtf8(string).getIndex();
            cONSTANT_Utf8_info.setAlternative(n2);
        }
        return this.addIndexReference(8, n2, 0);
    }

    protected void cptPut(ClassFormatOutput classFormatOutput) throws IOException {
        Enumeration<ConstantPoolEntry> enumeration = this.cptEntries.elements();
        while (enumeration.hasMoreElements()) {
            ConstantPoolEntry constantPoolEntry = enumeration.nextElement();
            if (constantPoolEntry == null) continue;
            constantPoolEntry.put(classFormatOutput);
        }
    }

    public ConstantPoolEntry getEntry(int n2) {
        return this.cptEntries.get(n2);
    }

    protected String className(int n2) {
        CONSTANT_Index_info cONSTANT_Index_info = (CONSTANT_Index_info)this.getEntry(n2);
        return this.nameIndexToString(cONSTANT_Index_info.getI1()).replace('/', '.');
    }

    int findUtf8(String string) {
        ConstantPoolEntry constantPoolEntry = this.findMatchingEntry(string);
        if (constantPoolEntry == null) {
            return -1;
        }
        return constantPoolEntry.getIndex();
    }

    public int findClass(String string) {
        String string2 = ClassHolder.convertToInternalClassName(string);
        int n2 = this.findUtf8(string2);
        if (n2 < 0) {
            return -1;
        }
        return this.findIndexIndex(7, n2, 0);
    }

    public int findNameAndType(String string, String string2) {
        int n2 = this.findUtf8(string);
        if (n2 < 0) {
            return -1;
        }
        int n3 = this.findUtf8(string2);
        if (n3 < 0) {
            return -1;
        }
        return this.findIndexIndex(12, n2, n3);
    }

    protected CONSTANT_Index_info findIndexEntry(int n2, int n3, int n4) {
        this.searchIndex.set(n2, n3, n4);
        return (CONSTANT_Index_info)this.findMatchingEntry(this.searchIndex);
    }

    protected int findIndexIndex(int n2, int n3, int n4) {
        CONSTANT_Index_info cONSTANT_Index_info = this.findIndexEntry(n2, n3, n4);
        if (cONSTANT_Index_info == null) {
            return -1;
        }
        return cONSTANT_Index_info.getIndex();
    }

    protected ConstantPoolEntry findMatchingEntry(Object object) {
        return this.cptHashTable.get(object);
    }

    String nameIndexToString(int n2) {
        return this.getEntry(n2).toString();
    }

    protected String getClassName(int n2) {
        if (n2 == 0) {
            return "";
        }
        return this.nameIndexToString(this.getEntry(n2).getI1());
    }

    public static boolean isExternalClassName(String string) {
        if (string.indexOf(46) != -1) {
            return true;
        }
        int n2 = string.length();
        if (n2 == 0) {
            return false;
        }
        return string.charAt(n2 - 1) == ']';
    }

    public static String convertToInternalClassName(String string) {
        return ClassHolder.convertToInternal(string, false);
    }

    public static String convertToInternalDescriptor(String string) {
        return ClassHolder.convertToInternal(string, true);
    }

    private static String convertToInternal(String string, boolean bl) {
        int n2 = string.length();
        String string2 = null;
        int n3 = n2;
        int n4 = 0;
        if (string.charAt(n2 - 1) == ']') {
            while (n2 > 0 && string.charAt(n2 - 1) == ']' && string.charAt(n2 - 2) == '[') {
                n2 -= 2;
                ++n4;
            }
        }
        String string3 = n3 == n2 ? string : string.substring(0, n2);
        switch (n2) {
            case 7: {
                if (!"boolean".equals(string3)) break;
                string2 = ClassHolder.makeDesc('Z', n4);
                break;
            }
            case 4: {
                if ("void".equals(string3)) {
                    string2 = ClassHolder.makeDesc('V', n4);
                    break;
                }
                if ("long".equals(string3)) {
                    string2 = ClassHolder.makeDesc('J', n4);
                    break;
                }
                if ("byte".equals(string3)) {
                    string2 = ClassHolder.makeDesc('B', n4);
                    break;
                }
                if (!"char".equals(string3)) break;
                string2 = ClassHolder.makeDesc('C', n4);
                break;
            }
            case 3: {
                if (!"int".equals(string3)) break;
                string2 = ClassHolder.makeDesc('I', n4);
                break;
            }
            case 6: {
                if (!"double".equals(string3)) break;
                string2 = ClassHolder.makeDesc('D', n4);
                break;
            }
            case 5: {
                if ("short".equals(string3)) {
                    string2 = ClassHolder.makeDesc('S', n4);
                    break;
                }
                if (!"float".equals(string3)) break;
                string2 = ClassHolder.makeDesc('F', n4);
            }
        }
        if (string2 == null) {
            string2 = ClassHolder.makeDesc(string3, n4, bl);
        }
        return string2;
    }

    private static String makeDesc(char c2, int n2) {
        if (n2 == 0) {
            switch (c2) {
                case 'B': {
                    return "B";
                }
                case 'C': {
                    return "C";
                }
                case 'D': {
                    return "D";
                }
                case 'F': {
                    return "F";
                }
                case 'I': {
                    return "I";
                }
                case 'J': {
                    return "J";
                }
                case 'S': {
                    return "S";
                }
                case 'Z': {
                    return "Z";
                }
                case 'V': {
                    return "V";
                }
            }
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(n2 + 3);
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuffer.append('[');
        }
        stringBuffer.append(ClassHolder.makeDesc(c2, 0));
        return stringBuffer.toString();
    }

    private static String makeDesc(String string, int n2, boolean bl) {
        if (!bl && n2 == 0) {
            return string.replace('.', '/');
        }
        StringBuffer stringBuffer = new StringBuffer(n2 + 2 + string.length());
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuffer.append('[');
        }
        stringBuffer.append('L');
        stringBuffer.append(string.replace('.', '/'));
        stringBuffer.append(';');
        return stringBuffer.toString();
    }
}

