/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.services.io;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public abstract class ArrayUtil {
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];

    public static <T> T[] copy(T[] TArray) {
        return TArray == null ? null : Arrays.copyOf(TArray, TArray.length);
    }

    public static boolean[] copy(boolean[] blArray) {
        return blArray == null ? null : (boolean[])blArray.clone();
    }

    public static byte[] copy(byte[] byArray) {
        return byArray == null ? null : (byte[])byArray.clone();
    }

    public static int[] copy(int[] nArray) {
        return nArray == null ? null : (int[])nArray.clone();
    }

    public static long[] copy(long[] lArray) {
        return lArray == null ? null : (long[])lArray.clone();
    }

    public static int[][] copy2(int[][] nArray) {
        if (nArray == null) {
            return null;
        }
        int[][] nArrayArray = new int[nArray.length][];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            nArrayArray[i2] = ArrayUtil.copy(nArray[i2]);
        }
        return nArrayArray;
    }

    @SafeVarargs
    public static <T> List<T> asReadOnlyList(T ... TArray) {
        if (TArray == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(Arrays.asList(TArray));
    }

    public static void writeArrayLength(ObjectOutput objectOutput, Object[] objectArray) throws IOException {
        objectOutput.writeInt(objectArray.length);
    }

    public static void writeArrayItems(ObjectOutput objectOutput, Object[] objectArray) throws IOException {
        if (objectArray == null) {
            return;
        }
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            objectOutput.writeObject(objectArray[i2]);
        }
    }

    public static void writeArray(ObjectOutput objectOutput, Object[] objectArray) throws IOException {
        if (objectArray == null) {
            objectOutput.writeInt(0);
            return;
        }
        objectOutput.writeInt(objectArray.length);
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            objectOutput.writeObject(objectArray[i2]);
        }
    }

    public static void readArrayItems(ObjectInput objectInput, Object[] objectArray) throws IOException, ClassNotFoundException {
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            objectArray[i2] = objectInput.readObject();
        }
    }

    public static int readArrayLength(ObjectInput objectInput) throws IOException {
        return objectInput.readInt();
    }

    public static Object[] readObjectArray(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n2 = objectInput.readInt();
        if (n2 == 0) {
            return null;
        }
        Object[] objectArray = new Object[n2];
        ArrayUtil.readArrayItems(objectInput, objectArray);
        return objectArray;
    }

    public static void writeIntArray(ObjectOutput objectOutput, int[] nArray) throws IOException {
        if (nArray == null) {
            objectOutput.writeInt(0);
        } else {
            objectOutput.writeInt(nArray.length);
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                objectOutput.writeInt(nArray[i2]);
            }
        }
    }

    public static int[] readIntArray(ObjectInput objectInput) throws IOException {
        int n2 = objectInput.readInt();
        if (n2 == 0) {
            return null;
        }
        int[] nArray = new int[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            nArray[i2] = objectInput.readInt();
        }
        return nArray;
    }

    public static void writeInts(ObjectOutput objectOutput, int[][] nArray) throws IOException {
        if (nArray == null) {
            objectOutput.writeBoolean(false);
        } else {
            objectOutput.writeBoolean(true);
            int n2 = nArray.length;
            objectOutput.writeInt(n2);
            for (int i2 = 0; i2 < n2; ++i2) {
                ArrayUtil.writeIntArray(objectOutput, nArray[i2]);
            }
        }
    }

    public static int[][] readInts(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        Object object = null;
        if (objectInput.readBoolean()) {
            int n2 = objectInput.readInt();
            object = new int[n2][];
            for (int i2 = 0; i2 < n2; ++i2) {
                object[i2] = ArrayUtil.readIntArray(objectInput);
            }
        }
        return object;
    }

    public static String toString(int[] nArray) {
        if (nArray == null || nArray.length == 0) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            stringBuffer.append("[").append(nArray[i2]).append("],");
        }
        return stringBuffer.toString();
    }

    public static void writeLongArray(ObjectOutput objectOutput, long[] lArray) throws IOException {
        if (lArray == null) {
            objectOutput.writeInt(0);
        } else {
            objectOutput.writeInt(lArray.length);
            for (int i2 = 0; i2 < lArray.length; ++i2) {
                objectOutput.writeLong(lArray[i2]);
            }
        }
    }

    public static long[] readLongArray(ObjectInput objectInput) throws IOException {
        int n2 = objectInput.readInt();
        long[] lArray = new long[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            lArray[i2] = objectInput.readLong();
        }
        return lArray;
    }

    public static String[] readStringArray(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        Object[] objectArray = null;
        int n2 = ArrayUtil.readArrayLength(objectInput);
        if (n2 > 0) {
            objectArray = new String[n2];
            ArrayUtil.readArrayItems(objectInput, objectArray);
        }
        return objectArray;
    }

    public static void writeBooleanArray(ObjectOutput objectOutput, boolean[] blArray) throws IOException {
        if (blArray == null) {
            objectOutput.writeInt(0);
        } else {
            objectOutput.writeInt(blArray.length);
            for (int i2 = 0; i2 < blArray.length; ++i2) {
                objectOutput.writeBoolean(blArray[i2]);
            }
        }
    }

    public static boolean[] readBooleanArray(ObjectInput objectInput) throws IOException {
        int n2 = objectInput.readInt();
        boolean[] blArray = new boolean[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            blArray[i2] = objectInput.readBoolean();
        }
        return blArray;
    }
}

