/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.services.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.derby.iapi.services.io.Limit;

public class LimitInputStream
extends FilterInputStream
implements Limit {
    protected int remainingBytes;
    protected boolean limitInPlace;

    public LimitInputStream(InputStream inputStream) {
        super(inputStream);
        this.clearLimit();
    }

    @Override
    public int read() throws IOException {
        if (!this.limitInPlace) {
            return super.read();
        }
        if (this.remainingBytes == 0) {
            return -1;
        }
        int n2 = super.read();
        if (n2 >= 0) {
            --this.remainingBytes;
        }
        return n2;
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        if (!this.limitInPlace) {
            return super.read(byArray, n2, n3);
        }
        if (this.remainingBytes == 0) {
            return -1;
        }
        if (this.remainingBytes < n3) {
            n3 = this.remainingBytes;
        }
        if ((n3 = super.read(byArray, n2, n3)) > 0) {
            this.remainingBytes -= n3;
        }
        return n3;
    }

    @Override
    public long skip(long l2) throws IOException {
        if (!this.limitInPlace) {
            return super.skip(l2);
        }
        if (this.remainingBytes == 0) {
            return 0L;
        }
        if ((long)this.remainingBytes < l2) {
            l2 = this.remainingBytes;
        }
        l2 = super.skip(l2);
        this.remainingBytes = (int)((long)this.remainingBytes - l2);
        return l2;
    }

    @Override
    public int available() throws IOException {
        if (!this.limitInPlace) {
            return super.available();
        }
        if (this.remainingBytes == 0) {
            return 0;
        }
        int n2 = super.available();
        if (this.remainingBytes < n2) {
            return this.remainingBytes;
        }
        return n2;
    }

    @Override
    public void setLimit(int n2) {
        this.remainingBytes = n2;
        this.limitInPlace = true;
    }

    @Override
    public int clearLimit() {
        int n2 = this.remainingBytes;
        this.limitInPlace = false;
        this.remainingBytes = -1;
        return n2;
    }

    public void setInput(InputStream inputStream) {
        this.in = inputStream;
    }

    @Override
    public boolean markSupported() {
        return false;
    }
}

